<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_shop_provider_yadore extends atkp_shop_provider_base {
	//das ist die basis klasse für alle shop provider

	public function __construct() {

	}

	public function get_caption() {
		return __( 'Yadore API', ATKP_PLUGIN_PREFIX );
	}

	public function get_defaultlogo() {
		return '';
	}

	public function get_maxproductcount() {
		return 100;
	}

	public function retrieve_browsenodes( $keyword ) {

	}

	private $apikey = '';
	private $market = 'de';

	private function send_request( $query ) {


		$result1 = wp_remote_get( $query, array(
			'timeout' => 30,
			'headers' => array(
				'accept'  => 'application/json',
				'API-Key' => $this->apikey
			)
		) );

		if ( is_wp_error( $result1 ) ) {
			$error_string = $result1->get_error_message();

			throw new Exception( $error_string );
		} else {
			$results = json_decode( $result1['body'], true );
		}

		return $results;
	}

	public function check_configuration( $post_id ) {
		try {
			$apikey = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_key' );
			$market = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_market' );

			$message = '';
			if ( $apikey != '' ) {


				$this->apikey = $apikey;
				$this->market = $market;

				$subshopsold = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops' );

				$results = $this->send_request( 'https://api.yadore.com/v1/merchant?market=' . $this->market );

				$subshops = array();

				foreach ( $results['response']['merchants'] as $merchant ) {
					$subshop            = new subshop();
					$subshop->title     = $merchant['name'];
					$subshop->programid = $subshop->shopid = $merchant['id'];

					if ( $merchant['logo']['exists'] ) {
						$subshop->logourl = $subshop->smalllogourl = $this->checkimageurl( $merchant['logo']['url'], true );
					}

					array_push( $subshops, $subshop );
				}


				//für bestehende alte subshops ist dieser teil noch drinnen
				if ( is_array( $subshopsold ) ) {
					foreach ( $subshopsold as $shopold ) {
						if ( $subshop->shopid == $shopold->shopid && $subshop->programid == $shopold->programid ) {
							$subshop->enabled            = $shopold->enabled;
							$subshop->customtitle        = $shopold->customtitle;
							$subshop->customsmalllogourl = $shopold->customsmalllogourl;
							$subshop->customlogourl      = $shopold->customlogourl;
							$subshop->customfield1       = $shopold->customfield1;
							$subshop->customfield2       = $shopold->customfield2;
							$subshop->customfield3       = $shopold->customfield3;
						}
					}
				}

				ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops', $subshops );


			} else {
				//wenn zugangscodes gelöscht werden muss message auch geleert werden
				$message = 'Credientials are empty';
			}

			return $message;
		} catch ( Exception $e ) {
			if ( ATKPLog::$logenabled ) {
				ATKPLog::LogError( $e->getMessage() );
			}

			return $e->getMessage();
		}
	}

	public function set_configuration( $post_id ) {

		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_key', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_yadore_access_key', 'string' ) );
		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_market', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_yadore_market', 'string' ) );

		//  $subshops=  ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE.'_default_shops');

		// if(is_array($subshops))
		//    $this->read_subshop_settings($subshops, 'zanox');

		//echo serialize($subshops);exit;

		// ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE.'_default_shops', $subshops);
	}

	public function get_configuration( $post ) {
		$webservice = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_webservice' );

		$apikey = '';
		$market = '';


		if ( $webservice == '12' ) {
			$apikey = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_key' );
			$market = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_market' );

			$subshops = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_default_shops' );
		}
		?>
        <tr valign="top">
            <th scope="row">
                <label for="">
					<?php _e( 'API Key', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
                <input style="width:40%" type="text" id="<?php echo ATKP_SHOP_POSTTYPE . '_yadore_access_key' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_yadore_access_key' ?>" value="<?php echo $apikey; ?>">
                <label for="">
                </label>
            </td>
        </tr>
        <tr valign="top">
            <th scope="row">
                <label for="">
					<?php _e( 'Market', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
                <input style="width:20%" type="text"
                       id="<?php echo ATKP_SHOP_POSTTYPE . '_yadore_market' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_yadore_market' ?>"
                       value="<?php echo $market; ?>">
            </td>
        </tr>


		<?php
	}

	public function get_shops( $post_id, $allshops = false ) {
		$shops = array();

		$subshops = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops' );

		if ( is_array( $subshops ) ) {
			foreach ( $subshops as $subshop ) {
				if ( $subshop->enabled || $allshops ) {
					$subshop->shopid2 = $subshop->shopid;
					$subshop->shopid  = $post_id . '_' . $subshop->programid . '_' . $subshop->shopid;


					$subshop->logourl      = $subshop->customlogourl == '' ? $subshop->logourl : $subshop->customlogourl;
					$subshop->smalllogourl = $subshop->customsmalllogourl == '' ? $subshop->smalllogourl : $subshop->customsmalllogourl;
					$subshop->title        = $subshop->customtitle == '' ? $subshop->title : $subshop->customtitle;

					array_push( $shops, $subshop );
				}
			}
		}

		return $shops;
	}

	private $shopid = null;
	private $enable_ssl = false;

	public function checklogon( $shop ) {

		$apikey           = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_access_key' );
		$market           = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_market' );
		$this->enable_ssl = true;

		$this->apikey = $apikey;
		$this->market = $market;

		$this->shopid = $shop->shopid;
	}

	public function quick_search( $keyword, $searchType, $pagination = 1 ) {
		if ( $this->apikey == null ) {
			throw new Exception( 'checklogon required' );
		}


		$products = new atkp_search_resp();

		$maxCount = 20;

		$offset = $maxCount * ($pagination-1);

        switch ( $searchType ) {
            case 'asin':
                $results = $this->send_request( 'https://api.yadore.com/v1/offer?market=' . $this->market . '&merchantId=' . urlencode( $this->shopid ) . '&offerId=' . urlencode( $keyword ) . '&offset=' . $offset . '&limit=' . $maxCount );
                break;
            case 'ean':
                $results = $this->send_request( 'https://api.yadore.com/v1/offer?market=' . $this->market . '&merchantId=' . urlencode( $this->shopid ) . '&ean=' . urlencode( $keyword ) . '&offset=' . $offset . '&limit=' . $maxCount );
                break;
            default:
                $results = $this->send_request( 'https://api.yadore.com/v1/offer?market=' . $this->market . '&merchantId=' . urlencode( $this->shopid ) . '&precision=strict&keyword=' . urlencode( $keyword ) . '&offset=' . $offset . '&limit=' . $maxCount );
                break;
        }

        //var_dump($results);
        //exit;

		$products->total = intval($results['result']['total']);
		$products->currentpage = intval($pagination);
		$products->pagecount = ceil(floatval($products->total ) / floatval($maxCount));


        if ( isset( $results ) ) {
            foreach ( $results['result']['offers'] as $result ) {
                $product = array();
                //info: je nach anbieter wird entweder small oder large zurückgeliefert?!

                if ( array_key_exists( 'image', $result ) ) {
                    $product['imageurl'] = $this->checkimageurl( $result['image']['url'] );
                } else {
                    $product['imageurl'] = $this->checkimageurl( $result['thumbnail']['url'] );
                }
                $product['asin']        = $result['id'];
                $product['producturl']  = ATKPTools::check_sslurl( $result['clickUrl'] );
                $product['title']       = $result['title'];
                $product['ean']         = isset( $result['ean'] ) ? $result['ean'] : '';
                $product['description'] = $result['description'];
                $product['features']    = $result['promoText'];
                $product['brand']       = $result['brand'];

                $product['saleprice'] = $result['price']['integral'];

                if ( strlen( $product['saleprice'] ) > 2 ) {
                    $product['saleprice'] = substr( $product['saleprice'], 0, strlen( $product['saleprice'] ) - 2 ) . ',' . substr( $product['saleprice'], strlen( $product['saleprice'] ) - 2, 2 );
                }

                $product['availability'] = $result['availability'];
                $product['shipping']     = $result['shipping']['text'] != 'NULL' ? $result['shipping']['text'] : '';

                if ( $result['id'] != '' ) {
                    array_push( $products->products, $product );
                }

            }
        }



		return $products;
	}

	private function checkimageurl( $url, $enable_ssl = null ) {

		if ( $enable_ssl == null ) {
			$enable_ssl = $this->enable_ssl;
		}

		if ( $enable_ssl ) {
			$url = str_replace( 'http://', 'https://', $url );
		}

		return $url;
	}

	private function fill_product( $result ) {
		if ( ATKPLog::$logenabled ) {
			ATKPLog::LogDebug( '*** fill_product zanox ***' );
			ATKPLog::LogDebug( serialize( $result ) );
			ATKPLog::LogDebug( '*** fill_product zanox ***' );
		}

//echo serialize($result);exit;

		$myproduct = new atkp_product();

		$myproduct->updatedon = ATKPTools::get_currenttime();
		$myproduct->shopid    = $this->shopid;

		$myproduct->features    = $result['promoText'];
		$myproduct->description = $result['description'];

		$myproduct->title = $result['title'];;
		$myproduct->asin = $result['id'];
		$myproduct->ean  = isset( $result['ean'] ) ? $result['ean'] : '';

		$myproduct->smallimageurl  = $this->checkimageurl( $result['thumbnail']['url'] );
		$myproduct->mediumimageurl = $this->checkimageurl( $result['image']['url'] );
		$myproduct->largeimageurl  = $this->checkimageurl( $result['image']['url'] );


		$myproduct->producturl = ATKPTools::check_sslurl( $result['clickUrl'] );

		$myproduct->availability = $result['availability'];

		$myproduct->saleprice = $result['price']['integral'];

		if ( strlen( $myproduct->saleprice ) > 2 ) {
			$myproduct->saleprice = substr( $myproduct->saleprice, 0, strlen( $myproduct->saleprice ) - 2 ) . ',' . substr( $myproduct->saleprice, strlen( $myproduct->saleprice ) - 2, 2 );
		}

		$myproduct->salepricefloat = $this->price_to_float( $myproduct->saleprice );

		$myproduct->shipping      = $result['shipping']['text'] != 'NULL' ? $result['shipping']['text'] : '';
		$myproduct->shippingfloat = $this->price_to_float( $myproduct->shipping );

		$myproduct->brand = $result['brand'];


		return $myproduct;


	}

	function cmp( $a, $b ) {

		return strcasecmp( $a['caption'], $b['caption'] );
	}

	public function retrieve_departments() {
		if ( $this->apikey == null ) {
			throw new Exception( 'checklogon required' );
		}

		$departments = array();

		$departments['AllCategories'] = array(
			'caption' => __( 'All categories', ATKP_PLUGIN_PREFIX )
		);

		$results = $this->send_request( 'https://api.yadore.com/v1/category?market=' . $this->market );


		$cats = $results['response']['categories'];


		foreach ( $cats as $result ) {


			$departments[ $result['id'] ] = array(
				'caption'    => html_entity_decode( $result['name'] ),
				'sortvalues' => array(
					'rel_desc'   => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
					'price_asc'  => __( 'Price ascending', ATKP_PLUGIN_PREFIX ),
					'price_desc' => __( 'Price descending', ATKP_PLUGIN_PREFIX ),
				)
			);
		}


		uasort( $departments, array( $this, 'cmp' ) );


		return $departments;


		//return $this->azhelper->retrieve_departments();
	}

	public function retrieve_filters() {
		$durations = array(
			''         => __( 'Not selected', ATKP_PLUGIN_PREFIX ),
			'Keywords' => __( 'Keywords', ATKP_PLUGIN_PREFIX ),
			'Partner'  => __( 'Partner', ATKP_PLUGIN_PREFIX ),

		);

		return $durations;
	}

	public function retrieve_products( $asins, $id_type = 'ASIN' ) {
		$atkpresponse = new atkp_response();

		if ( count( $asins ) == 0 ) {
			return $atkpresponse;
		}

		foreach ( $asins as $asin ) {
			$resultlist = null;
			try {
				switch ( $id_type ) {
					case 'ASIN':
						$results = $this->send_request( 'https://api.yadore.com/v1/offer?market=' . $this->market . '&merchantId=' . urlencode( $this->shopid ) . '&offerId=' . urlencode( $asin ) );
						break;
					case 'EAN':
						$results = $this->send_request( 'https://api.yadore.com/v1/offer?market=' . $this->market . '&merchantId=' . urlencode( $this->shopid ) . '&ean=' . urlencode( $asin ) );
						break;
					case 'TITLE':
						$results = $this->send_request( 'https://api.yadore.com/v1/offer?market=' . $this->market . '&merchantId=' . urlencode( $this->shopid ) . '&precision=strict&keyword=' . urlencode( $asin ) );

						break;
					default:
						throw new exception( 'unknown id_type:' . $id_type );
				}
			} catch ( Exception $e ) {
				$titlecheck = $e->getMessage();
			}


			$productfound = false;

			if ( empty( $titlecheck ) && isset( $results ) ) {
				foreach ( $results['result']['offers'] as $result ) {

					$product              = new atkp_response_item();
					$product->productitem = $this->fill_product( $result );
					$product->uniquetype  = $id_type;
					$product->uniqueid    = $asin;

					array_push( $atkpresponse->responseitems, $product );
					$productfound = true;
					break;
				}
			}

			if ( ! $productfound ) {
				$product               = new atkp_response_item();
				$product->errormessage = empty( $titlecheck ) ? 'product not found' : $titlecheck;
				$product->uniqueid     = $asin;
				$product->uniquetype   = $id_type;

				array_push( $atkpresponse->responseitems, $product );
			}
			sleep( 1 );
		}

		return $atkpresponse;
	}

	public function retrieve_list( $requestType, $nodeid, $keyword, $asin, $maxCount, $sortOrder, $filters ) {
		$mylist            = new atkp_list_resp();
		$mylist->updatedon = ATKPTools::get_currenttime();
		$mylist->asins     = array();

		if ( $nodeid == 'AllCategories' ) {
			$nodeid = '';
		}

		//$shopids = explode('_',$this->shopid);

		$partner = null;

		foreach ( $filters as $field => $value ) {
			switch ( $field ) {
				case 'Keywords':
					$keyword = $value;
					break;
				case 'Partner':
					$partner = $value;
					break;
			}
		}


		switch ( $requestType ) {
			case 'ExtendedSearch':
			case 'Search':
				break;
			default:
				throw new Exception( 'requestType not supported: ' . $requestType );
		}

		$results  = null;
		$products = array();

		$itemsperpage = 100;
		$itemsperpage = $itemsperpage > $maxCount ? $maxCount : $itemsperpage;

		$pages = ceil($maxCount / $itemsperpage);

		for ($x = 1; $x <= $pages; $x++) {
			$query = 'https://api.yadore.com/v1/offer?market=' . $this->market . '&merchantId=' . urlencode( $this->shopid ) . '&precision=strict&keyword=' . urlencode( $keyword ) . '&offset=' . ( $itemsperpage * $x ) . '&limit=' . $itemsperpage;

			if ( $partner != '' ) {
				$query .= '&partner=' . urlencode( $partner );
			}
			if ( $nodeid != '' ) {
				$query .= '&categoryId=' . urlencode( $nodeid );
			}
			if ( $sortOrder != '' ) {
				$query .= '&sort=' . urlencode( $sortOrder );
			}

			$results = $this->send_request( $query );


			//searchProducts ( $query, $searchType = 'phrase',
			//$region = NULL, $categoryId = NULL, $programs = array(),
			//$hasImages = true, $minPrice = 0, $maxPrice = NULL, $adspaceId = NULL,
			//$page = 0, $items = 10 )

			if ( isset( $results ) ) {
				foreach ( $results['result']['offers'] as $result ) {

					array_push( $products, $this->fill_product( $result ) );

					if ( count( $products ) >= $maxCount ) {
						break;
					}
				}
			}

			if((!isset( $results ) || count($results['result']['offers']) == 0) || count($products) >= $maxCount)
				break;

		}

		$mylist->products = $products;

		return $mylist;
	}

	public function get_supportedlistsources() {
		return '20,30';
	}


}