<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_filter_helper {
	public $max_num_pages;
	public $found_posts;

	public function parse_params_filter( $filter = '', $parseparams = false ) {

		//*** Parse url parameters and merge existing filter array *** //

		if ( $filter == '' ) {
			$filterparams = null;
		} else {
			parse_str( str_replace( '&amp;', '&', $filter ), $filterparams );
		}


		$newfields  = atkp_udfield::load_fields();
		$taxonomies = atkp_udtaxonomy::load_taxonomies();

		//die seite muss auch one parseparams gelesen werden
		if ( ATKPTools::exists_get_parameter( 'tpage' ) ) {
			$filterparams['paged'] = ATKPTools::get_get_parameter( 'tpage', 'int' );
		}

		if ( $parseparams ) {
			if ( ATKPTools::exists_get_parameter( 'search' ) ) {
				$filterparams['search'] = ATKPTools::get_get_parameter( 'search', 'string' );
			}
			if ( ATKPTools::exists_get_parameter( 'product1' ) ) {
				$filterparams['product1'] = ATKPTools::get_get_parameter( 'product1', 'int' );
			}
			if ( ATKPTools::exists_get_parameter( 'product2' ) ) {
				$filterparams['product2'] = ATKPTools::get_get_parameter( 'product2', 'int' );
			}
			if ( ATKPTools::exists_get_parameter( 'product3' ) ) {
				$filterparams['product3'] = ATKPTools::get_get_parameter( 'product3', 'int' );
			}
			if ( ATKPTools::exists_get_parameter( 'product4' ) ) {
				$filterparams['product4'] = ATKPTools::get_get_parameter( 'product4', 'int' );
			}
			if ( ATKPTools::exists_get_parameter( 'product5' ) ) {
				$filterparams['product5'] = ATKPTools::get_get_parameter( 'product5', 'int' );
			}
			if ( ATKPTools::exists_get_parameter( 'minprice' ) && ATKPTools::exists_get_parameter( 'maxprice' ) ) {
				$filterparams['minprice'] = ATKPTools::get_get_parameter( 'minprice', 'int' );
				$filterparams['maxprice'] = ATKPTools::get_get_parameter( 'maxprice', 'int' );
			}
			if ( ATKPTools::exists_get_parameter( 'orderby' ) ) {
				$filterparams['orderby'] = ATKPTools::get_get_parameter( 'orderby', 'string' );
			}

			foreach ( $newfields as $newfield ) {
				$fieldname = 'customfield_' . $newfield->name;

				switch ( $newfield->type ) {
					case 3:
						//dropdown
						if ( ATKPTools::exists_get_parameter( $fieldname ) ) {
							$filterparams[ $fieldname ] = ATKPTools::get_get_parameter( $fieldname, 'stringarray' );
						}
						break;
					case 4:
						//yes no
						if ( ATKPTools::exists_get_parameter( $fieldname ) ) {
							$filterparams[ $fieldname ] = ATKPTools::get_get_parameter( $fieldname, 'bool' );
						}
						break;
					case 1:
						//range

						if ( $newfield->format == 'number' ) {
							if ( ATKPTools::exists_get_parameter( 'min' . $fieldname ) ) {
								$filterparams[ 'min' . $fieldname ] = ATKPTools::get_get_parameter( 'min' . $fieldname, 'int' );
							}
							if ( ATKPTools::exists_get_parameter( 'max' . $fieldname ) ) {
								$filterparams[ 'max' . $fieldname ] = ATKPTools::get_get_parameter( 'max' . $fieldname, 'int' );
							}
						}
						break;
				}
			}


			if ( get_option( ATKP_PLUGIN_PREFIX . '_fieldgroups_enabled', false ) ) {
				$groups = ATKPTools::get_fieldgroups();

				foreach ( $groups as $group ) {

					$fields = ATKPTools::get_post_setting( $group->ID, ATKP_FIELDGROUP_POSTTYPE . '_fields' );
					if ( $fields != null ) {
						foreach ( $fields as $newfield ) {
							$fieldname = 'cf_' . $newfield->name;

							switch ( $newfield->type ) {
								case 3:
									//dropdown
									if ( ATKPTools::exists_get_parameter( $fieldname ) ) {
										$filterparams[ $fieldname ] = ATKPTools::get_get_parameter( $fieldname, 'stringarray' );
									}
									break;
								case 4:
									//yes no
									if ( ATKPTools::exists_get_parameter( $fieldname ) ) {
										$filterparams[ $fieldname ] = ATKPTools::get_get_parameter( $fieldname, 'bool' );
									}
									break;
								case 1:
									//range

									if ( $newfield->format == 'number' ) {
										if ( ATKPTools::exists_get_parameter( 'min' . $fieldname ) ) {
											$filterparams[ 'min' . $fieldname ] = ATKPTools::get_get_parameter( 'min' . $fieldname, 'int' );
										}
										if ( ATKPTools::exists_get_parameter( 'max' . $fieldname ) ) {
											$filterparams[ 'max' . $fieldname ] = ATKPTools::get_get_parameter( 'max' . $fieldname, 'int' );
										}
									}
									break;
							}
						}
					}
				}
			}


			if ( $taxonomies != null ) {
				foreach ( $taxonomies as $taxonomy ) {
					$fieldname = $taxonomy->get_fieldname();

					//combo mit dropdown
					if ( ATKPTools::exists_get_parameter( $fieldname ) ) {
						$filterparams[ $fieldname ] = ATKPTools::get_get_parameter( $fieldname, 'intarray' );
					}
				}
			}
		}

		return $filterparams;
	}

	public function parse_params_products( $itemsPerPage = 25, $parseparams = false, $filter = '' ) {
		$productlist = array();

		//*** Parse url parameters and merge existing filter array *** //
		$filterparams = $this->parse_params_filter( $filter, $parseparams );

		$newfields  = atkp_udfield::load_fields();
		$taxonomies = atkp_udtaxonomy::load_taxonomies();

		$args = array(
			'posts_per_page'         => intval( $itemsPerPage ),
			'posts_per_archive_page' => intval( $itemsPerPage ),
			'post_type'              => array( ATKP_PRODUCT_POSTTYPE ),
			'post_status'            => array( 'publish' ),
			'meta_query'             => array(),
			'tax_query'              => array(),
			'relation'               => 'AND'
		);

		if ( isset( $filterparams['paged'] ) ) {
			$args['paged'] = intval( $filterparams['paged'] );
		} else {
			$args['paged'] = 1;
		}

		$criteriaExists = false;

		if ( isset( $filterparams['search'] ) ) {
			$args['s']      = strval( $filterparams['search'] );
			$criteriaExists = true;
		}

		$productids = array();
		if ( isset( $filterparams['product1'] ) ) {
			array_push( $productids, intval( $filterparams['product1'] ) );
		}
		if ( isset( $filterparams['product2'] ) ) {
			array_push( $productids, intval( $filterparams['product2'] ) );
		}
		if ( isset( $filterparams['product3'] ) ) {
			array_push( $productids, intval( $filterparams['product3'] ) );
		}
		if ( isset( $filterparams['product4'] ) ) {
			array_push( $productids, intval( $filterparams['product4'] ) );
		}
		if ( isset( $filterparams['product5'] ) ) {
			array_push( $productids, intval( $filterparams['product5'] ) );
		}

		if ( count( $productids ) > 0 ) {
			$args['post__in'] = $productids;
			$criteriaExists   = true;
		}

		$minprice = 0;
		$maxprice = 0;
		if ( isset( $filterparams['minprice'] ) && isset( $filterparams['maxprice'] ) ) {
			$minprice = intval( $filterparams['minprice'] );
			$maxprice = intval( $filterparams['maxprice'] );

			if ( $minprice == 0 ) {
				array_push( $args['meta_query'], array(
					'relation' => 'OR',
					array(
						'key'     => ATKP_PRODUCT_POSTTYPE . '_salepricefloat',
						'compare' => 'NOT EXISTS',
					),
					array(
						'key'     => ATKP_PRODUCT_POSTTYPE . '_salepricefloat',
						'value'   => array( $minprice, $maxprice ),
						'compare' => 'BETWEEN',
						'type'    => 'numeric'
					)
				) );


			} else {
				array_push( $args['meta_query'],
					array(
						'key'     => ATKP_PRODUCT_POSTTYPE . '_salepricefloat',
						'value'   => array( $minprice, $maxprice ),
						'compare' => 'BETWEEN',
						'type'    => 'numeric'
					) );
			}

			$criteriaExists = true;
		}

		//if(!$criteriaExists) {
		//    return __('Search criteria is required.', ATKP_PLUGIN_PREFIX);
		//}

		if ( isset( $filterparams['orderby'] ) ) {
			$orderBy = strval( $filterparams['orderby'] );

			switch ( $orderBy ) {
				case 'price-asc':
					$args['orderby']  = 'meta_value_num';
					$args['meta_key'] = ATKP_PRODUCT_POSTTYPE . '_salepricefloat';
					$args['order']    = 'ASC';
					break;
				case 'price-desc':
					$args['orderby']  = 'meta_value_num';
					$args['meta_key'] = ATKP_PRODUCT_POSTTYPE . '_salepricefloat';
					$args['order']    = 'DESC';
					break;
				case 'titlerank-asc':
					$args['orderby']  = 'meta_value';
					$args['meta_key'] = ATKP_PRODUCT_POSTTYPE . '_title';
					$args['order']    = 'ASC';
					break;
				case 'titlerank-desc':
					$args['orderby']  = 'meta_value';
					$args['meta_key'] = ATKP_PRODUCT_POSTTYPE . '_title';
					$args['order']    = 'DESC';
					break;
			}
		}


		foreach ( $newfields as $newfield ) {
			$fieldname = 'customfield_' . $newfield->name;

			switch ( $newfield->type ) {
				case 3:
					//dropdown
					$dropdown = isset( $filterparams[ $fieldname ] ) ? ( is_array( $filterparams[ $fieldname ] ) ? $filterparams[ $fieldname ] : explode( ',', $filterparams[ $fieldname ] ) ) : null;

					if ( $dropdown != null && count( $dropdown ) > 0 ) {
						array_push( $args['meta_query'],
							array(
								'key'     => ATKP_PRODUCT_POSTTYPE . '_' . $fieldname,
								'value'   => $dropdown,
								'compare' => 'IN',
								'type'    => 'CHAR'
							) );

						$criteriaExists = true;
					}

					break;
				case 4:
					//yes no
					$yesno = isset( $filterparams[ $fieldname ] ) ? boolval( $filterparams[ $fieldname ] ) : false;

					if ( $yesno != null && $yesno == true ) {
						array_push( $args['meta_query'],
							array(
								'key'     => ATKP_PRODUCT_POSTTYPE . '_' . $fieldname,
								'value'   => $yesno,
								'compare' => '=',
								'type'    => 'NUMERIC'
							) );

						$criteriaExists = true;
					}

					break;
				case 1:
					//range
					if ( $newfield->format == 'number' ) {
						$minnumber = isset( $filterparams[ 'min' . $fieldname ] ) ? intval( $filterparams[ 'min' . $fieldname ] ) : null;
						$maxnumber = isset( $filterparams[ 'max' . $fieldname ] ) ? intval( $filterparams[ 'max' . $fieldname ] ) : null;


						if ( ( $minnumber != null || $minnumber == 0 ) && $maxnumber != null ) {

							if ( $minnumber == 0 ) {
								array_push( $args['meta_query'], array(
									'relation' => 'OR',
									array(
										'key'     => ATKP_PRODUCT_POSTTYPE . '_' . $fieldname,
										'compare' => 'NOT EXISTS',
									),
									array(
										'key'     => ATKP_PRODUCT_POSTTYPE . '_' . $fieldname,
										'value'   => array( $minnumber, $maxnumber ),
										'compare' => 'BETWEEN',
										'type'    => 'numeric'
									)
								) );


							} else {
								array_push( $args['meta_query'],
									array(
										'key'     => ATKP_PRODUCT_POSTTYPE . '_' . $fieldname,
										'value'   => array( $minnumber, $maxnumber ),
										'compare' => 'BETWEEN',
										'type'    => 'numeric'
									) );

								$criteriaExists = true;
							}
						}


					}
					break;
			}
		}

		if ( get_option( ATKP_PLUGIN_PREFIX . '_fieldgroups_enabled', false ) ) {
			$groups = ATKPTools::get_fieldgroups();

			foreach ( $groups as $group ) {

				$fields = ATKPTools::get_post_setting( $group->ID, ATKP_FIELDGROUP_POSTTYPE . '_fields' );
				if ( $fields != null ) {
					foreach ( $fields as $newfield ) {
						$fieldname = 'cf_' . $newfield->name;

						switch ( $newfield->type ) {
							case 3:
								//dropdown
								$dropdown = isset( $filterparams[ $fieldname ] ) ? ( is_array( $filterparams[ $fieldname ] ) ? $filterparams[ $fieldname ] : explode( ',', $filterparams[ $fieldname ] ) ) : null;

								if ( $dropdown != null && count( $dropdown ) > 0 ) {
									array_push( $args['meta_query'],
										array(
											'key'     => ATKP_PRODUCT_POSTTYPE . '_' . $fieldname,
											'value'   => $dropdown,
											'compare' => 'IN',
											'type'    => 'CHAR'
										) );

									$criteriaExists = true;
								}

								break;
							case 4:
								//yes no
								$yesno = isset( $filterparams[ $fieldname ] ) ? boolval( $filterparams[ $fieldname ] ) : false;

								if ( $yesno != null && $yesno == true ) {
									array_push( $args['meta_query'],
										array(
											'key'     => ATKP_PRODUCT_POSTTYPE . '_' . $fieldname,
											'value'   => $yesno,
											'compare' => '=',
											'type'    => 'NUMERIC'
										) );

									$criteriaExists = true;
								}

								break;
							case 1:
								//range
								if ( $newfield->format == 'number' ) {
									$minnumber = isset( $filterparams[ 'min' . $fieldname ] ) ? intval( $filterparams[ 'min' . $fieldname ] ) : null;
									$maxnumber = isset( $filterparams[ 'max' . $fieldname ] ) ? intval( $filterparams[ 'max' . $fieldname ] ) : null;


									if ( ( $minnumber != null || $minnumber == 0 ) && $maxnumber != null ) {

										if ( $minnumber == 0 ) {
											array_push( $args['meta_query'], array(
												'relation' => 'OR',
												array(
													'key'     => ATKP_PRODUCT_POSTTYPE . '_' . $fieldname,
													'compare' => 'NOT EXISTS',
												),
												array(
													'key'     => ATKP_PRODUCT_POSTTYPE . '_' . $fieldname,
													'value'   => array( $minnumber, $maxnumber ),
													'compare' => 'BETWEEN',
													'type'    => 'numeric'
												)
											) );


										} else {
											array_push( $args['meta_query'],
												array(
													'key'     => ATKP_PRODUCT_POSTTYPE . '_' . $fieldname,
													'value'   => array( $minnumber, $maxnumber ),
													'compare' => 'BETWEEN',
													'type'    => 'numeric'
												) );

											$criteriaExists = true;
										}
									}


								}
								break;
						}
					}
				}
			}
		}

		if ( $taxonomies != null ) {
			foreach ( $taxonomies as $taxonomy ) {
				$fieldname = $taxonomy->get_fieldname();

				//combo mit dropdown
				$number = isset( $filterparams[ $fieldname ] ) ? ( is_array( $filterparams[ $fieldname ] ) ? $filterparams[ $fieldname ] : array_map( 'intval', explode( ',', $filterparams[ $fieldname ] ) ) ) : null;

				if ( $number != null && count( $number ) > 0 ) {
					array_push( $args['tax_query'],
						array(
							'taxonomy' => $taxonomy->name, //or tag or custom taxonomy
							'field'    => 'id',
							'terms'    => $number
						) );

					$criteriaExists = true;
				}
			}
		}

		//var_dump($args);exit;

		$the_query = new WP_Query( $args );

		$this->max_num_pages = $the_query->max_num_pages;
		$this->found_posts   = $the_query->found_posts;


		while ( $the_query->have_posts() ) {

			$the_query->the_post();

			$prd = $the_query->post;

			$product = array();

			$product['type']  = 'productid';
			$product['value'] = $prd->ID;


			array_push( $productlist, $product );

		}

		wp_reset_postdata();

		if ( $productlist == null || count( $productlist ) == 0 ) {
			return '<span class="atkp-noproducts">' . __( 'No products found for these search criteria.', ATKP_PLUGIN_PREFIX ) . '</span>';
		} else {
			return $productlist;
		}
	}
}


?>