<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_amazon_helper_de {

	public function get_departments() {
		$departments = array();

		$departments['All']                = array(
			'caption' => __( 'All Departments', ATKP_PLUGIN_PREFIX )
		);
		$departments['UnboxVideo']         = array(
			'caption'    => __( 'Amazon Instant Video', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'date-desc-rank'  => __( 'Release date (descending)', ATKP_PLUGIN_PREFIX ),
				'popularity-rank' => __( 'Popularity', ATKP_PLUGIN_PREFIX ),
				'price-asc-rank'  => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'price-desc-rank' => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'relevancerank'   => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'review-rank'     => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['Pantry']             = array(
			'caption'    => __( 'Amazon Pantry', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'        => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'price'         => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'relevancerank' => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'    => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['MobileApps']         = array(
			'caption'    => __( 'Apps & Games', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'               => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'pmrank'               => __( 'Popular products', ATKP_PLUGIN_PREFIX ),
				'price'                => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'relevancerank'        => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'           => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'reviewrank_authority' => __( 'Customer reviews (descending)', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['Automotive']         = array(
			'caption'    => __( 'Car & Bike', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'        => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'price'         => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'relevancerank' => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'    => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'salesrank'     => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['Baby']               = array(
			'caption'    => __( 'Baby', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'        => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'price'         => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'psrank'        => __( 'Bestseller (lower value better)', ATKP_PLUGIN_PREFIX ),
				'relevancerank' => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'    => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'salesrank'     => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
				'titlerank'     => __( 'Alphabetic (A to Z)', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['Tools']              = array(
			'caption'    => __( 'DIY store', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'        => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'featured'      => __( 'Popular products', ATKP_PLUGIN_PREFIX ),
				'price'         => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'relevancerank' => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'    => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['Beauty']             = array(
			'caption'    => __( 'Beauty', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'        => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'price'         => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'relevancerank' => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'    => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'salesrank'     => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['Apparel']            = array(
			'caption'    => __( 'Clothing', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'        => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'price'         => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'relevancerank' => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'    => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'salesrank'     => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['Lighting']           = array(
			'caption'    => __( 'Lighting', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'               => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'price'                => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'relevancerank'        => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'           => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'reviewrank_authority' => __( 'Customer reviews (descending)', ATKP_PLUGIN_PREFIX ),
				'salesrank'            => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['Books']              = array(
			'caption'    => __( 'Books', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'            => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'-pubdate'          => __( 'Release date (old to latest)', ATKP_PLUGIN_PREFIX ),
				'-publication_date' => __( 'Release date (latest to old)', ATKP_PLUGIN_PREFIX ),
				'-titlerank'        => __( 'Alphabetic (Z to A)', ATKP_PLUGIN_PREFIX ),
				'-unit-sales'       => __( 'Sold units', ATKP_PLUGIN_PREFIX ),
				'inverse-pricerank' => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'price'             => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'pricerank'         => __( 'Price (ascending)', ATKP_PLUGIN_PREFIX ),
				'reviewrank'        => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'salesrank'         => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
				'titlerank'         => __( 'Alphabetic (A to Z)', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['OfficeProducts']     = array(
			'caption'    => __( 'Office supplies & stationary', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'        => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'price'         => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'relevancerank' => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'    => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'salesrank'     => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['PCHardware']         = array(
			'caption'    => __( 'Computer & supplies', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'               => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'launch_date'          => __( 'Release date (old to latest)', ATKP_PLUGIN_PREFIX ),
				'price'                => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'psrank'               => __( 'Bestseller (lower value better)', ATKP_PLUGIN_PREFIX ),
				'reviewrank'           => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'reviewrank_authority' => __( 'Customer reviews (descending)', ATKP_PLUGIN_PREFIX ),
				'salesrank'            => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
				'titlerank'            => __( 'Alphabetic (A to Z)', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['DVD']                = array(
			'caption'    => __( 'DVD & Blu-ray', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'     => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'-titlerank' => __( 'Alphabetic (Z to A)', ATKP_PLUGIN_PREFIX ),
				'price'      => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'salesrank'  => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
				'titlerank'  => __( 'Alphabetic (A to Z)', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['HealthPersonalCare'] = array(
			'caption'    => __( 'Drugstore & grooming', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'        => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'-titlerank'    => __( 'Alphabetic (Z to A)', ATKP_PLUGIN_PREFIX ),
				'price'         => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'relevancerank' => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'    => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'salesrank'     => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
				'titlerank'     => __( 'Alphabetic (A to Z)', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['Appliances']         = array(
			'caption'    => __( 'Electronic large equipment', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'               => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'price'                => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'relevancerank'        => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'           => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'reviewrank_authority' => __( 'Customer reviews (descending)', ATKP_PLUGIN_PREFIX ),
				'salesrank'            => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['Electronics']        = array(
			'caption'    => __( 'Electronics & photography', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'     => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'-titlerank' => __( 'Alphabetic (Z to A)', ATKP_PLUGIN_PREFIX ),
				'price'      => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'salesrank'  => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
				'titlerank'  => __( 'Alphabetic (A to Z)', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['ForeignBooks']       = array(
			'caption'    => __( 'Foreign books', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'            => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'-pubdate'          => __( 'Release date (old to latest)', ATKP_PLUGIN_PREFIX ),
				'-publication_date' => __( 'Release date (latest to old)', ATKP_PLUGIN_PREFIX ),
				'-titlerank'        => __( 'Alphabetic (Z to A)', ATKP_PLUGIN_PREFIX ),
				'-unit-sales'       => __( 'Sold units', ATKP_PLUGIN_PREFIX ),
				'inverse-pricerank' => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'price'             => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'pricerank'         => __( 'Price (ascending)', ATKP_PLUGIN_PREFIX ),
				'reviewrank'        => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'salesrank'         => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
				'titlerank'         => __( 'Alphabetic (A to Z)', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['VideoGames']         = array(
			'caption'    => __( 'Games', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-date'      => __( 'Release date (old to latest)', ATKP_PLUGIN_PREFIX ),
				'-price'     => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'-titlerank' => __( 'Alphabetic (Z to A)', ATKP_PLUGIN_PREFIX ),
				'price'      => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'salesrank'  => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
				'titlerank'  => __( 'Alphabetic (A to Z)', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['HomeGarden']         = array(
			'caption'    => __( 'Gardening', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'        => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'-titlerank'    => __( 'Alphabetic (Z to A)', ATKP_PLUGIN_PREFIX ),
				'price'         => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'relevancerank' => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'    => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'salesrank'     => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
				'titlerank'     => __( 'Alphabetic (A to Z)', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['GiftCards']          = array(
			'caption'    => __( 'Gift cards', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'               => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'date-desc-rank'       => __( 'Release date (descending)', ATKP_PLUGIN_PREFIX ),
				'price'                => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'relevancerank'        => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'           => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'reviewrank_authority' => __( 'Customer reviews (descending)', ATKP_PLUGIN_PREFIX ),
				'salesrank'            => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['PetSupplies']        = array(
			'caption'    => __( 'Pets', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'               => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'-price-new-bin'       => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'price'                => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'price-new-bin'        => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'relevancerank'        => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'           => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'reviewrank_authority' => __( 'Customer reviews (descending)', ATKP_PLUGIN_PREFIX ),
				'salesrank'            => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['Photo']              = array(
			'caption'    => __( 'Camera & Photography', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'        => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'-titlerank'    => __( 'Alphabetic (Z to A)', ATKP_PLUGIN_PREFIX ),
				'price'         => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'relevancerank' => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'    => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'salesrank'     => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
				'titlerank'     => __( 'Alphabetic (A to Z)', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['KindleStore']        = array(
			'caption'    => __( 'Kindle-Shop', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'        => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'daterank'      => __( 'Release date (latest to old)', ATKP_PLUGIN_PREFIX ),
				'price'         => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'relevancerank' => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'    => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'salesrank'     => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['Classical']          = array(
			'caption'    => __( 'Classical music', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'            => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'-pubdate'          => __( 'Release date (old to latest)', ATKP_PLUGIN_PREFIX ),
				'-publication_date' => __( 'Release date (latest to old)', ATKP_PLUGIN_PREFIX ),
				'-releasedate'      => __( 'Release date (latest to old)', ATKP_PLUGIN_PREFIX ),
				'-titlerank'        => __( 'Alphabetic (Z to A)', ATKP_PLUGIN_PREFIX ),
				'price'             => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'pubdate'           => __( 'Release date (latest to old)', ATKP_PLUGIN_PREFIX ),
				'publication_date'  => __( 'Release date (latest to old)', ATKP_PLUGIN_PREFIX ),
				'relevancerank'     => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'        => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'salesrank'         => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
				'titlerank'         => __( 'Alphabetic (A to Z)', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['Luggage']            = array(
			'caption'    => __( 'Suitcases, back packs & bags', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'               => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'date-desc-rank'       => __( 'Release date (descending)', ATKP_PLUGIN_PREFIX ),
				'price'                => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'relevancerank'        => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'           => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'reviewrank_authority' => __( 'Customer reviews (descending)', ATKP_PLUGIN_PREFIX ),
				'salesrank'            => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['Kitchen']            = array(
			'caption'    => __( 'Kitchen & household', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'        => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'-titlerank'    => __( 'Alphabetic (Z to A)', ATKP_PLUGIN_PREFIX ),
				'price'         => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'relevancerank' => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'    => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'salesrank'     => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
				'titlerank'     => __( 'Alphabetic (A to Z)', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['Grocery']            = array(
			'caption'    => __( 'Grocery & drinks', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'               => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'price'                => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'relevancerank'        => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'           => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'reviewrank_authority' => __( 'Customer reviews (descending)', ATKP_PLUGIN_PREFIX ),
				'salesrank'            => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['Music']              = array(
			'caption'    => __( 'Music-CDs & Vinyl', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'            => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'-pubdate'          => __( 'Release date (old to latest)', ATKP_PLUGIN_PREFIX ),
				'-publication_date' => __( 'Release date (latest to old)', ATKP_PLUGIN_PREFIX ),
				'-releasedate'      => __( 'Release date (latest to old)', ATKP_PLUGIN_PREFIX ),
				'-titlerank'        => __( 'Alphabetic (Z to A)', ATKP_PLUGIN_PREFIX ),
				'price'             => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'pubdate'           => __( 'Release date (latest to old)', ATKP_PLUGIN_PREFIX ),
				'publication_date'  => __( 'Release date (latest to old)', ATKP_PLUGIN_PREFIX ),
				'releasedate'       => __( 'Release date (latest to old)', ATKP_PLUGIN_PREFIX ),
				'salesrank'         => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
				'titlerank'         => __( 'Alphabetic (A to Z)', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['MP3Downloads']       = array(
			'caption'    => __( 'Musik-Downloads', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-albumrank'       => __( 'Album (Z to A)', ATKP_PLUGIN_PREFIX ),
				'-artistalbumrank' => __( 'Artist (Z to A)', ATKP_PLUGIN_PREFIX ),
				'-price'           => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'-releasedate'     => __( 'Release date (latest to old)', ATKP_PLUGIN_PREFIX ),
				'-runtime'         => __( 'Track length (increasing)', ATKP_PLUGIN_PREFIX ),
				'-titlerank'       => __( 'Alphabetic (Z to A)', ATKP_PLUGIN_PREFIX ),
				'albumrank'        => __( 'Album (A to Z)', ATKP_PLUGIN_PREFIX ),
				'artistalbumrank'  => __( 'Artist (A to Z)', ATKP_PLUGIN_PREFIX ),
				'price'            => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'relevancerank'    => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'       => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'runtime'          => __( 'Track length (descreasing)', ATKP_PLUGIN_PREFIX ),
				'salesrank'        => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
				'titlerank'        => __( 'Alphabetic (A to Z)', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['MusicalInstruments'] = array(
			'caption'    => __( 'Music instruments & DJ-Equipment', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'               => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'price'                => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'relevancerank'        => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'           => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'reviewrank_authority' => __( 'Customer reviews (descending)', ATKP_PLUGIN_PREFIX ),
				'salesrank'            => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['Jewelry']            = array(
			'caption'    => __( 'Schmuck', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'        => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'price'         => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'relevancerank' => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'    => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'salesrank'     => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['Shoes']              = array(
			'caption'    => __( 'Shoes & purses', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-launch-date'  => __( 'Release date (old to latest)', ATKP_PLUGIN_PREFIX ),
				'-price'        => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'price'         => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'relevancerank' => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'    => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'salesrank'     => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['Software']           = array(
			'caption'    => __( 'Software', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-date'      => __( 'Release date (old to latest)', ATKP_PLUGIN_PREFIX ),
				'-price'     => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'-titlerank' => __( 'Alphabetic (Z to A)', ATKP_PLUGIN_PREFIX ),
				'price'      => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'salesrank'  => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
				'titlerank'  => __( 'Alphabetic (A to Z)', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['Toys']               = array(
			'caption'    => __( 'Spielzeug', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-date'         => __( 'Release date (old to latest)', ATKP_PLUGIN_PREFIX ),
				'-price'        => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'-titlerank'    => __( 'Alphabetic (Z to A)', ATKP_PLUGIN_PREFIX ),
				'price'         => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'relevancerank' => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'    => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'salesrank'     => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['SportingGoods']      = array(
			'caption'    => __( 'Sports & recreation', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'        => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'-release-date' => __( 'Release date (old to latest)', ATKP_PLUGIN_PREFIX ),
				'-titlerank'    => __( 'Alphabetic (Z to A)', ATKP_PLUGIN_PREFIX ),
				'price'         => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'release-date'  => __( 'Release date (latest to old)', ATKP_PLUGIN_PREFIX ),
				'relevancerank' => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'    => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'salesrank'     => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
				'titlerank'     => __( 'Alphabetic (A to Z)', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['Industrial']         = array(
			'caption'    => __( 'Technics & science', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'   => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'featured' => __( 'Popular products', ATKP_PLUGIN_PREFIX ),
				'price'    => __( 'Price', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['Watches']            = array(
			'caption'    => __( 'Clocks', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'        => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'-titlerank'    => __( 'Alphabetic (Z to A)', ATKP_PLUGIN_PREFIX ),
				'price'         => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'relevancerank' => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'    => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'salesrank'     => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
				'titlerank'     => __( 'Alphabetic (A to Z)', ATKP_PLUGIN_PREFIX ),
			)
		);
		$departments['Magazines']          = array(
			'caption'    => __( 'Magazines', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'-price'        => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
				'-titlerank'    => __( 'Alphabetic (Z to A)', ATKP_PLUGIN_PREFIX ),
				'-unit-sales'   => __( 'Sold units', ATKP_PLUGIN_PREFIX ),
				'price'         => __( 'Price', ATKP_PLUGIN_PREFIX ),
				'relevancerank' => __( 'Relevance', ATKP_PLUGIN_PREFIX ),
				'reviewrank'    => __( 'Customer reviews', ATKP_PLUGIN_PREFIX ),
				'salesrank'     => __( 'Sales rank', ATKP_PLUGIN_PREFIX ),
				'titlerank'     => __( 'Alphabetic (A to Z)', ATKP_PLUGIN_PREFIX ),
			)
		);

		return $departments;
	}

}

?>