<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_posttypes_fieldgroup {
	/**
	 * Construct the plugin object
	 */
	public function __construct( $pluginbase ) {
		$this->register_CustomfieldgroupPostType();

		add_action( 'add_meta_boxes', array( &$this, 'list_boxes' ) );
		add_action( 'save_post', array( &$this, 'list_detail_save' ) );


	}

	function register_CustomfieldgroupPostType() {
		$labels = array(
			'name'               => __( 'Field groups', ATKP_PLUGIN_PREFIX ),
			'singular_name'      => __( 'Field group', ATKP_PLUGIN_PREFIX ),
			'add_new_item'       => __( 'Add new field group', ATKP_PLUGIN_PREFIX ),
			'edit_item'          => __( 'Edit field group', ATKP_PLUGIN_PREFIX ),
			'new_item'           => __( 'New field group', ATKP_PLUGIN_PREFIX ),
			'all_items'          => __( 'Field groups', ATKP_PLUGIN_PREFIX ),
			'view_item'          => __( 'View field group', ATKP_PLUGIN_PREFIX ),
			'search_items'       => __( 'Search field groups', ATKP_PLUGIN_PREFIX ),
			'not_found'          => __( 'No lists found', ATKP_PLUGIN_PREFIX ),
			'not_found_in_trash' => __( 'No lists found in the Trash', ATKP_PLUGIN_PREFIX ),
			'parent_item_colon'  => '',
			'menu_name'          => __( 'Field groups', ATKP_PLUGIN_PREFIX ),
		);
		$args   = array(
			'labels'      => $labels,
			'description' => 'Holds our field groups',

			'public'              => false,  // it's not public, it shouldn't have it's own permalink, and so on
			'publicly_queriable'  => true,  // you should be able to query it
			'show_ui'             => true,  // you should be able to edit it in wp-admin
			'exclude_from_search' => true,  // you should exclude it from search results
			'show_in_nav_menus'   => false,  // you shouldn't be able to add it to menus
			'has_archive'         => false,  // it shouldn't have archive page
			'rewrite'             => false,  // it shouldn't have rewrite rules
			'hierarchical'        => false,
			'capability_type'     => 'page',

			'menu_position' => 200,
			'supports'      => array( 'title' ),
			'show_in_menu'  => ATKP_PLUGIN_PREFIX . '_affiliate_toolkit-plugin',
		);

		$args = apply_filters( 'atkp_fieldgroup_register_post_type', $args );

		register_post_type( ATKP_FIELDGROUP_POSTTYPE, $args );

	}

	function list_boxes() {

		add_meta_box(
			ATKP_FIELDGROUP_POSTTYPE . '_fields_box',
			__( 'Field Information', ATKP_PLUGIN_PREFIX ),
			array( &$this, 'list_fields_box_content' ),
			ATKP_FIELDGROUP_POSTTYPE,
			'normal',
			'default'
		);

		add_meta_box(
			ATKP_FIELDGROUP_POSTTYPE . '_detail_box',
			__( 'Fieldgroup Information', ATKP_PLUGIN_PREFIX ),
			array( &$this, 'list_detail_box_content' ),
			ATKP_FIELDGROUP_POSTTYPE,
			'normal',
			'default'
		);

		add_meta_box(
			ATKP_FIELDGROUP_POSTTYPE . '_import_box',
			__( 'Import fields', ATKP_PLUGIN_PREFIX ),
			array( &$this, 'list_import_box_content' ),
			ATKP_FIELDGROUP_POSTTYPE,
			'normal',
			'default'
		);
	}


	function list_import_box_content( $post ) {
		?>
        <table class="form-table" style="width:100%">
            <tr valign="top">
                <th>
                    <label for="">
						<?php _e( 'Import data', ATKP_PLUGIN_PREFIX ) ?>:
                    </label>
                </th>
                <td>
                    <textarea style="width:100%;height:100px" id="<?php echo ATKP_FIELDGROUP_POSTTYPE . '_importurl' ?>"
                              name="<?php echo ATKP_FIELDGROUP_POSTTYPE . '_importurl' ?>"></textarea>

                </td>
            </tr>
        </table>
		<?php
	}

	function list_fields_box_content( $post ) {


		?>


        <script type="text/javascript">

            function Generator() {
            };
            Generator.prototype.rand = Math.floor(Math.random() * 26) + Date.now();

            Generator.prototype.getId = function () {
                return this.rand++;
            };
            var idGen = new Generator();


            var $j = jQuery.noConflict();
            /*
             * Attaches the add field to the input field
             */
            $j(document).ready(function ($) {

                // Runs when the image button is clicked.
                $j('#addfield-button').click(function (e) {
                    var $id = idGen.getId();

                    var tablerow = String($j('#atkp-template').html());

                    tablerow = tablerow.replace(/ATKPID/g, $id);

                    $j('#field').append(tablerow);

                    $j('#removefield-button_' + $id).click(deleterow);
                    $j('#upfield-button_' + $id).click(moveup);
                    $j('#downfield-button_' + $id).click(movedown);
                });

                $j('.remove-field').click(deleterow);

                function deleterow(e) {

                    if (confirm('<?php _e( 'Are you sure?', ATKP_PLUGIN_PREFIX ) ?>')) {
                        $(this).parent().parent().parent().parent().parent().remove();
                    }
                }

                $j('.up-field').click(moveup);

                function moveup(e) {
                    var row = $j(this).parent().parent().parent().parent().parent().prev();


                    if (row.length && row.attr('id') != 'addfield-button') {
                        var thisrow = $j(this).parent().parent().parent().parent().parent();

                        thisrow.remove();
                        thisrow.insertBefore(row);

                        thisrow.find('.up-field').click(moveup);
                        thisrow.find('.down-field').click(movedown);
                        thisrow.find('.remove-field').click(deleterow);
                    }
                }

                $j('.down-field').click(movedown);

                function movedown(e) {
                    var row = $j(this).parent().parent().parent().parent().parent().next();
                    if (row.length) {
                        var thisrow = $j(this).parent().parent().parent().parent().parent();

                        thisrow.remove();
                        thisrow.insertAfter(row);

                        thisrow.find('.down-field').click(movedown);
                        thisrow.find('.up-field').click(moveup);
                        thisrow.find('.remove-field').click(deleterow);
                    }
                }
            });


        </script>

		<?php

		$newfields = array();

		$newfields = ATKPTools::get_post_setting( $post->ID, ATKP_FIELDGROUP_POSTTYPE . '_fields' );


		?>

        <div id="fields" style="width:100%">
            <input type="button" id="addfield-button" class="button add-field"
                   title="<?php _e( 'Add Field', ATKP_PLUGIN_PREFIX ) ?>"
                   value="<?php _e( 'Add Field', ATKP_PLUGIN_PREFIX ) ?>"/>
            <div id="field"></div>
			<?php

			if ( $newfields != null ) {
				foreach ( $newfields as $newfield ) {
					$this->show_field( $newfield );

				}
			}

			?>

        </div>

        <div id="atkp-template" style="display:none">
			<?php echo $this->show_field( null ); ?>
        </div>

		<?php
	}

	function show_field( $newfield ) {

		if ( $newfield == null ) {
			$newfield                         = new atkp_udtaxonomy();
			$newfield->id                     = 'ATKPID';
			$newfield->showdatasheet          = true;
			$newfield->showdetaillist         = true;
			$newfield->showcomparetable       = true;
			$newfield->showmobilecomparetable = true;
		}

		?>
        <div id="field">
            <table style="width:100%;background:#F9F9F9;padding:10px;border: 0.5px solid #E1E1E1;border-radius: 4px;margin-top:5px">
                <tr>
                    <td>
						<?php _e( 'Caption', ATKP_PLUGIN_PREFIX ) ?>
                    </td>
                    <td>
                        <input style="width:95%" type="text" id="<?php echo 'atkp_caption_' . $newfield->id ?>"
                               name="<?php echo 'atkp_caption_' . $newfield->id ?>"
                               value="<?php echo esc_attr( $newfield->caption ); ?>">
                    </td>
                    <td>
						<?php _e( 'Name', ATKP_PLUGIN_PREFIX ) ?>
                    </td>
                    <td>
                        <input style="width:95%" type="text" id="<?php echo 'atkp_name_' . $newfield->id ?>"
                               name="<?php echo 'atkp_name_' . $newfield->id ?>"
                               value="<?php echo esc_attr( $newfield->name ); ?>">
                    </td>
                    <td style="text-align:right">
                        <input type="button" id="removefield-button_<?php echo $newfield->id ?>"
                               class="button remove-field" title="<?php _e( 'Delete field', ATKP_PLUGIN_PREFIX ) ?>"
                               value="<?php _e( 'Delete field', ATKP_PLUGIN_PREFIX ) ?>"/>

                    </td>
                </tr>
                <tr>
                    <td>
						<?php _e( 'Type', ATKP_PLUGIN_PREFIX ) ?>
                    </td>
                    <td>
                        <select style="width:95%" id="<?php echo 'atkp_type_' . $newfield->id ?>"
                                name="<?php echo 'atkp_type_' . $newfield->id ?>">
							<?php
							echo '<option value="1" ' . ( $newfield->type == 1 ? 'selected' : '' ) . '>' . __( 'Text', ATKP_PLUGIN_PREFIX ) . '</option>';
							echo '<option value="2" ' . ( $newfield->type == 2 ? 'selected' : '' ) . '>' . __( 'Multiline', ATKP_PLUGIN_PREFIX ) . '</option>';
							echo '<option value="3" ' . ( $newfield->type == 3 ? 'selected' : '' ) . '>' . __( 'Dropdown', ATKP_PLUGIN_PREFIX ) . '</option>';
							echo '<option value="4" ' . ( $newfield->type == 4 ? 'selected' : '' ) . '>' . __( 'Yes/No', ATKP_PLUGIN_PREFIX ) . '</option>';
							echo '<option value="5" ' . ( $newfield->type == 5 ? 'selected' : '' ) . '>' . __( 'Html', ATKP_PLUGIN_PREFIX ) . '</option>';
							echo '<option value="6" ' . ( $newfield->type == 6 ? 'selected' : '' ) . '>' . __( 'Taxonomy', ATKP_PLUGIN_PREFIX ) . '</option>';
							?>
                        </select>
                    </td>
                    <td>
						<?php _e( 'Format', ATKP_PLUGIN_PREFIX ) ?>
                    </td>
                    <td>
                        <select style="width:95%" id="<?php echo 'atkp_format_' . $newfield->id ?>"
                                name="<?php echo 'atkp_format_' . $newfield->id ?>">
							<?php
							echo '<option value="" ' . ( $newfield->format == '' ? 'selected' : '' ) . '>' . __( 'Default', ATKP_PLUGIN_PREFIX ) . '</option>';
							echo '<option value="text" ' . ( $newfield->format == 'text' ? 'selected' : '' ) . '>' . __( 'Text', ATKP_PLUGIN_PREFIX ) . '</option>';
							echo '<option value="number" ' . ( $newfield->format == 'number' ? 'selected' : '' ) . '>' . __( 'Number', ATKP_PLUGIN_PREFIX ) . '</option>';
							echo '<option value="url" ' . ( $newfield->format == 'url' ? 'selected' : '' ) . '>' . __( 'Url', ATKP_PLUGIN_PREFIX ) . '</option>';

							echo '<option value="date" ' . ( $newfield->format == 'date' ? 'selected' : '' ) . '>' . __( 'Date', ATKP_PLUGIN_PREFIX ) . '</option>';
							echo '<option value="email" ' . ( $newfield->format == 'email' ? 'selected' : '' ) . '>' . __( 'Email', ATKP_PLUGIN_PREFIX ) . '</option>';
							echo '<option value="stars" ' . ( $newfield->format == 'stars' ? 'selected' : '' ) . '>' . __( 'Stars', ATKP_PLUGIN_PREFIX ) . '</option>';
							?>
                        </select>
                    </td>


                </tr>
                <tr>
                    <td>
						<?php _e( 'Drowpdown values', ATKP_PLUGIN_PREFIX ) ?>
                    </td>
                    <td>


                        <textarea style="width:95%;height:100px" id="<?php echo 'atkp_values_' . $newfield->id ?>"
                                  name="<?php echo 'atkp_values_' . $newfield->id ?>"><?php echo esc_textarea( $newfield->values ); ?></textarea>

                    </td>

                    <td>
						<?php _e( 'Description', ATKP_PLUGIN_PREFIX ) ?>
                    </td>
                    <td>


                        <textarea style="width:95%;height:100px" id="<?php echo 'atkp_description_' . $newfield->id ?>"
                                  name="<?php echo 'atkp_description_' . $newfield->id ?>"><?php echo esc_textarea( $newfield->description ); ?></textarea>

                    </td>
                    <td style="text-align:right;vertical-align:bottom">
                        <input type="button" id="upfield-button_<?php echo $newfield->id ?>" class="button up-field"
                               title="<?php _e( 'Move up', ATKP_PLUGIN_PREFIX ) ?>"
                               value="<?php _e( 'Move up', ATKP_PLUGIN_PREFIX ) ?>"/>

                    </td>
                </tr>


                <tr>
                    <td>
						<?php _e( 'Prefix', ATKP_PLUGIN_PREFIX ) ?>
                    </td>
                    <td>
                        <input style="width:95%" type="text" id="<?php echo 'atkp_prefix_' . $newfield->id ?>"
                               name="<?php echo 'atkp_prefix_' . $newfield->id ?>"
                               value="<?php echo esc_attr( $newfield->prefix ); ?>">
                    </td>
                    <td>
						<?php _e( 'Suffix', ATKP_PLUGIN_PREFIX ) ?>
                    </td>
                    <td>
                        <input style="width:95%;" type="text" id="<?php echo 'atkp_suffix_' . $newfield->id ?>"
                               name="<?php echo 'atkp_suffix_' . $newfield->id ?>"
                               value="<?php echo esc_attr( $newfield->suffix ); ?>">
                    </td>

                    <td style="text-align:right">
                        <input type="button" id="downfield-button_<?php echo $newfield->id ?>" class="button down-field"
                               title="<?php _e( 'Move down', ATKP_PLUGIN_PREFIX ) ?>"
                               value="<?php _e( 'Move down', ATKP_PLUGIN_PREFIX ) ?>"/>

                    </td>
                </tr>

                <tr>
                    <td>

                    </td>
                    <td colspan="4">
                        <div style="float:left;margin-right:10px">
                            <input type="checkbox" id="<?php echo 'atkp_showdatasheet_' . $newfield->id ?>"
                                   name="<?php echo 'atkp_showdatasheet_' . $newfield->id ?>"
                                   value="1" <?php echo checked( 1, $newfield->showdatasheet, true ); ?>>
                            <label for="<?php echo 'atkp_showdatasheet_' . $newfield->id ?>">
								<?php _e( 'Show at datasheet', ATKP_PLUGIN_PREFIX ) ?>
                            </label>
                        </div>
                        <div style="float:left;margin-right:10px">
                            <input type="checkbox" id="<?php echo 'atkp_showdetaillist_' . $newfield->id ?>"
                                   name="<?php echo 'atkp_showdetaillist_' . $newfield->id ?>"
                                   value="1" <?php echo checked( 1, $newfield->showdetaillist, true ); ?>>
                            <label for="<?php echo 'atkp_showdetaillist_' . $newfield->id ?>">
								<?php _e( 'Show at detaillist', ATKP_PLUGIN_PREFIX ) ?>
                            </label>
                        </div>
                        <div style="float:left;margin-right:10px">
                            <input type="checkbox" id="<?php echo 'atkp_showcomparetable_' . $newfield->id ?>"
                                   name="<?php echo 'atkp_showcomparetable_' . $newfield->id ?>"
                                   value="1" <?php echo checked( 1, $newfield->showcomparetable, true ); ?>>
                            <label for="<?php echo 'atkp_showcomparetable_' . $newfield->id ?>">
								<?php _e( 'Show at comparetable', ATKP_PLUGIN_PREFIX ) ?>
                            </label>
                        </div>
                        <div style="float:left;margin-right:10px">
                            <input type="checkbox" id="<?php echo 'atkp_showmobilecomparetable_' . $newfield->id ?>"
                                   name="<?php echo 'atkp_showmobilecomparetable_' . $newfield->id ?>"
                                   value="1" <?php echo checked( 1, $newfield->showmobilecomparetable, true ); ?>>
                            <label for="<?php echo 'atkp_showmobilecomparetable_' . $newfield->id ?>">
								<?php _e( 'Show at mobile comparetable', ATKP_PLUGIN_PREFIX ) ?>
                            </label>
                        </div>
                        <div class="atkp-clearfix"></div>
                    </td>

                </tr>


            </table>
        </div>
		<?php
	}

	function list_detail_box_content( $post ) {

		wp_nonce_field( plugin_basename( __FILE__ ), 'fieldgroup_detail_box_content_nonce' );

		?>
        <table class="form-table" style="width:100%">
            <tr valign="top">
                <th>
                    <label for="">
						<?php _e( 'Name', ATKP_PLUGIN_PREFIX ) ?>:
                    </label>
                </th>
                <td>
                    <input type="text" style="width:100%" id="<?php echo ATKP_FIELDGROUP_POSTTYPE . '_name' ?>"
                           name="<?php echo ATKP_FIELDGROUP_POSTTYPE . '_name' ?>"
                           value="<?php echo ATKPTools::get_post_setting( $post->ID, ATKP_FIELDGROUP_POSTTYPE . '_name', true ); ?>">
                </td>
            </tr>
            <tr valign="top">
                <th>
                    <label for="">
						<?php _e( 'Sort order', ATKP_PLUGIN_PREFIX ) ?>:
                    </label>
                </th>
                <td>
                    <input type="number" style="width:100%" id="<?php echo ATKP_FIELDGROUP_POSTTYPE . '_sortorder' ?>"
                           name="<?php echo ATKP_FIELDGROUP_POSTTYPE . '_sortorder' ?>"
                           value="<?php echo ATKPTools::get_post_setting( $post->ID, ATKP_FIELDGROUP_POSTTYPE . '_sortorder', true ); ?>">
                </td>
            </tr>

            <tr valign="top">
                <th>
                    <label for="">
						<?php _e( 'Description', ATKP_PLUGIN_PREFIX ) ?>:
                    </label>
                </th>
                <td>
                    <textarea style="width:100%;height:100px"
                              id="<?php echo ATKP_FIELDGROUP_POSTTYPE . '_description' ?>"
                              name="<?php echo ATKP_FIELDGROUP_POSTTYPE . '_description' ?>"><?php echo esc_textarea( ATKPTools::get_post_setting( $post->ID, ATKP_FIELDGROUP_POSTTYPE . '_description', true ) ); ?></textarea>

                </td>
            </tr>
        </table>

		<?php

	}

	function list_detail_save( $post_id ) {
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		$nounce = ATKPTools::get_post_parameter( 'fieldgroup_detail_box_content_nonce', 'string' );

		if ( ! wp_verify_nonce( $nounce, plugin_basename( __FILE__ ) ) ) {
			return;
		}

		$post = get_post( $post_id );

		$posttype = $post->post_type; //ATKPTools::get_post_parameter('post_type', 'string');

		if ( ATKP_FIELDGROUP_POSTTYPE != $posttype ) {
			return;
		}

		//speichern der einstellungen

		$fields = array();

		$hasTaxonomy = false;

		foreach ( $_POST as $key => $value ) {
			$rawvalue = $value;
			$key      = sanitize_text_field( $key );
			$value    = sanitize_text_field( $value );

			$id = str_replace( 'atkp_caption_', '', $key );
			$id = str_replace( 'atkp_description_', '', $id );
			$id = str_replace( 'atkp_name_', '', $id );
			$id = str_replace( 'atkp_type_', '', $id );
			$id = str_replace( 'atkp_format_', '', $id );
			$id = str_replace( 'atkp_prefix_', '', $id );
			$id = str_replace( 'atkp_suffix_', '', $id );
			$id = str_replace( 'atkp_values_', '', $id );

			$id = str_replace( 'atkp_showdatasheet_', '', $id );
			$id = str_replace( 'atkp_showdetaillist_', '', $id );
			$id = str_replace( 'atkp_showcomparetable_', '', $id );
			$id = str_replace( 'atkp_showmobilecomparetable_', '', $id );

			//template nicht übernehmen
			if ( $id == 'ATKPID' ) {
				continue;
			}

			$checkit = 0;
			$add     = 1;
			$udf     = new atkp_udfield();
			$udf->id = $id;

			foreach ( $fields as $field ) {
				if ( $field->id == $udf->id ) {
					$udf = $field;
					$add = 0;
					break;
				}
			}


			if ( ATKPTools::startsWith( $key, 'atkp_caption_' ) ) {
				$checkit      = 1;
				$udf->caption = $value;
			} else if ( ATKPTools::startsWith( $key, 'atkp_description_' ) ) {
				$checkit          = 1;
				$udf->description = ATKPTools::get_post_parameter( $key, 'multistring' );
			} else if ( ATKPTools::startsWith( $key, 'atkp_name_' ) ) {
				$checkit   = 1;
				$udf->name = ATKPTools::get_post_parameter( $key, 'string' );
			} else if ( ATKPTools::startsWith( $key, 'atkp_type_' ) ) {
				$checkit   = 1;
				$udf->type = ATKPTools::get_post_parameter( $key, 'int' );

				if ( $udf->type == 6 ) {
					$hasTaxonomy = true;
				}

			} else if ( ATKPTools::startsWith( $key, 'atkp_format_' ) ) {
				$checkit     = 1;
				$udf->format = ATKPTools::get_post_parameter( $key, 'string' );
			} else if ( ATKPTools::startsWith( $key, 'atkp_values_' ) ) {
				$checkit     = 1;
				$udf->values = ATKPTools::get_post_parameter( $key, 'multistring' );
			} else if ( ATKPTools::startsWith( $key, 'atkp_prefix_' ) ) {
				$checkit     = 1;
				$udf->prefix = ATKPTools::get_post_parameter( $key, 'string' );
			} else if ( ATKPTools::startsWith( $key, 'atkp_suffix_' ) ) {
				$checkit     = 1;
				$udf->suffix = ATKPTools::get_post_parameter( $key, 'string' );
			} else if ( ATKPTools::startsWith( $key, 'atkp_showdatasheet_' ) ) {
				$checkit            = 1;
				$udf->showdatasheet = ATKPTools::get_post_parameter( $key, 'bool' );
			} else if ( ATKPTools::startsWith( $key, 'atkp_showdetaillist_' ) ) {
				$checkit             = 1;
				$udf->showdetaillist = ATKPTools::get_post_parameter( $key, 'bool' );
			} else if ( ATKPTools::startsWith( $key, 'atkp_showcomparetable_' ) ) {
				$checkit               = 1;
				$udf->showcomparetable = ATKPTools::get_post_parameter( $key, 'bool' );
			} else if ( ATKPTools::startsWith( $key, 'atkp_showmobilecomparetable_' ) ) {
				$checkit                     = 1;
				$udf->showmobilecomparetable = ATKPTools::get_post_parameter( $key, 'bool' );
			}

			if ( $checkit && $add ) {
				array_push( $fields, $udf );
			}
		}


		$url = ATKPTools::get_post_parameter( ATKP_FIELDGROUP_POSTTYPE . '_importurl', 'html' );
		if ( $url != '' ) {
			//TODO: parse table from url
			$parser    = new atkp_url_scraper();
			$newfields = $parser->get_rows( $url );

			foreach ( $newfields as $nfield ) {
				$udf = null;

				foreach ( $fields as $field ) {
					if ( $field->name == sanitize_text_field( $nfield['name'] ) ) {
						$udf = $field;
						break;
					}
				}

				if ( $udf != null ) {
					continue;
				}

				$udf          = new atkp_udfield();
				$udf->id      = rand( 9999, 999999 );
				$udf->name    = sanitize_text_field( $nfield['name'] );
				$udf->caption = sanitize_text_field( $nfield['name'] );
				if ( isset( $nfield['description'] ) ) {
					$udf->description = sanitize_text_field( $nfield['description'] );
				}


				$udf->showdatasheet          = true;
				$udf->showdetaillist         = true;
				$udf->showcomparetable       = true;
				$udf->showmobilecomparetable = true;

				if ( $udf->name != '' ) {
					array_push( $fields, $udf );
				}
			}
		}

		foreach ( $fields as $field ) {
			$field->name = sanitize_title( $field->name, $field->id );
		}

		ATKPTools::set_post_setting( $post_id, ATKP_FIELDGROUP_POSTTYPE . '_fields', $fields );
		ATKPTools::set_post_setting( $post_id, ATKP_FIELDGROUP_POSTTYPE . '_hastaxonomy', $hasTaxonomy );


		$name        = ATKPTools::get_post_parameter( ATKP_FIELDGROUP_POSTTYPE . '_name', 'string' );
		$sortorder   = ATKPTools::get_post_parameter( ATKP_FIELDGROUP_POSTTYPE . '_sortorder', 'int' );
		$description = ATKPTools::get_post_parameter( ATKP_FIELDGROUP_POSTTYPE . '_description', 'multistring' );


		ATKPTools::set_post_setting( $post_id, ATKP_FIELDGROUP_POSTTYPE . '_name', $name );
		ATKPTools::set_post_setting( $post_id, ATKP_FIELDGROUP_POSTTYPE . '_sortorder', $sortorder );
		ATKPTools::set_post_setting( $post_id, ATKP_FIELDGROUP_POSTTYPE . '_description', $description );

	}

}

?>