<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

define( 'ATKP_EVENT', strtolower( ATKP_PLUGIN_PREFIX ) . '_event' );
define( 'ATKP_CHECK', strtolower( ATKP_PLUGIN_PREFIX ) . '_check' );
define( 'ATKP_CSVIMPORT', strtolower( ATKP_PLUGIN_PREFIX ) . '_csvimport' );

define( 'ATKP_SHOP_POSTTYPE', strtolower( ATKP_PLUGIN_PREFIX ) . '_shop' );
define( 'ATKP_LIST_POSTTYPE', strtolower( ATKP_PLUGIN_PREFIX ) . '_list' );
define( 'ATKP_PRODUCT_POSTTYPE', strtolower( ATKP_PLUGIN_PREFIX ) . '_product' );
define( 'ATKP_TEMPLATE_POSTTYPE', strtolower( ATKP_PLUGIN_PREFIX ) . '_template' );
define( 'ATKP_FIELDGROUP_POSTTYPE', strtolower( ATKP_PLUGIN_PREFIX ) . '_fieldgroup' );

define( 'ATKP_SHORTCODE', strtolower( ATKP_PLUGIN_PREFIX ) . '_shortcode' );
define( 'ATKP_LIST_SHORTCODE', strtolower( ATKP_PLUGIN_PREFIX ) . '_list' );
define( 'ATKP_PRODUCT_SHORTCODE', strtolower( ATKP_PLUGIN_PREFIX ) . '_product' );
define( 'ATKP_SEARCHFORM_SHORTCODE', strtolower( ATKP_PLUGIN_PREFIX ) . '_searchform' );
define( 'ATKP_WIDGET', strtolower( ATKP_PLUGIN_PREFIX ) . '_widget' );
define( 'ATKP_FILTER_WIDGET', strtolower( ATKP_PLUGIN_PREFIX ) . '_filterwidget' );
define( 'ATKP_LIVELIST_SHORTCODE', strtolower( ATKP_PLUGIN_PREFIX ) . '_livelist' );

define( 'ATKP_LOGFILE', ATKP_PLUGIN_DIR . '/log/log.txt' );
define( 'ATKP_TEMPLATEDIR', ATKP_PLUGIN_DIR . '/templates' );

define( 'ATKP_STORE_URL', 'https://account.affiliate-toolkit.com/' );

define( 'ATKP_SUBSHOPTYPE', '-1' );

//** Credits im Kopf erzeugen **//
add_action( 'wp_head', 'my_affiliate_toolkit_tags' );

function my_affiliate_toolkit_tags() {
	//echo "\r\n" . '<!-- ' . __( 'This page uses the Affiliate Toolkit', ATKP_PLUGIN_PREFIX ) . ' / https://www.affiliate-toolkit.com -->' . "\r\n\r\n";

	$status  = atkp_options::$loader->get_licensestatus();

	if($status != 'valid')
		echo "\r\n" . '<!-- ' . __( 'This page uses a unlicensed version of affiliate-toolkit', ATKP_PLUGIN_PREFIX ) . ' / https://www.affiliate-toolkit.com -->' . "\r\n\r\n";
}

//registering the internal autoloader
require_once ATKP_PLUGIN_DIR . '/includes/atkp_autoloader.php';
$atkp_autoloader = new atkp_autoloader();
atkp_autoloader::$loader->register_classes();

ATKPSettings::load_settings();

$atkp_options = new atkp_options();

add_filter( 'atkp_variation_name', 'my_atkp_variation_name', 10 );

function my_atkp_variation_name( $variationName ) {
	switch ( $variationName ) {
		case 'Size':
			return 'Größe';

			return __( 'Size', ATKP_PLUGIN_PREFIX );
			break;
		case 'Color':
			return __( 'Color', ATKP_PLUGIN_PREFIX );
			break;
		default:
			return $variationName;
	}
}


add_filter( 'atkp_post_exists', 'my_atkp_post_exists', 10, 7 );

function my_atkp_post_exists( $post_id, $shopid, $asin, $asintype, $title, $brand, $mpn ) {

	if ( $brand != '' && $mpn != '' ) {

		$args = array(
			'post_type'      => ATKP_PRODUCT_POSTTYPE,
			'post_status'    => array( 'publish', 'draft' ),
			'posts_per_page' => 2,

			'meta_query' => array(
				'relation' => 'AND',
				array(
					'key'     => ATKP_PRODUCT_POSTTYPE . '_mpn',
					'value'   => $mpn,
					'compare' => '=',
				),
				array(
					'key'     => ATKP_PRODUCT_POSTTYPE . '_brand',
					'compare' => '=',
					'value'   => $brand,
				),
			)
		);

		$posts = get_posts( $args );

		if ( count( $posts ) == 1 ) {
			return $posts[0]->ID;
		}

		return $post_id;
	}

	switch ( $asintype ) {
		default:
		case 'ASIN':
			$prdid = atkp_product::idbyasin( $asin );

			if ( $prdid > 0 ) {
				$post_id = $prdid;
			}
			break;
		case 'EAN':
			$prdid = atkp_product::idbyean( $asin );

			if ( $prdid > 0 ) {
				$post_id = $prdid;
			}
			break;
		case 'ARTICLENUMBER':
			break;
		case 'TITLE':
			$prdid = atkp_product::idbyname( $asin );

			if ( $prdid > 0 ) {
				$post_id = $prdid;
			}
			break;
	}

	return $post_id;

}

// Our filter callback function
function my_atkp_load_providers( $providers, $providerid ) {

	if ( $providerid == '1' || $providerid == null ) {
		require_once ATKP_PLUGIN_DIR . '/includes/shopproviders/atkp_shop_provider_amazon.php';
		$providers['1'] = new atkp_shop_provider_amazon();
	}
	if ( $providerid == '2' || $providerid == null ) {
		require_once ATKP_PLUGIN_DIR . '/includes/shopproviders/atkp_shop_provider_affilinet.php';
		$providers['2'] = new atkp_shop_provider_affilinet();
	}
	if ( $providerid == '3' || $providerid == null ) {
		require_once ATKP_PLUGIN_DIR . '/includes/shopproviders/atkp_shop_provider_zanox.php';
		$providers['3'] = new atkp_shop_provider_zanox();
	}
	if ( $providerid == '4' || $providerid == null ) {
		require_once ATKP_PLUGIN_DIR . '/includes/shopproviders/atkp_shop_provider_ebay.php';
		$providers['4'] = new atkp_shop_provider_ebay();
	}
	if ( $providerid == '5' || $providerid == null ) {
		require_once ATKP_PLUGIN_DIR . '/includes/shopproviders/atkp_shop_provider_belboon.php';
		$providers['5'] = new atkp_shop_provider_belboon();
	}

	if ( $providerid == '7' || $providerid == null ) {
		require_once ATKP_PLUGIN_DIR . '/includes/shopproviders/atkp_shop_provider_csv.php';
		$providers['7'] = new atkp_shop_provider_csv();
	}
	if ( $providerid == '8' || $providerid == null ) {
		require_once ATKP_PLUGIN_DIR . '/includes/shopproviders/atkp_shop_provider_webgains.php';
		$providers['8'] = new atkp_shop_provider_webgains();
	}
	if ( $providerid == '9' || $providerid == null ) {
		require_once ATKP_PLUGIN_DIR . '/includes/shopproviders/atkp_shop_provider_cj.php';
		$providers['9'] = new atkp_shop_provider_cj();
	}
	if ( $providerid == '10' || $providerid == null ) {
		require_once ATKP_PLUGIN_DIR . '/includes/shopproviders/atkp_shop_provider_tradedoubler.php';
		$providers['10'] = new atkp_shop_provider_tradedoubler();
	}


	if ( $providerid == '11' || $providerid == null ) {
		require_once ATKP_PLUGIN_DIR . '/includes/shopproviders/atkp_shop_provider_livecsv.php';
		$providers['11'] = new atkp_shop_provider_livecsv();
	}


	if ( $providerid == '12' || $providerid == null ) {
		require_once ATKP_PLUGIN_DIR . '/includes/shopproviders/atkp_shop_provider_yadore.php';
		$providers['12'] = new atkp_shop_provider_yadore();
	}

	return $providers;
}

add_filter( 'atkp_load_providers', 'my_atkp_load_providers', 10, 2 );


function atkp_check_license_message( $license_data, $productname ) {
	$message = '';

	if ( $license_data->license != '' )
		switch ( $license_data->license ) {
			case 'expired' :
				$message = sprintf(
					__( 'Your license key expired on %s.' ),
					date_i18n( get_option( 'date_format' ), strtotime( $license_data->expires, current_time( 'timestamp' ) ) )
				);
				break;
			case 'revoked' :
				$message = __( 'Your license key has been disabled.' );
				break;
			case 'missing' :
				$message = __( 'Invalid license.' );
				break;
			case 'invalid' :
			case 'site_inactive' :
				$message = __( 'Your license is not active for this URL.' );
				break;
			case 'item_name_mismatch' :
				$message = __( 'This appears to be an invalid license key for ' . $productname . '.' );
				break;
			case 'no_activations_left':
				$message = __( 'Your license key has reached its activation limit.' );
				break;
			default :
				$message = '';
				break;
		}
	if ( $message != '' ) {
		$message .= ' (' . $license_data->license . ')';
	}

	return $message;
}


function atkp_check_license() {

	$license = trim( atkp_options::$loader->get_licensekey() );
	$item_id = atkp_options::$loader->get_licenseproductid();
	$status  = atkp_options::$loader->get_licensestatus();

	//if($status != 'valid')
//		return;

	$api_params = array(
		'edd_action' => 'check_license',
		'license'    => $license,
		'item_id'    => $item_id,
		'url'        => home_url()
	);
	$response   = wp_remote_post( ATKP_STORE_URL, array( 'body'      => $api_params,
	                                                     'timeout'   => 15,
	                                                     'sslverify' => false
	) );
	if ( is_wp_error( $response ) ) {
		return false;
	}

	$license_data = json_decode( wp_remote_retrieve_body( $response ) );

	if ( $license_data->license == 'valid' ) {
		//echo 'valid';
		$message = '';
		// this license is still valid
	} else {
		$products = atkp_get_license_products();

		//echo 'invalid';
		$message = atkp_check_license_message( $license_data, $products[ $item_id ] );
		// this license is no longer valid
	}

	ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_license_status', $license_data->license );
	ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_customer_name', $license_data->customer_name );
	ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_customer_email', $license_data->customer_email );
	ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_license_message', $message );
	ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_licensepage', false );
}

function atkp_get_license_products() {
	$products      = array();
	$products[13]  = __( 'affiliate-toolkit Standard', ATKP_PLUGIN_PREFIX );
	$products[109] = __( 'affiliate-toolkit Plus', ATKP_PLUGIN_PREFIX );
	$products[111] = __( 'affiliate-toolkit Developer', ATKP_PLUGIN_PREFIX );
	$products[248] = __( 'affiliate-toolkit Lifetime & Unlimited', ATKP_PLUGIN_PREFIX );

	return $products;
}



?>