<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_control_helper {


	public function read_control_value( $newfield, $fieldname ) {

		$fieldvalue = null;

		switch ( $newfield->type ) {
			case 0:
			case 1:
				//Text
				$type = 'text';
				switch ( $newfield->format ) {
					default:
					case 'text':
						$fieldvalue = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_' . $fieldname, 'string' );
						break;
					case 'stars':
					case 'number':
						$fieldvalue = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_' . $fieldname, 'double' );
						break;
					case 'url':
						$fieldvalue = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_' . $fieldname, 'url' );
						break;
				}


				break;
			case 2:
				//multiline
				$fieldvalue = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_' . $fieldname, 'multistring' );
				break;
			case 3:
				//dropdown
				$fieldvalue = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_' . $fieldname, 'string' );
				break;
			case 4:
				//yesno
				$fieldvalue = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_' . $fieldname, 'string' );

				switch ( $fieldvalue ) {
					default:
					case '':
						$fieldvalue = null;
						break;
					case '0':
						$fieldvalue = '0';
						break;
					case '1';
						$fieldvalue = '1';
						break;

				}
				break;
			case 5:
				//html
				$fieldvalue = ATKPTools::get_post_parameter( ATKP_PRODUCT_POSTTYPE . '_' . $fieldname, 'html' );
				break;
			default:
				throw new exception( 'unknown newfield->type: ' . $newfield->type );
		}

		return $fieldvalue;
	}

	public function create_control( $newfield, $controlname, $value, $isnewfield = false ) {
		$result = '';

		if ( $newfield != null ) {
			$newfield->isnewfield = $isnewfield;
		}

		switch ( $newfield->type ) {
			default:
			case 1:
				//Text
				$type       = 'text';
				$attributes = '';
				switch ( $newfield->format ) {
					case 'text':
						$type = 'text';
						break;
					case 'number':
						$type       = 'number';
						$attributes = ' step="0.01" ';
						break;
					case 'url':
						$type = 'url';
						break;
					case 'email':
						$type = 'email';
						break;
					case 'date':
						$type = 'date';
						break;
					case 'stars':
						$type       = 'number';
						$attributes = ' step="0.5" min="0" max="5" ';
						break;
				}


				$result = '<input style="width:100%" type="' . $type . '" ' . $attributes . ' id="' . $controlname . '" name="' . $controlname . '" value="' . esc_attr( $value ) . '"> ';

				break;
			case 2:
				//multiline

				$result = '<textarea style="width:100%;height:100px" id="' . $controlname . '" name="' . $controlname . '">' . esc_textarea( $value ) . '</textarea>';

				break;
			case 3:
				//dropdown

				if ( $isnewfield ) {
					$values = explode( "\n", $newfield->values );
				} else {
					$values = explode( ';', $newfield->format );
				}

				$result = '<select id="' . $controlname . '" name="' . $controlname . '" style="width:300px">  ';

				$result .= '<option value="" ' . ( $value == '' ? 'selected' : '' ) . '>' . __( 'None', ATKP_PLUGIN_PREFIX ) . '</option>';

				foreach ( $values as $value2 ) {
					$value2 = trim( $value2 );
					if ( $value2 != '' ) {
						$result .= '<option value="' . $value2 . '" ' . ( $value == $value2 ? 'selected' : '' ) . '>' . esc_attr( $value2 ) . '</option>';
					}
				}

				$result .= '</select>';

				break;
			case 4:
				//yesno

				$result .= '<select id="' . $controlname . '" name="' . $controlname . '" style="width:300px"> ';

				$result .= '<option value="" ' . ( $value == '' || $value == null ? 'selected' : '' ) . '>' . __( 'None', ATKP_PLUGIN_PREFIX ) . '</option>';
				$result .= '<option value="1" ' . ( $value == '1' ? 'selected' : '' ) . '>' . __( 'Yes', ATKP_PLUGIN_PREFIX ) . '</option>';
				$result .= '<option value="0" ' . ( $value == '0' ? 'selected' : '' ) . '>' . __( 'No', ATKP_PLUGIN_PREFIX ) . '</option>';

				$result .= '</select>';

				break;
			case 5:
				//html

				ob_start();

				wp_editor( $value, $controlname, array(
					'media_buttons' => false,
					'textarea_name' => $controlname,
					'textarea_rows' => 5,
				) );

				$result = ob_get_contents();

				ob_end_clean();
				break;

		}
		echo $result;
	}

	public function get_minmaxvalue( $newfield, $order = 'ASC' ) {
		$minvalue = 0;

		if ( $newfield->name == 'price' ) {
			$fieldname = ATKP_PRODUCT_POSTTYPE . '_salepricefloat';
		} else if ( ! $newfield->isnewfield ) {
			$fieldname = ATKP_PRODUCT_POSTTYPE . '_customfield_' . $newfield->name;
		} else {
			$fieldname = ATKP_PRODUCT_POSTTYPE . '_cf_' . $newfield->name;
		}

		$args      = array(
			'post_type'   => ATKP_PRODUCT_POSTTYPE,
			'post_status' => array( 'publish' ),
			'orderby'     => 'meta_value_num',
			'meta_key'    => $fieldname,
			'order'       => $order,
			'limit'       => 1,
		);
		$the_query = new WP_Query( $args );

		while ( $the_query->have_posts() ) {
			try {
				$the_query->the_post();

				$prd = $the_query->post;

				$minvalue = ATKPTools::get_post_setting( $prd->ID, $fieldname );
				break;

			} catch ( Exception $e ) {
				//TODO: logfile, falls ein wert nicht geparst werden kann?

			}
		}

		wp_reset_postdata();

		return $minvalue;
	}

	public function create_frontendcontrol( $newfield, $taxonomy, $controlname, $value, $isnewfield = false ) {
		$result = '';

		if ( $newfield != null ) {
			$newfield->isnewfield = $isnewfield;
		}

		if ( $taxonomy != null ) {
			$caption = sprintf( __( 'select %s', ATKP_PLUGIN_PREFIX ), $taxonomy->caption );

			$intvals = array();

			if ( ATKPTools::exists_get_parameter( $controlname ) ) {
				$intvals = ATKPTools::get_get_parameter( $controlname, 'intarray' );
			}


			$result .= '<select id="' . esc_attr( $controlname ) . '" name="' . esc_attr( $controlname ) . '[]" class="atkp-selectcontrol"  placeholder="' . esc_attr( $caption ) . '" style="width:100%" multiple="multiple">';

			$categories = get_categories( 'orderby=name&hide_empty=1&taxonomy=' . $taxonomy->name );
			foreach ( $categories as $category ) {
				$option = '<option value="' . esc_attr( $category->term_id ) . '" ' . ( is_array( $intvals ) && in_array( $category->term_id, $intvals ) ? 'selected' : '' ) . '>';
				$option .= $category->cat_name;
				$option .= '</option>';
				$result .= $option;
			}

			$result .= '</select>';

		} else if ( $newfield != null ) {
			switch ( $newfield->type ) {
				case 1:
					//Text
					$type = 'text';
					switch ( $newfield->format ) {
						case 'text':
							break;
						case 'number':


							$maxvalue_value = 0;
							$minvalue_value = 0;

							$maxvalue = $this->get_minmaxvalue( $newfield, $order = 'DESC' );
							$minvalue = 0; //$this->get_minmaxvalue($newfield, $order = 'ASC');

							if ( ATKPTools::exists_get_parameter( 'min' . $controlname ) ) {
								$minvalue_value = ATKPTools::get_get_parameter( 'min' . $controlname, 'int' );
							} else {
								$minvalue_value = $minvalue;
							}
							if ( ATKPTools::exists_get_parameter( 'max' . $controlname ) ) {
								$maxvalue_value = ATKPTools::get_get_parameter( 'max' . $controlname, 'int' );
							} else {
								if($maxvalue == 0)
									$maxvalue_value = 100;
								else
									$maxvalue_value = $maxvalue;
							}


							$result = '<div class="atkp-rangeslider-container"><div class="atkp-minprice">' . $newfield->prefix . ' <span class="minprice-display" id="min' . $controlname . '-display"></span> ' . $newfield->suffix . '</div><div class="atkp-rangeslider" minname="min' . $controlname . '" maxname="max' . $controlname . '"><input id="min' . $controlname . '" name="min' . $controlname . '" type="hidden" defaultvalue="' . esc_attr( $minvalue ) . '" value="' . esc_attr( $minvalue_value ) . '" /><input id="max' . $controlname . '" name="max' . $controlname . '" type="hidden"  defaultvalue="' . esc_attr( $maxvalue ) . '" value="' . esc_attr( $maxvalue_value ) . '" /></div><div class="atkp-maxprice">' . $newfield->prefix . ' <span class="maxprice-display" id="max' . $controlname . '-display"></span> ' . $newfield->suffix . '</div></div><div class="atkp-clearfix"></div>';
							break;
						case 'url':
							break;
						case 'stars':

							$minvalue_value = $minvalue = 0;
							$maxvalue_value = $maxvalue = 5;

							$result = '<div class="atkp-rangeslider-container"><div class="atkp-minprice">' . $newfield->prefix . ' <span class="minprice-display" id="min' . $controlname . '-display"></span> ' . $newfield->suffix . '</div><div class="atkp-rangeslider" minname="min' . $controlname . '" maxname="max' . $controlname . '"><input id="min' . $controlname . '" name="min' . $controlname . '" type="hidden" defaultvalue="' . esc_attr( $minvalue ) . '" value="' . esc_attr( $minvalue_value ) . '" /><input id="max' . $controlname . '" name="max' . $controlname . '" type="hidden"  defaultvalue="' . esc_attr( $maxvalue ) . '" value="' . esc_attr( $maxvalue_value ) . '" /></div><div class="atkp-maxprice">' . $newfield->prefix . ' <span class="maxprice-display" id="max' . $controlname . '-display"></span> ' . $newfield->suffix . '</div></div><div class="atkp-clearfix"></div>';
							break;
					}


					break;
				case 2:
					//multiline

					//$result = '<textarea style="width:100%;height:100px" id="'. $controlname .'" name="'. $controlname .'">'.esc_textarea($value).'</textarea>';

					break;
				case 3:
					//dropdown

					if ( $isnewfield ) {
						$values = explode( "\n", $newfield->values );
					} else {
						$values = explode( ';', $newfield->format );
					}

					$caption = sprintf( __( 'select %s', ATKP_PLUGIN_PREFIX ), $newfield->caption );

					$stringvals = ATKPTools::get_get_parameter( $controlname, 'stringarray' );


					$result = '<select id="' . $controlname . '" name="' . $controlname . '[]"  class="atkp-selectcontrol" style="width:100%" placeholder="' . $caption . '" multiple="multiple" >  ';


					foreach ( $values as $value2 ) {
						$value2 = trim( $value2 );
						if ( $value2 != '' ) {
							$result .= '<option value="' . esc_attr( $value2 ) . '" ' . ( is_array( $stringvals ) && in_array( $value2, $stringvals ) ? 'selected' : '' ) . '>' . esc_attr( $value2 ) . '</option>';
						}
					}

					$result .= '</select>';

					break;
				case 4:
					//yesno

					$boolval = ATKPTools::get_get_parameter( $controlname, 'bool' );

					$result .= '<div class="atkp-checkbox"><input type="checkbox" id="' . $controlname . '" name="' . $controlname . '" value="1" ' . ( $boolval ? ' checked' : '' ) . '>';
					$result .= '<label for="' . $controlname . '" >' . __( 'Yes', ATKP_PLUGIN_PREFIX ) . '</label></div>';

					break;
				case 5:
					//html

					/*ob_start();

					wp_editor($value, $controlname, array(
							'media_buttons' => false,
							'textarea_name' => $controlname,
							'textarea_rows' => 5,
					));

					$result = ob_get_contents();

					ob_end_clean();*/
					break;

			}
		} else {
			//product dropdown

			switch ( $controlname ) {
				case 'search':
					$strval = ATKPTools::get_get_parameter( $controlname, 'string' );

					$result .= '<input type="text" name="search" placeholder="' . __( 'Enter a search term', ATKP_PLUGIN_PREFIX ) . '" value="' . esc_attr( $strval ) . '" />';
					break;
				case 'submit':
					$result .= '<input type="submit" class="atkp-submitbutton" value="' . __( 'Find', ATKP_PLUGIN_PREFIX ) . '" />';
					break;
				case 'orderby':
					//neuheiten
					//bewertungen
					//preis auf bzw. absteigend
					//produktname auf bzw. absteigend

					$values = array(
						'price-asc'      => __( 'Price', ATKP_PLUGIN_PREFIX ),
						'price-desc'     => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
						'titlerank-asc'  => __( 'Alphabetic (A to Z)', ATKP_PLUGIN_PREFIX ),
						'titlerank-desc' => __( 'Alphabetic (Z to A)', ATKP_PLUGIN_PREFIX ),
					);


					$caption = __( 'sort by', ATKP_PLUGIN_PREFIX );

					$stringvals = ATKPTools::get_get_parameter( $controlname, 'string' );


					$result = '<select id="' . $controlname . '" name="' . $controlname . '"  class="atkp-selectcontrol" style="width:100%" placeholder="' . $caption . '" >  ';

					$result .= '<option value="" ' . ( $stringvals == '' ? 'selected' : '' ) . '>' . esc_attr( $caption ) . '</option>';

					foreach ( $values as $key => $value2 ) {
						$result .= '<option value="' . esc_attr( $key ) . '" ' . ( $stringvals == $key ? 'selected' : '' ) . '>' . esc_attr( $value2 ) . '</option>';
					}

					$result .= '</select>';
					break;
				case "product1":
				case "product2":
				case "product3":
				case "product4":
				case "product5":
					$caption    = __( 'select product', ATKP_PLUGIN_PREFIX );
					$stringvals = ATKPTools::get_get_parameter( $controlname, 'string' );


					$productid = ATKPTools::get_get_parameter( $controlname, 'int' );

					$searchnounce = wp_create_nonce( 'atkp-search-nonce' );

					$inputtooshort = __( 'You must enter at least 3 characters.', ATKP_PLUGIN_PREFIX );

					$result = '<select id="' . $controlname . '" name="' . $controlname . '"  class="atkp-product-selectcontrol" style="width:100%" data-placeholder= "' . $caption . '" placeholder="' . $caption . '" searchnounce="' . $searchnounce . '" inputtooshort="' . $inputtooshort . '" endpointurl="' . ATKPTools::get_endpointurl() . '">  ';

					//$result .= '<option></option>';


					if ( $productid != 0 ) {
						$productitle = ATKPTools::get_post_setting( $productid, ATKP_PRODUCT_POSTTYPE . '_title', true );
						$result      .= '<option value="' . $productid . '" selected>' . esc_attr( $productitle ) . '</option>';
					}
					//foreach($values as $key => $value2) {
					//    $result .= '<option value="'.esc_attr($key).'" '.($stringvals == $key ? 'selected' : '').'>' . esc_attr($value2) . '</option>';
					//}

					$result .= '</select>';
					break;
			}

		}

		return $result;
	}


	public function create_backendcontrol( $newfield, $taxonomy, $controlname, $value, $isnewfield = false ) {
		$result = '';

		if ( $taxonomy != null ) {
			$caption = sprintf( __( 'select %s', ATKP_PLUGIN_PREFIX ), $taxonomy->caption );

			$intvals = array();


			$result .= '<select id="' . $controlname . '" name="' . $controlname . '"  class="atkp-backend-filter" placeholder="' . $caption . '" style="width:100%" multiple="multiple">';

			$categories = get_categories( 'orderby=name&hide_empty=1&taxonomy=' . $taxonomy->name );
			foreach ( $categories as $category ) {
				$option = '<option value="' . esc_attr( $category->term_id ) . '">';
				$option .= $category->cat_name;
				$option .= '</option>';
				$result .= $option;
			}

			$result .= '</select>';

		} else if ( $newfield != null ) {
			switch ( $newfield->type ) {
				case 1:
					//Text
					$type = 'text';
					switch ( $newfield->format ) {
						case 'text':
							break;
						case 'number':


							$maxvalue = 0;
							$minvalue = 0; //$this->get_minmaxvalue($newfield, $order = 'ASC');


							$result = '<input id="minprice" name="min' . $controlname . '" type="number" value="' . esc_attr( $minvalue ) . '"  class="atkp-backend-filter" /> - <input id="maxprice"  class="atkp-backend-filter" name="max' . $controlname . '" type="number" value="' . esc_attr( $maxvalue ) . '" />';
							break;
						case 'url':
							break;
					}


					break;
				case 2:
					//multiline

					//$result = '<textarea style="width:100%;height:100px" id="'. $controlname .'" name="'. $controlname .'">'.esc_textarea($value).'</textarea>';

					break;
				case 3:
					//dropdown

					if ( $isnewfield ) {
						$values = explode( "\n", $newfield->values );
					} else {
						$values = explode( ';', $newfield->format );
					}

					$caption = sprintf( __( 'select %s', ATKP_PLUGIN_PREFIX ), $newfield->caption );


					$result = '<select id="' . $controlname . '" name="' . $controlname . '"  style="width:100%"  class="atkp-backend-filter" placeholder="' . $caption . '" multiple="multiple" >  ';


					foreach ( $values as $value2 ) {
						$value2 = trim( $value2 );
						if ( $value2 != '' ) {
							$result .= '<option value="' . esc_attr( $value2 ) . '">' . esc_attr( $value2 ) . '</option>';
						}
					}

					$result .= '</select>';

					break;
				case 4:
					//yesno


					$result .= '<div class="atkp-checkbox"><input type="checkbox" id="' . $controlname . '" class="atkp-backend-filter" name="' . $controlname . '" value="0">';
					$result .= '<label for="' . $controlname . '" >' . __( 'Yes', ATKP_PLUGIN_PREFIX ) . '</label></div>';

					break;
				case 5:
					//html

					/*ob_start();

					wp_editor($value, $controlname, array(
							'media_buttons' => false,
							'textarea_name' => $controlname,
							'textarea_rows' => 5,
					));

					$result = ob_get_contents();

					ob_end_clean();*/
					break;

			}
		} else {
			//product dropdown

			switch ( $controlname ) {
				case 'orderby':
					//neuheiten
					//bewertungen
					//preis auf bzw. absteigend
					//produktname auf bzw. absteigend

					$values = array(
						'price-asc'      => __( 'Price', ATKP_PLUGIN_PREFIX ),
						'price-desc'     => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
						'titlerank-asc'  => __( 'Alphabetic (A to Z)', ATKP_PLUGIN_PREFIX ),
						'titlerank-desc' => __( 'Alphabetic (Z to A)', ATKP_PLUGIN_PREFIX ),
					);


					$caption = __( 'sort by', ATKP_PLUGIN_PREFIX );


					$result = '<select id="' . $controlname . '" name="' . $controlname . '" class="atkp-backend-filter"  style="width:100%" placeholder="' . $caption . '" >  ';

					$result .= '<option value="">' . esc_attr( $caption ) . '</option>';

					foreach ( $values as $key => $value2 ) {
						$result .= '<option value="' . esc_attr( $key ) . '">' . esc_attr( $value2 ) . '</option>';
					}

					$result .= '</select>';
					break;
				case "product1":
				case "product2":
				case "product3":
				case "product4":
				case "product5":
					$caption = __( 'input productid', ATKP_PLUGIN_PREFIX );

					$inputtooshort = __( 'You must enter at least 3 characters.', ATKP_PLUGIN_PREFIX );

					//atkp-product-box
					$disable_select2 = true; // ATKPTools::get_setting(ATKP_PLUGIN_PREFIX.'_disableselect2', false);

					if ( $disable_select2 ) {
						$result = '<input type="number" id="' . $controlname . '" name="' . $controlname . '" class="atkp-backend-filter"  style="width:100%" placeholder="' . $caption . '" />  ';
					} else {
						$result = '<select id="' . $controlname . '" name="' . $controlname . '" class="atkp-backend-filter atkp-product-box"  style="width:100%">  ';
						$result .= '<option value="" selected>' . __( 'None', ATKP_PLUGIN_PREFIX ) . '</option>';
						$result .= ' </select>';
					}


					break;
			}

		}

		return $result;
	}
}


?>