<?php
/**
 * Created by PhpStorm.
 * User: Christof
 * Date: 01.12.2018
 * Time: 11:36
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class ATKPHomeLinks {
	public static function GetHelpLink( $type, $title ) {
		$locale = self::GetLocale();
		$url    = '';

		switch ( $type ) {
			case 'templates':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/thema/vorlagen/';
				} else {
					$url = '';
				}
				break;

		}

		if ( $url != '' ) {
			return '<a href="' . $url . '" target="_blank">' . $title . '</a>';
		}

	}

	public static function GetHelpIcon( $type, $intext = '' ) {
		$locale = self::GetLocale();
		$url    = '';

		switch ( $type ) {
			case 'product-shop':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/was-sind-produkte/';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/what-are-products/';
				}
				break;
			case 'list-shop':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/listen/';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/what-are-lists/';
				}
				break;
			case 'tools-debug':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/debugmodus-verwenden/';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/use-debug-mode/';
				}
				break;
			case 'setting-woo':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/6-affiliate-toolkit-mit-woocommerce-nutzen/';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/usage-of-affiliate-toolkit-with-woocommerce/';
				}
				break;
			case 'import-template':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/vorlagen/#Vorlage-importieren';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/what-are-templates/#Import-templates';
				}
				break;
			case 'import-product':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/was-sind-produkte/#Import-ueber-den-CSV-Import';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/what-are-products/#Import-via-CSV-Import';
				}
				break;
			case 'import-list':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/listen/#Import-ueber-den-CSV-Import';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/what-are-lists/#Import-via-the-CSV-Import';
				}
				break;
			case 'compatiblity-asa1':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/kompatibilitaetsmodus-fuer-asa1-und-asa2/#Amazon-Simple-Admin-1';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/compatibility-mode-for-asa1-and-asa2/#Amazon-Simple-Admin-1';
				}
				break;
			case 'compatiblity-asa2':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/kompatibilitaetsmodus-fuer-asa1-und-asa2/#Amazon-Simple-Affiliate-2';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/compatibility-mode-for-asa1-and-asa2/#Amazon-Simple-Affiliate-2';
				}
				break;
			case 'setting-productpage':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/produktseite/#1-Produktseiten-aktiviert';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/product-page/#1-Activate-product-pages';
				}
				break;
			case 'setting-acf':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/benutzerdefinierte-felder/#Advanced-Custom-Fields-Plugin-ACF';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/custom-fields/#Advanced-Custom-Fields-Plugin-ACF';
				}
				break;
			case 'setting-customtaxonomy':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/benutzerdefinierte-felder/#Benutzerdefinierte-Taxonomien-fuer-das-Produkt';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/custom-fields/#Custom-taxonomies-for-the-product';
				}
				break;
			case 'setting-customfield':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/benutzerdefinierte-felder/#Benutzerdefinierte-Felder-fuer-Produkte';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/custom-fields/#Custom-taxonomies-for-the-product';
				}
				break;
			case 'setting-list':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/anzeige/#Listen';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/display/#Lists';
				}
				break;
			case 'setting-text':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/anzeige/#Text';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/display/#Text';
				}
				break;
			case 'setting-hoverlink':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/anzeige/#Hover-Linkinformation';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/display/#Hover-link-information';
				}
				break;
			case 'setting-moreoffers':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/anzeige/#Mehr-Angebote';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/display/#More-offers';
				}
				break;
			case 'setting-display':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/anzeige/#1-Preis-anzeigen';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/display/#1-Show-price';
				}
				break;
			case 'setting-datacheck':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/basis-einstellungen/#Einstellungen-fuer-die-Datenueberpruefung';
				} else {
					$url = '';
				}
				break;
			case 'setting-datacache':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/basis-einstellungen/#Einstellungen-fuer-den-Datencache';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/basic-settings/#Settings-for-the-Data-Cache';
				}
				break;
			case 'setting-compatibility':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/erweiterte-einstellungen/#Kompatibilitaet';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/advanced-settings/#Compatibility';
				}
				break;
			case 'setting-images':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/erweiterte-einstellungen/#Bilder';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/advanced-settings/#Images';
				}
				break;
			case 'setting-links-buttons':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/erweiterte-einstellungen/#Links-Buttons';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/advanced-settings/#Links-Buttons';
				}
				break;

			case 'setting-disclaimer':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/erweiterte-einstellungen/#Einstellungen-fuer-den-Haftungsausschluss';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/advanced-settings/#Settings-for-disclaimer';
				}
				break;
			case 'cronjob-type':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/basis-einstellungen/#1-Cronjob-Typ';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/basic-settings/#1-Cronjob-type';
				}
				break;
			case 'templates-compare':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/responsive-vergleichstabellen-nutzen/';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/use-responsive-comparison-chart/';
				}
				break;
			case 'templates-help':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/vorlagen/#Neue-Vorlage-im-Plugin-anlegen';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/what-are-templates/#Create-new-template-within-the-plugin';
				}
				break;
			case 'webgains-api':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/die-webgains-api/#1-Datenlieferant';
				} else {
					$url = '';
				}
				break;
			case 'csv-import':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/die-csv-schnittstelle/';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/setting-up-csv-interface/';
				}
				break;
			case 'belboon-api':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/die-belboon-api-einrichten/#1-Datenlieferant';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/setting-up-the-belboon-api/#1Data-supplier';
				}
				break;
			case 'affilinet-api':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/die-affili-net-api/#1-Datenlieferant';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/setting-up-affili-net-api/#1Data-supplier';
				}
				break;
			case 'cj-api':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/die-cj-api/#1-Datenlieferant';
				} else {
					$url = '';
				}
				break;
			case 'ean-shop':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/shops-schnittstellen/#Shop-Einstellungen';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/shops-interfaces-to-the-affiliate-networks/#Shop-setting';
				}
				break;
			case 'add-shop':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/shops-schnittstellen/';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/shops-interfaces-to-the-affiliate-networks/';
				}
				break;
			case 'amazon-getkey':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/die-amazon-api/';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/setting-up-amazon-api/';
				}
				break;
			case 'amazon-customerreview':
				if ( $locale == 'de' ) {
					$url = 'https://docs.affiliate-toolkit.com/die-amazon-api/#7-Kundenbewertungen-laden';
				} else {
					$url = 'https://docs.affiliate-toolkit.com/en/setting-up-amazon-api/#7Loading-customer-reviews';
				}
				break;
		}

		if ( $url != '' ) {
			return '<a href="' . $url . '" target="_blank">' . $intext . ' <img src="' . plugins_url( './images/help_24.png', ATKP_PLUGIN_FILE ) . '"  style="height:16px;vertical-align: middle;" title="' . __( 'Additional information', ATKP_PLUGIN_PREFIX ) . '" /></a>';
		}

	}

	public static function ReplaceLinkType( $str ) {

		$str = str_replace( '%link_toolkit-bestseller%', 'https://www.affiliate-toolkit.com/%locale%/toolkit-bestseller/', $str );
		$str = str_replace( '%link_get-amazon-apikey%', 'https://www.affiliate-toolkit.com/%locale%/get-amazon-apikey/', $str );
		$str = str_replace( '%link_load-amazon-customer-reviews%', 'https://www.affiliate-toolkit.com/%locale%/load-amazon-customer-reviews/', $str );
		$str = str_replace( '%link_mark-affiliate-links%', 'https://www.affiliate-toolkit.com/%locale%/mark-affiliate-links/', $str );
		$str = str_replace( '%link_get-amazon-search-department%', 'https://www.affiliate-toolkit.com/%locale%/get-amazon-search-department/', $str );

		$str = str_replace( '%link_help%', 'https://docs.affiliate-toolkit.com/%locale%', $str );

		$str = str_replace( '%link_support%', 'https://ticket.affiliate-toolkit.com/index.php?lang=%locale%', $str );

		$str = str_replace( '%link_affiliate%', 'https://www.affiliate-toolkit.com/%locale%/affiliate/', $str );
		$str = str_replace( '%link_contact%', 'https://ticket.affiliate-toolkit.com/index.php?lang=%locale%', $str );
		$str = str_replace( '%link_get-license-key%', 'https://www.affiliate-toolkit.com/%locale%/affiliate-toolkit-price/', $str );
		$str = str_replace( '%link_customfields%', 'https://docs.affiliate-toolkit.com/%locale%/benutzerdefinierte-felder/', $str );


		return ATKPHomeLinks::CheckLink( $str );
	}

	public static function GetLocale() {

		if ( get_locale() != '' && strlen( get_locale() ) >= 2 && strtolower( substr( get_locale(), 0, 2 ) ) == 'de' ) {
			$locale = "de";
		} else {
			$locale = "en";
		}

		return $locale;
	}

	public static function CheckLink( $link ) {
		$locale = self::GetLocale();

		return str_replace( '%locale%', $locale, $link );
	}

}
