<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_shop_provider_tradedoubler extends atkp_shop_provider_base {
	//das ist die basis klasse für alle shop provider

	public function __construct() {
		if ( ! defined( "ATKP_Tradedoubler_Search" ) ) {
			define( "ATKP_Tradedoubler_Search", "http://api.tradedoubler.com/1.0/products.json" );
		}

		if ( ! defined( "ATKP_Tradedoubler_Categories" ) ) {
			define( "ATKP_Tradedoubler_Categories", "http://api.tradedoubler.com/1.0/productCategories.json" );
		}

		if ( ! defined( "ATKP_Tradedoubler_Feeds" ) ) {
			define( "ATKP_Tradedoubler_Feeds", "http://api.tradedoubler.com/1.0/productFeeds.json" );
		}

	}

	public function get_caption() {
		return __( 'Tradedoubler API', ATKP_PLUGIN_PREFIX );
	}

	public function get_defaultlogo() {
		return '';
	}

	public function send_request( $url, $developerkey = '' ) {

		if ( $developerkey == '' ) {
			$developerkey = $this->token;
		}

		$args = array(
			'timeout'     => 30,
			'httpversion' => '1.1',
		);

		$result1 = wp_remote_get( $url . ( strpos( $url, '?' ) !== false ? '&token=' : '?token=' ) . $developerkey, $args );

		return $this->check_response( $result1 );
	}

	public function check_response( $result ) {

		if ( is_wp_error( $result ) || ! isset( $result['response']['code'] ) || $result['response']['code'] != 200 ) {
			if ( is_wp_error( $result ) ) {
				$error_string = $result->get_error_message();
			} else {
				$error_string = $result['body'];
			}

			throw new Exception( $error_string );
		} else {
			return json_decode( $result['body'], false ); // new SimpleXMLElement($result['body']);
		}
	}


	public function retrieve_browsenodes( $keyword ) {

	}

	public function check_configuration( $post_id ) {
		try {
			$apikey = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_key' );
			//$apisecretkey = ATKPTools::get_post_setting($post_id, ATKP_SHOP_POSTTYPE.'_access_secret_key');
			//$enable_ssl =ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE.'_enable_ssl');


			$message = '';
			if ( $apikey != '' ) {

				$response = $this->send_request( ATKP_Tradedoubler_Feeds, $apikey );

				if ( ATKPLog::$logenabled ) {
					ATKPLog::LogDebug( '*** check_configuration tradedoubler ***' );
					ATKPLog::LogDebug( serialize( $response ) );
					ATKPLog::LogDebug( '*** check_configuration tradedoubler ***' );
				}

				$subshopsold = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops' );


				//var_dump(serialize($response));exit;
				$subshops = array();
				foreach ( $response->feeds as $feed ) {

					//echo var_dump( $advertiser->advertiser);exit;

					foreach ( $feed->programs as $program ) {
						$subshop            = new subshop();
						$subshop->title     = $program->name;
						$subshop->title2    = $feed->active == 1 ? __( 'active', ATKP_PLUGIN_PREFIX ) : __( 'inactive', ATKP_PLUGIN_PREFIX );
						$subshop->shopid    = $feed->feedId;
						$subshop->programid = $program->programId; //$advertiser->advertiser->{'advertiser-id'};


						//$subshop->logourl = $this->checkimageurl($program['programlogo'], $enable_ssl);
						//$subshop->smalllogourl = $this->checkimageurl($program['programlogo'], $enable_ssl);

						$requestUrl = ATKP_Tradedoubler_Search . ';fid=' . urlencode( $feed->feedId ) . ';q=;limit=1';
						$response   = $this->send_request( $requestUrl, $apikey );


						foreach ( $response->products as $productResp ) {
							$subshop->logourl = $this->checkimageurl( $productResp->offers[0]->programLogo );
							break;
						}


						array_push( $subshops, $subshop );
					}
				}


				//für bestehende alte subshops ist dieser teil noch drinnen
				if ( is_array( $subshopsold ) ) {
					foreach ( $subshopsold as $shopold ) {
						if ( $subshop->shopid == $shopold->shopid && $subshop->programid == $shopold->programid ) {
							$subshop->enabled            = $shopold->enabled;
							$subshop->customtitle        = $shopold->customtitle;
							$subshop->customsmalllogourl = $shopold->customsmalllogourl;
							$subshop->customlogourl      = $shopold->customlogourl;
							$subshop->customfield1       = $shopold->customfield1;
							$subshop->customfield2       = $shopold->customfield2;
							$subshop->customfield3       = $shopold->customfield3;
						}
					}
				}

				ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops', $subshops );

			} else {
				//wenn zugangscodes gelöscht werden muss message auch geleert werden
				$message = 'Credientials are empty';
			}

			return $message;
		} catch ( Exception $e ) {
			if ( ATKPLog::$logenabled ) {
				ATKPLog::LogError( $e->getMessage() );
			}

			return $e->getMessage();
		}
	}

	public function set_configuration( $post_id ) {

		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_key', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_cj_access_key', 'string' ) );
		// ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE.'_access_secret_key', ATKPTools::get_post_parameter(ATKP_SHOP_POSTTYPE.'_cj_access_secret_key', 'string'));
		//ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE.'_enable_ssl', ATKPTools::get_post_parameter(ATKP_SHOP_POSTTYPE.'_cj_enable_ssl', 'bool'));

		// $subshops=  ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE.'_default_shops');

		//if(is_array($subshops))
		//    $this->read_subshop_settings($subshops, 'aff');

		//echo serialize($subshops);exit;

		//ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE.'_default_shops', $subshops);
	}

	public function get_configuration( $post ) {
		$webservice = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_webservice' );

		$apikey       = '';
		$apisecretkey = '';
		$subshops     = '';
		$enablessl    = false;


		if ( $webservice == '10' ) {
			$apikey = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_key' );
			//$apisecretkey = ATKPTools::get_post_setting($post->ID, ATKP_SHOP_POSTTYPE.'_access_secret_key');

			$subshops = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_default_shops' );

			//$enablessl = ATKPTools::get_post_setting($post->ID, ATKP_SHOP_POSTTYPE.'_enable_ssl');
		}
		?>
        <tr valign="top">
            <th scope="row">
                <label for="">
					<?php _e( 'Token', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
				<?php echo ATKPHomeLinks::GetHelpIcon( 'tradedoubler-api' ); ?>
            </th>
            <td>
                <input style="width:40%" type="text" id="<?php echo ATKP_SHOP_POSTTYPE . '_tradedoubler_access_key' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_cj_access_key' ?>" value="<?php echo $apikey; ?>">
                <label for="">
                </label>
            </td>
        </tr>


        <!--<tr valign="top">
                            <th scope="row">
                                
                            </th>
                            <td>
                            <?php
		//if(is_array($subshops))
		//    $this->echo_subshop_settings($subshops,'aff');
		?>
                            
                            </td>
                        </tr>-->

		<?php
	}

	public function get_shops( $post_id, $allshops = false ) {
		$shops = array();

		$subshops = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops' );

		if ( is_array( $subshops ) ) {
			foreach ( $subshops as $subshop ) {
				if ( $subshop->enabled || $allshops ) {
					$subshop->shopid2 = $subshop->shopid;
					$subshop->shopid  = $post_id . '_' . $subshop->programid . '_' . $subshop->shopid;

					$subshop->logourl      = $subshop->customlogourl == '' ? $subshop->logourl : $subshop->customlogourl;
					$subshop->smalllogourl = $subshop->customsmalllogourl == '' ? $subshop->smalllogourl : $subshop->customsmalllogourl;
					$subshop->title        = $subshop->customtitle == '' ? $subshop->title : $subshop->customtitle;

					array_push( $shops, $subshop );
				}
			}
		}

		return $shops;
	}

	private $shopid = null;
	private $enable_ssl = false;

	private $aff_programId = null;
	private $aff_shopId = null;

	private $token = null;

	public function checklogon( $shop ) {
		$apikey           = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_access_key' );
		$this->enable_ssl = true;

		if ( $apikey == '' ) {
			throw new Exception( 'Credientials are empty' );
		}

		$this->token = $apikey;

		$this->shopid        = $shop->id;
		$this->aff_programId = $shop->programid;
		$this->aff_shopId    = $shop->shopid;
	}

	public function quick_search( $keyword, $searchType, $pagination = 1 ) {
		if ( $this->token == null ) {
			throw new Exception( 'checklogon required' );
		}

		$products = new atkp_search_resp();

		$maxCount = 10;



        $requestUrl = ATKP_Tradedoubler_Search . ';fid=' . urlencode( $this->aff_shopId );


        switch ( $searchType ) {
            case 'ean':
                $requestUrl .= ';ean=' . urlencode( $keyword );

                break;
            case 'articlenumber':
                $requestUrl .= ';spId=' . urlencode( $keyword );

                break;
            case 'asin':
                $requestUrl .= ';tdId=' . urlencode( $keyword );

                break;
            default:
                $requestUrl .= ';q=' . urlencode( $keyword ) . ';page=' . $pagination . ';pageSize=' . $maxCount;


                break;
        }
        //echo $requestUrl;
        $response = $this->send_request( $requestUrl );

        $products->total = intval($response->productHeader->totalHits);
		$products->currentpage = $products->total > 0 ? $pagination : 0;
		$products->pagecount = ceil(floatval($products->total) / floatval($maxCount));

        foreach ( $response->products as $productResp ) {
            $product = array();

            $product['asin']  = $productResp->offers[0]->id;
            $product['title'] = $productResp->name;

            $product['producturl'] = ATKPTools::check_sslurl( $productResp->offers[0]->productUrl );
            $product['saleprice']  = $productResp->offers[0]->priceHistory[0]->price->value;

            $product['description'] = strlen( $productResp->description ) > 350 ? substr( $productResp->description, 0, 350 ) : $productResp->description;

            if ( isset( $productResp->identifiers->ean ) ) {
                $product['ean'] = $productResp->identifiers->ean;
            }
            if ( isset( $productResp->identifiers->sku ) ) {
                $product['articlenumber'] = $productResp->identifiers->sku;
            }

            $product['imageurl'] = $this->checkimageurl( $productResp->productImage->url );

            if ( $product['asin'] != '' ) {
                array_push( $products->products, $product );
            }
        }




		return $products;
	}

	private function checkimageurl( $url, $enable_ssl = null ) {
		//in dieser api aktivieren wir die option standardmäßig
		if ( $enable_ssl == null ) {
			$enable_ssl = true;
		} //$this->enable_ssl;

		if ( $enable_ssl ) {
			$url = str_replace( 'http://', 'https://', $url );
		}

		return $url;
	}

	private function fill_product( $result ) {
		if ( ATKPLog::$logenabled ) {
			ATKPLog::LogDebug( '*** fill_product tradedoubler ***' );
			ATKPLog::LogDebug( serialize( $result ) );
			ATKPLog::LogDebug( '*** fill_product tradedoubler ***' );
		}

		$productResp = $result;

		$myproduct = new atkp_product();

		$myproduct->updatedon = ATKPTools::get_currenttime();
		$myproduct->shopid    = $this->shopid;


		$myproduct->description = $productResp->description;
		$myproduct->title       = $productResp->name;
		$myproduct->asin        = $productResp->offers[0]->id;
		if(isset($productResp->mpn))
    		$myproduct->mpn       = $productResp->mpn;


		//$myproduct->smallimageurl = $this->checkimageurl($result->Image60->ImageUrl);
		//$myproduct->mediumimageurl = $this->checkimageurl($result->Image120->ImageUrl);
		$myproduct->largeimageurl = $this->checkimageurl( $productResp->productImage->url );
		$myproduct->producturl    = ATKPTools::check_sslurl( $productResp->offers[0]->productUrl );

		//$myproduct->addtocarturl = $productResponse->getAlternativeDeeplink(false);


		$myproduct->saleprice      = $productResp->offers[0]->priceHistory[0]->price->value;
		$myproduct->salepricefloat = $this->price_to_float( $myproduct->saleprice );

		//$myproduct->listprice  = $productResp->offers[0]->shippingCost;
		//$myproduct->listpricefloat = $this->price_to_float($myproduct->listprice);

		$myproduct->shipping      = $productResp->offers[0]->shippingCost;
		$myproduct->shippingfloat = $this->price_to_float( $myproduct->shipping );


		if ( $productResp->offers[0]->availability != '' ) {
			$myproduct->availability = ( $productResp->offers[0]->availability == true ? __( 'Available', ATKP_PLUGIN_PREFIX ) : __( 'Not available', ATKP_PLUGIN_PREFIX ) ) . '. ';
		}
		if ( $productResp->offers[0]->deliveryTime != '' ) {
			$myproduct->availability .= sprintf( __( 'Delivery in %s days', ATKP_PLUGIN_PREFIX ), $productResp->offers[0]->deliveryTime );
		}


		$myproduct->productgroup = $productResp->categories[0]->name;
		if ( isset( $productResp->identifiers->ean ) ) {
			$myproduct->ean = $productResp->identifiers->ean;
		}
		//$myproduct->manufacturer = (string)$productResp->{'manufacturer-name'};
		$myproduct->brand = $result->brand;


		return $myproduct;


	}

	function cmp( $a, $b ) {

		return strcasecmp( $a['caption'], $b['caption'] );
	}

	public function retrieve_departments() {
		if ( $this->token == null ) {
			throw new Exception( 'checklogon required' );
		}

		$departments = array();

		$departments['AllCategories'] = array(
			'caption'    => __( 'All categories', ATKP_PLUGIN_PREFIX ),
			'sortvalues' => array(
				'priceAsc'             => __( 'Price ascending', ATKP_PLUGIN_PREFIX ),
				'priceDesc'            => __( 'Price descending', ATKP_PLUGIN_PREFIX ),
				'modificationDateAsc'  => __( 'Modification date ascending', ATKP_PLUGIN_PREFIX ),
				'modificationDateDesc' => __( 'Modification date descending', ATKP_PLUGIN_PREFIX ),
			)
		);


		$requestUrl = ATKP_Tradedoubler_Categories;

		$response = $this->send_request( $requestUrl );

		foreach ( $response->categoryTrees[0]->subCategories as $subcat ) {
			$departments[ $subcat->id ] = array(
				'caption'    => $subcat->name,
				'sortvalues' => array(
					'priceAsc'             => __( 'Price ascending', ATKP_PLUGIN_PREFIX ),
					'priceDesc'            => __( 'Price descending', ATKP_PLUGIN_PREFIX ),
					'modificationDateAsc'  => __( 'Modification date ascending', ATKP_PLUGIN_PREFIX ),
					'modificationDateDesc' => __( 'Modification date descending', ATKP_PLUGIN_PREFIX ),
				)
			);

		}

		uasort( $departments, array( $this, 'cmp' ) );


		return $departments;


		//return $this->azhelper->retrieve_departments();
	}

	public function retrieve_filters() {
		$durations = array(
			''  => __( 'Not selected', ATKP_PLUGIN_PREFIX ),
			'q' => __( 'Keywords', ATKP_PLUGIN_PREFIX ),

			'orderBy' => __( 'Sort by', ATKP_PLUGIN_PREFIX ),

			'maxPrice'     => __( 'Maximum price', ATKP_PLUGIN_PREFIX ),
			'minPrice'     => __( 'Minimum price', ATKP_PLUGIN_PREFIX ),
			'manufacturer' => __( 'Manufacturer', ATKP_PLUGIN_PREFIX ),
			'brand'        => __( 'Brand', ATKP_PLUGIN_PREFIX ),
		);

		return $durations;
	}

	public function retrieve_products( $asins, $id_type = 'ASIN' ) {
		$atkpresponse = new atkp_response();

		if ( count( $asins ) == 0 ) {
			return $atkpresponse;
		}

		foreach ( $asins as $asin ) {
			$requestUrl = ATKP_Tradedoubler_Search . ';fid=' . urlencode( $this->aff_shopId );

			try {
				switch ( $id_type ) {
					case 'ASIN':
						$requestUrl .= ';tdId=' . urlencode( $asin );
						break;
					case 'ARTICLENUMBER':
						$requestUrl .= ';spId=' . urlencode( $asin );
						break;
					case 'EAN':
						$requestUrl .= ';ean=' . urlencode( $asin );
						break;
					case 'TITLE':
						// perform a fulltext search
						$requestUrl .= ';q=' . urlencode( $asin ) . ';limit=1';
						break;
					default:
						throw new exception( 'unknown id_type:' . $id_type );
				}
			} catch ( GuzzleHttp\Exception\ClientException $e ) {
				$response = $e->getResponse();
				if ( isset( $response ) ) {
					$titlecheck = $response->getBody();
				} else {
					$titlecheck = $e->getMessage();
				}
			} catch ( Exception $e ) {
				$titlecheck = $e->getMessage();
			}

			$response = $this->send_request( $requestUrl );


			$productfound = false;

			if ( empty( $titlecheck ) && isset( $response->products ) && sizeof( $response->products ) > 0 ) {
				foreach ( $response->products as $result ) {

					$product              = new atkp_response_item();
					$product->productitem = $this->fill_product( $result );
					$product->uniquetype  = $id_type;
					$product->uniqueid    = $asin;

					array_push( $atkpresponse->responseitems, $product );
					$productfound = true;
					break;
				}
			}

			if ( ! $productfound ) {
				$product               = new atkp_response_item();
				$product->errormessage = empty( $titlecheck ) ? 'product not found' : $titlecheck;
				$product->uniqueid     = $asin;
				$product->uniquetype   = $id_type;

				array_push( $atkpresponse->responseitems, $product );
			}
			sleep( 1 );
		}

		return $atkpresponse;
	}

	public function retrieve_list( $requestType, $nodeid, $keyword, $asin, $maxCount, $sortByOrder, $filters ) {
		$mylist            = new atkp_list_resp();
		$mylist->updatedon = ATKPTools::get_currenttime();
		$mylist->asins     = array();

		if ( $nodeid == 'AllCategories' || $nodeid == 'All' ) {
			$nodeid = '';
		}

		$minPrice     = '0';
		$maxPrice     = '0';
		$manufacturer = '';
		$brand        = '';

		foreach ( $filters as $field => $value ) {
			switch ( $field ) {
				case 'q':
					$keyword = $value;
					break;
				case 'orderBy':
					$sortBy = $value;
					break;

				case 'minPrice':
					$minPrice = $value;
					break;
				case 'maxPrice':
					$maxPrice = $value;
					break;
				case 'manufacturer':
					$manufacturer = $value;
					break;
				case 'brand':
					$brand = $value;
					break;

			}
		}

		switch ( $requestType ) {
			case 'ExtendedSearch':
			case 'Search':

				break;
			default:
				throw new Exception( 'requestType not supported: ' . $requestType );
		}

		$results  = null;
		$products = array();

		$itemsperpage = 100;
		$itemsperpage = $itemsperpage > $maxCount ? $maxCount : $itemsperpage;

		$pages = ceil($maxCount / $itemsperpage);

		for ($x = 1; $x <= $pages; $x++) {
			$requestUrl = ATKP_Tradedoubler_Search . ';fid=' . urlencode( $this->aff_shopId );

			if ( $minPrice != '' && $minPrice != '0' ) {
				$requestUrl .= ';minPrice=' . urlencode( $minPrice );
			}
			if ( $maxPrice != '' && $maxPrice != '0' ) {
				$requestUrl .= ';maxPrice=' . urlencode( $maxPrice );
			}

			$requestUrl .= ';page='.$x.';pageSize=' . $itemsperpage;

			if ( $nodeid != '' ) {
				$requestUrl .= ';tdCategoryId=' . urlencode( $nodeid );
			}
			if ( $manufacturer != '' ) {
				$requestUrl .= ';manufacturer=' . urlencode( $manufacturer );
			}
			if ( $brand != '' ) {
				$requestUrl .= ';brand=' . urlencode( $brand );
			}

			if ( $sortByOrder != '' ) {
				$requestUrl .= ';orderBy=' . urlencode( $sortByOrder );
			}

			if ( $keyword != '' ) {
				$requestUrl .= ';q=' . urlencode( $keyword );
			}


			$response = $this->send_request( $requestUrl );

			foreach ( $response->products as $productResp ) {
				array_push( $products, $this->fill_product( $productResp ) );

				if(count($products) >= $maxCount)
					break;
			}

			if(count($response->products) == 0 || count($products) >= $maxCount)
				break;
		}
		$mylist->products = $products;


		return $mylist;
	}

	public function get_supportedlistsources() {
		return '20,30';
	}


}