<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_shop_provider_ebay extends atkp_shop_provider_base {
	//das ist die basis klasse für alle shop provider

	public function __construct() {

	}

	public function get_caption() {
		return __( 'eBay API', ATKP_PLUGIN_PREFIX );
	}

	public function get_maxproductcount() {
		return 20;
	}

	public function get_defaultlogo() {
		return '';
	}

	public function retrieve_browsenodes( $keyword ) {

	}

	public function replace_trackingid( $shopId, $url, $trackingId ) {
		//$associateTag = ATKPTools::get_post_setting($shopId, ATKP_SHOP_POSTTYPE.'_access_tracking_id');

		if ( $url == '' ) {
			return $url;
		}


		$startpos = strrpos( $url, '&campid=' );

		if ( ! $startpos ) {

			throw new exception( 'trackingcode not found: ' . $url );

		} else {
			$startpos = $startpos + 8;
		}

		$endofstring = substr( $url, $startpos );

		$endpos = stripos( $endofstring, '&' );

		if ( ! $endpos ) {
			$endpos = strlen( $endofstring );
		}

		//echo $url .'<br /><br />';
		//echo $startpos.'<br /><br />';
		//echo $endpos.'<br /><br />';
		//echo $endofstring.'<br /><br />';
		//echo substr($url, 0, $startpos).'<br /><br />';
		//echo  substr($url, $endpos, strlen($url) - $endpos).'<br /><br />';


		$url = substr( $url, 0, $startpos ) . $trackingId . substr( $endofstring, $endpos, strlen( $endofstring ) - $endpos );
		//echo $url;
		//exit;

		//$url =  str_replace('&AssociateTag='.$associateTag, '&AssociateTag='.$trackingId, $url);
		//$url =  str_replace('&tag='.$associateTag, '&tag='.$trackingId, $url);
		//$url =  str_replace('?tag='.$associateTag, '?tag='.$trackingId, $url);

		return $url;
	}

	public function check_configuration( $post_id ) {
		try {
			$appId      = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_appId' );
			$certId     = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_certId' );
			$devId      = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_devId' );
			$globalId   = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_globalId' );
			$trackingId = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_trackingId' );

			$message = '';
			if ( $appId != '' && $certId != '' && $devId != '' ) {

				//if (!class_exists('DTS\eBaySDK\Sdk'))
				//    require_once  ATKP_PLUGIN_DIR.'/lib/ebay/ebay-sdk-php-autoloader.php';

				require_once ATKP_PLUGIN_DIR . '/lib/vendor/autoload.php';

				$service = new  DTS\eBaySDK\Finding\Services\FindingService( [
					'apiVersion' => '1.13.0',
					'globalId'   => $globalId,

					'credentials' => [
						'appId'  => $appId,
						'certId' => $certId,
						'devId'  => $devId
					]
				] );


				$trackingurl = '';

				$request           = new DTS\eBaySDK\Finding\Types\FindItemsByKeywordsRequest();
				$request           = $this->SetupDefaultRequest( $request, $trackingId );
				$request->keywords = 'Harry Potter';

				// Ask for the first 25 items.
				$request->paginationInput                 = new DTS\eBaySDK\Finding\Types\PaginationInput();
				$request->paginationInput->entriesPerPage = 1;
				$request->paginationInput->pageNumber     = 1;

				// Ask for the results to be sorted from high to low price.
				$request->sortOrder = 'CurrentPriceHighest';

				// Send the request.
				$response = $service->findItemsByKeywords( $request );

				if ( ATKPLog::$logenabled ) {
					ATKPLog::LogDebug( '*** check_configuration ebay ***' );
					ATKPLog::LogDebug( serialize( $response ) );
					ATKPLog::LogDebug( '*** check_configuration ebay ***' );
				}

				if ( $response->ack !== 'Success' ) {
					$message = '';
					foreach ( $response->errorMessage->error as $error ) {
						$message += $error->message;

					}
				} else {
					foreach ( $response->searchResult->item as $item ) {

						//Info: bei der shopping api werden keine affiliate infos an die url per api angehängt.
						$trackingurl = str_replace( $item->itemId, '{productid}', $item->viewItemURL );

						break;
					}
				}

				ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_trackingurl', $trackingurl );

				//fake subshops

				$subshopsold = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops' );
				$subshops    = array();

				//add subshop for amazon
				$subshop         = new subshop();
				$subshop->title  = __( 'eBay', ATKP_PLUGIN_PREFIX );
				$subshop->shopid = $post_id;

				$subshop->logourl      = plugins_url( 'images/ebay-logo.png', ATKP_PLUGIN_FILE );
				$subshop->smalllogourl = plugins_url( 'images/ebay-logo-small.png', ATKP_PLUGIN_FILE );

				$subshop->enabled = true;

				array_push( $subshops, $subshop );

				//für bestehende alte subshops ist dieser teil noch drinnen
				if ( is_array( $subshopsold ) ) {
					foreach ( $subshopsold as $shopold ) {
						if ( $subshop->shopid == $shopold->shopid && $subshop->programid == $shopold->programid ) {
							$subshop->enabled            = $shopold->enabled;
							$subshop->customtitle        = $shopold->customtitle;
							$subshop->customsmalllogourl = $shopold->customsmalllogourl;
							$subshop->customlogourl      = $shopold->customlogourl;
							$subshop->customfield1       = $shopold->customfield1;
							$subshop->customfield2       = $shopold->customfield2;
							$subshop->customfield3       = $shopold->customfield3;
						}
					}
				}

				ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops', $subshops );


			} else {
				//wenn zugangscodes gelöscht werden muss message auch geleert werden
				$message = 'Credientials are empty';
			}

			return $message;

		} catch ( GuzzleHttp\Exception\ClientException $e ) {
			$response = $e->getResponse();
			if ( isset( $response ) ) {
				$titlecheck = $response->getBody();
			} else {
				$titlecheck = $e->getMessage();
			}

			if ( ATKPLog::$logenabled ) {
				ATKPLog::LogError( $titlecheck );
			}


			return $titlecheck;

		} catch ( Exception $e ) {
			if ( ATKPLog::$logenabled ) {
				ATKPLog::LogError( $e->getMessage() );
			}

			return $e->getMessage();
		}
	}

	public function set_configuration( $post_id ) {

		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_appId', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_ebay_access_appId', 'string' ) );
		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_certId', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_ebay_access_certId', 'string' ) );
		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_devId', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_ebay_access_devId', 'string' ) );
		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_globalId', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_ebay_access_globalId', 'string' ) );
		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_access_trackingId', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_ebay_access_trackingId', 'string' ) );
		//ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_enable_ssl', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_ebay_enable_ssl', 'bool' ) );

		ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_load_customer_reviews', ATKPTools::get_post_parameter( ATKP_SHOP_POSTTYPE . '_ebay_load_customer_reviews', 'bool' ) );


		//$subshops=  ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE.'_default_shops');

		//if($subshops == null)
		//    $subshops = $this->get_defaultshops($post_id);

		//if(is_array($subshops))
		//    $this->read_subshop_settings($subshops, 'ebay');

		//ATKPTools::set_post_setting( $post_id, ATKP_SHOP_POSTTYPE.'_default_shops', $subshops);

	}

	public function get_configuration( $post ) {
		$webservice = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_webservice' );

		$subshops = null;
		$appId    = '';
		$certId   = '';
		$devId    = '';

		if ( $webservice == '4' ) {
			$subshops = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_default_shops' );

			$appId  = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_appId' );
			$certId = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_certId' );
			$devId  = ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_devId' );

			//if($subshops == null)
			//    $subshops = $this->get_defaultshops($post->ID);
		}
		?>
        <tr valign="top">
            <th scope="row">
                <label for="">
					<?php _e( 'App ID', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
                <input style="width:40%" type="text" id="<?php echo ATKP_SHOP_POSTTYPE . '_ebay_access_appId' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_ebay_access_appId' ?>" value="<?php echo $appId; ?>">
                <label for="">
                </label>
            </td>
        </tr>

        <tr valign="top">
            <th scope="row">
                <label for="">
					<?php _e( 'Dev ID', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
                <input style="width:40%" type="password" id="<?php echo ATKP_SHOP_POSTTYPE . '_ebay_access_devId' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_ebay_access_devId' ?>" value="<?php echo $devId; ?>">
            </td>
        </tr>

        <tr valign="top">
            <th scope="row">
                <label for="">
					<?php _e( 'Cert ID', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
                <input style="width:40%" type="password" id="<?php echo ATKP_SHOP_POSTTYPE . '_ebay_access_certId' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_ebay_access_certId' ?>" value="<?php echo $certId; ?>">
            </td>
        </tr>


        <tr valign="top">
            <th scope="row">
                <label for="<?php echo ATKP_SHOP_POSTTYPE . '_ebay_website' ?>">
					<?php _e( 'eBay Website', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
                <select name="<?php echo ATKP_SHOP_POSTTYPE . '_ebay_access_globalId' ?>">
					<?php
					//        public static $locations = array('de', 'com', 'co.uk', 'ca', 'fr', 'co.jp', 'it', 'cn', 'es', 'in', 'com.br');

					$locations = array(
						'EBAY-DE'    => __( 'eBay Germany', ATKP_PLUGIN_PREFIX ),
						'EBAY-AT'    => __( 'eBay Austria', ATKP_PLUGIN_PREFIX ),
						'EBAY-US'    => __( 'eBay United States', ATKP_PLUGIN_PREFIX ),
						'EBAY-ENCA'  => __( 'eBay Canada (English)', ATKP_PLUGIN_PREFIX ),
						'EBAY-GB'    => __( 'eBay UK', ATKP_PLUGIN_PREFIX ),
						'EBAY-AU'    => __( 'eBay Australia', ATKP_PLUGIN_PREFIX ),
						'EBAY-FRBE'  => __( 'eBay Belgium (French)', ATKP_PLUGIN_PREFIX ),
						'EBAY-FR'    => __( 'eBay France', ATKP_PLUGIN_PREFIX ),
						'EBAY-MOTOR' => __( 'eBay Motors', ATKP_PLUGIN_PREFIX ),
						'EBAY-IT'    => __( 'eBay Italy', ATKP_PLUGIN_PREFIX ),
						'EBAY-NLBE'  => __( 'eBay Belgium (Dutch)', ATKP_PLUGIN_PREFIX ),
						'EBAY-NL'    => __( 'eBay Netherlands', ATKP_PLUGIN_PREFIX ),
						'EBAY-ES'    => __( 'eBay Spain', ATKP_PLUGIN_PREFIX ),
						'EBAY-CH'    => __( 'eBay Switzerland', ATKP_PLUGIN_PREFIX ),
						'EBAY-HK'    => __( 'eBay Hong Kong', ATKP_PLUGIN_PREFIX ),
						'EBAY-IN'    => __( 'eBay India', ATKP_PLUGIN_PREFIX ),
						'EBAY-IE'    => __( 'eBay Ireland', ATKP_PLUGIN_PREFIX ),
						'EBAY-MY'    => __( 'eBay Malaysia', ATKP_PLUGIN_PREFIX ),
						'EBAY-FRCA'  => __( 'eBay Canada (French)', ATKP_PLUGIN_PREFIX ),
						'EBAY-PH'    => __( 'eBay Philippines', ATKP_PLUGIN_PREFIX ),
						'EBAY-PL'    => __( 'eBay Poland', ATKP_PLUGIN_PREFIX ),
						'EBAY-SG'    => __( 'eBay Singapore', ATKP_PLUGIN_PREFIX ),
					);


					foreach ( $locations as $value => $name ) {
						if ( $value == ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_globalId' ) ) {
							$sel = ' selected';
						} else {
							$sel = '';
						}


						echo '<option value="' . $value . '"' . $sel . '>' . $name . '</option>';
					} ?>
                </select>
            </td>
        </tr>

        <tr valign="top">
            <th scope="row">
                <label for="">
					<?php _e( 'Campaign ID', ATKP_PLUGIN_PREFIX ) ?>:
                </label>
            </th>
            <td>
                <input style="width:40%" type="text" id="<?php echo ATKP_SHOP_POSTTYPE . '_ebay_access_trackingId' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_ebay_access_trackingId' ?>"
                       value="<?php echo ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_access_trackingId' ); ?>">
                <label for="">
                </label>
            </td>
        </tr>
<!--
        <tr valign="top">
            <th scope="row">

            </th>
            <td>
                <input type="checkbox" id="<?php echo ATKP_SHOP_POSTTYPE . '_ebay_enable_ssl' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_ebay_enable_ssl' ?>"
                       value="1" <?php echo checked( 1, ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_enable_ssl' ), true ); ?>>
                <label for="<?php echo ATKP_SHOP_POSTTYPE . '_ebay_enable_ssl' ?>">
					<?php _e( 'Enable SSL for pictures', ATKP_PLUGIN_PREFIX ) ?>
                </label>
            </td>
        </tr>
-->
        <tr valign="top">
            <th scope="row">

            </th>
            <td>
                <input type="checkbox" id="<?php echo ATKP_SHOP_POSTTYPE . '_ebay_load_customer_reviews' ?>"
                       name="<?php echo ATKP_SHOP_POSTTYPE . '_ebay_load_customer_reviews' ?>"
                       value="1" <?php echo checked( 1, ATKPTools::get_post_setting( $post->ID, ATKP_SHOP_POSTTYPE . '_load_customer_reviews' ), true ); ?>>
                <!-- ATKPTools::get_post_setting($post->ID, ATKP_SHOP_POSTTYPE.'_load_customer_reviews') -->
                <label for="<?php echo ATKP_SHOP_POSTTYPE . '_ebay_load_customer_reviews' ?>">
					<?php _e( 'Scrape customer reviews, availability and shipping costs from website (not recommended)', ATKP_PLUGIN_PREFIX ) ?>
                </label>
            </td>
        </tr>
        <!--
                        <tr valign="top">
                            <th scope="row">
                                
                            </th>
                            <td>
                            <?php
		//if(isset($subshops) && is_array($subshops))
		//    $this->echo_subshop_settings($subshops,'ebay', true);
		?>
                            
                            </td>
                        </tr>-->

		<?php
	}

	private function get_defaultshops( $post_id ) {
		$subshops = array();

		$subshop = new subshop();

		$subshop->title = __( 'eBay', ATKP_PLUGIN_PREFIX );

		$subshop->logourl      = plugins_url( 'images/ebay-logo.png', ATKP_PLUGIN_FILE );
		$subshop->smalllogourl = plugins_url( 'images/ebay-logo-small.png', ATKP_PLUGIN_FILE );

		$subshop->shopid    = $post_id;
		$subshop->programid = '';

		$subshop->enabled = true;

		array_push( $subshops, $subshop );

		return $subshops;
	}

	public function get_shops( $post_id, $allshops = false ) {
		$subshops = ATKPTools::get_post_setting( $post_id, ATKP_SHOP_POSTTYPE . '_default_shops' );

		if ( $subshops == null ) {
			$subshops = $this->get_defaultshops( $post_id );
		}

		foreach ( $subshops as $subshop ) {
			$subshop->shopid    = $post_id;
			$subshop->programid = '';

			$subshop->logourl      = $subshop->customlogourl == '' ? $subshop->logourl : $subshop->customlogourl;
			$subshop->smalllogourl = $subshop->customsmalllogourl == '' ? $subshop->smalllogourl : $subshop->customsmalllogourl;
			$subshop->title        = $subshop->customtitle == '' ? $subshop->title : $subshop->customtitle;

			$subshop->enabled = true;
		}

		return $subshops;
	}

	private $helper = null;
	private $helper2 = null;
	private $enable_ssl = false;
	private $trackingId = null;

	private $globalid = null;

	private $shopidinit = null;

	private $load_customer_reviews = false;

	public function checklogon( $shop ) {

		require_once ATKP_PLUGIN_DIR . '/lib/vendor/autoload.php';

		$this->shopidinit            = $shop->id;
		$this->trackingId            = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_access_trackingId' );
		$this->enable_ssl            = true; // ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_enable_ssl' );
		$this->load_customer_reviews = ATKPTools::get_post_setting( $shop->settingid, ATKP_SHOP_POSTTYPE . '_load_customer_reviews' );


		$this->shopid = $shop->id;
		$this->resetlogon();


	}

	public function resetlogon() {
		$shopid = $this->shopidinit;

		$appId          = ATKPTools::get_post_setting( $shopid, ATKP_SHOP_POSTTYPE . '_access_appId' );
		$certId         = ATKPTools::get_post_setting( $shopid, ATKP_SHOP_POSTTYPE . '_access_certId' );
		$devId          = ATKPTools::get_post_setting( $shopid, ATKP_SHOP_POSTTYPE . '_access_devId' );
		$this->globalid = $globalId = ATKPTools::get_post_setting( $shopid, ATKP_SHOP_POSTTYPE . '_access_globalId' );


		$this->helper = new  DTS\eBaySDK\Finding\Services\FindingService( [
			'apiVersion' => '1.13.0',
			'globalId'   => $globalId,

			'credentials' => [
				'appId'  => $appId,
				'certId' => $certId,
				'devId'  => $devId
			]
		] );


		$this->helper2 = new DTS\eBaySDK\Shopping\Services\ShoppingService( [
			'apiVersion' => '951',
			'globalId'   => $globalId,

			'credentials' => [
				'appId'  => $appId,
				'certId' => $certId,
				'devId'  => $devId
			]
		] );
	}

	private function SetupDefaultRequest( $request, $trackingid = '' ) {
		//TODO: geotargeting in die einstellungen auslagern

		if ( $trackingid == '' ) {
			$trackingid = $this->trackingId;
		}

		if ( $trackingid != '' ) {
			$request->affiliate               = new DTS\eBaySDK\Finding\Types\Affiliate();
			$request->affiliate->networkId    = '9';
			$request->affiliate->trackingId   = $trackingid;
			$request->affiliate->geoTargeting = true;
		}


		return $request;

	}

	public function quick_search( $keyword, $searchType, $pagination = 1 ) {
		if ( $this->helper == null ) {
			throw new Exception( 'checklogon required' );
		}


		$products = new atkp_search_resp();

		$request           = new DTS\eBaySDK\Finding\Types\FindItemsByKeywordsRequest();
		$request           = $this->SetupDefaultRequest( $request );
		$request->keywords = $keyword;

		$itemFilter            = new DTS\eBaySDK\Finding\Types\ItemFilter();
		$itemFilter->name      = 'HideDuplicateItems';
		$itemFilter->value[]   = 'true';
		$request->itemFilter[] = $itemFilter;

		// Ask for the first 25 items.
		$request->paginationInput                 = new DTS\eBaySDK\Finding\Types\PaginationInput();
		$request->paginationInput->entriesPerPage = 10;
		$request->paginationInput->pageNumber     = $pagination;

		// Ask for the results to be sorted from high to low price.
		$request->sortOrder = 'BestMatch';

		$request->outputSelector[] = DTS\eBaySDK\Finding\Enums\OutputSelectorType::C_GALLERY_INFO;

		// Send the request.
		$response = $this->helper->findItemsByKeywords( $request );


		if ( $response->ack !== 'Success' ) {
			$message = '';
			foreach ( $response->errorMessage->error as $error ) {
				$message += $error->message;

			}
			throw new Exception( $message );
		} else {
		    $products->total = intval($response->paginationOutput->totalEntries);
		    $products->currentpage = intval($response->paginationOutput->pageNumber);
		    $products->pagecount = intval($response->paginationOutput->totalPages);

			foreach ( $response->searchResult->item as $item ) {

				$product = array();

				foreach ( $item->galleryInfoContainer->galleryURL as $galleryurl ) {

					if ( $galleryurl->gallerySize == 'Small' ) {
						$product['imageurl'] = $this->checkimageurl( $galleryurl->value );
						break;
					}
				}

				$product['asin'] = $item->itemId;

				$viewItemURL = str_replace( '&item=0', '&item=' . $item->itemId, $item->viewItemURL );

				$product['producturl'] = $viewItemURL;
				$product['title']      = $item->title;


				$product['saleprice']   = $item->sellingStatus->currentPrice->value;
				$product['description'] = $item->subtitle;

				if ( $product['asin'] != '' ) {
					array_push( $products->products, $product );
				}


				//echo serialize($product);exit;
				//printf("(%s) %s:%.2f\n", $item->itemId, $item->title, $item->sellingStatus->currentPrice->value);
			}
		}


		return $products;

	}

	private function checkimageurl( $url ) {

		if ( $this->enable_ssl ) {
			$url = str_replace( 'http://', 'https://', $url );
		}

		return $url;
	}

	private function fill_product( $result ) {
		if ( ATKPLog::$logenabled ) {
			ATKPLog::LogDebug( '*** fill_product ebay ***' );
			ATKPLog::LogDebug( serialize( $result ) );
			ATKPLog::LogDebug( '*** fill_product ebay ***' );
		}

		$myproduct = new atkp_product();


		$myproduct->updatedon = ATKPTools::get_currenttime();
		$myproduct->shopid    = $this->shopid;


		//$myproduct->features = $result->DescriptionShort;
		//$myproduct->description = $result->Description;
		$myproduct->title = $result->Title;
		$myproduct->asin  = $result->ItemID;

		//um mehr infos zu bekommen wie z.b. Beschreibung muss ein extra request abgesetzt werden


		//echo serialize ($shoppingResult->Item);exit;

		$myproduct->description = $this->strip_html_tags( $result->Description ); // strip_tags($result->Description, '<p><a><b><br /><img><textarea><li><ol><ul><table>');

		$myproduct->features = '<ul>';

		$myproduct->features .= '<li>' . $result->ConditionDisplayName . ', ' . $result->ConditionDescription . '</li>';


		$myproduct->productgroup = $result->PrimaryCategoryName;
		if ( $result->SecondaryCategoryName != '' ) {
			$myproduct->productgroup .= ' > ' . $result->SecondaryCategoryName;
		}

		$myproduct->productgroup = str_replace( ':', ' > ', $myproduct->productgroup );

		//PrimaryCategoryName
		//SecondaryCategoryName

		if ( isset( $result->ItemSpecifics->NameValueList ) ) {
			foreach ( $result->ItemSpecifics->NameValueList as $nameValues ) {

				switch ( $nameValues->Name ) {
					case'MPN':
					case'Herstellernummer':
						$myproduct->mpn = implode( ' ', iterator_to_array( $nameValues->Value ) );
						break;
					//case'Produkttyp':
					//	$myproduct->productgroup = implode( ', ', iterator_to_array( $nameValues->Value ) );
					//	break;
					case 'Marke':
						$myproduct->brand = $myproduct->manufacturer = implode( ', ', iterator_to_array( $nameValues->Value ) );
						break;
					case 'UPC':
					case 'EAN':
						$myproduct->ean = implode( ', ', iterator_to_array( $nameValues->Value ) );
						break;
					default:
						$myproduct->features .= '<li>' . $nameValues->Name . ': ' . ( implode( ', ', iterator_to_array( $nameValues->Value ) ) ) . '</li>';
						break;
				}

			}
		}
		$myproduct->features .= '</ul>';


		$myproduct->availability = '';

		if ( $result->HandlingTime > 0 ) {
			$myproduct->availability .= sprintf( __( 'Delivery in %s business days after in-payment', ATKP_PLUGIN_PREFIX ), $result->HandlingTime );
		}


		if ( $result->ShipToLocations != null ) {
			if ( $myproduct->availability != '' ) {
				$myproduct->availability .= ' ';
			}

			$myproduct->availability .= sprintf( __( 'Shipping to: %s', ATKP_PLUGIN_PREFIX ), implode( ', ', iterator_to_array( $result->ShipToLocations ) ) );
		}
		if ( isset( $result->DiscountPriceInfo->OriginalRetailPrice->value ) ) {
			$myproduct->listprice      = $result->DiscountPriceInfo->OriginalRetailPrice->value;
			$myproduct->listpricefloat = $this->price_to_float( $myproduct->listprice );
		}

		$myproduct->saleprice      = $result->CurrentPrice->value;
		$myproduct->salepricefloat = $this->price_to_float( $myproduct->saleprice );
		//echo serialize($result->Item);exit;

		//Die Versandkosten können leider nicht einfach so geladen werden weil sie von mehreren Faktoren abhängig sind.
		$myproduct->shipping      = 0;//$result->Item->ShippingCostSummary->ShippingServiceCost->value;
		$myproduct->shippingfloat = $this->price_to_float( $myproduct->shipping );

		$images = array();
		$idx    = 0;
		if ( is_object( $result->PictureURL ) ) {
			foreach ( $result->PictureURL as $picture ) {

				$udf     = new atkp_product_image();
				$udf->id = uniqid();

				if ( $idx == 0 ) {
					$myproduct->smallimageurl  = $this->checkimageurl( $picture );
					$myproduct->mediumimageurl = $this->checkimageurl( $picture );
					$myproduct->largeimageurl  = $this->checkimageurl( $picture );
				} else {
					$udf->smallimageurl  = $this->checkimageurl( $picture );
					$udf->mediumimageurl = $this->checkimageurl( $picture );
					$udf->largeimageurl  = $this->checkimageurl( $picture );

					array_push( $images, $udf );
				}

				$idx += 1;
			}
		}

		$myproduct->images = $images;

		//producturl finden
		$trackingurl = '';

		$request           = new DTS\eBaySDK\Finding\Types\FindItemsByKeywordsRequest();
		$request           = $this->SetupDefaultRequest( $request );
		$request->keywords = $result->ItemID;

		//$request->outputSelector[] = DTS\eBaySDK\Finding\Enums\OutputSelectorType::C_CATEGORY_HISTOGRAM;

		// Ask for the first 25 items.
		$request->paginationInput                 = new DTS\eBaySDK\Finding\Types\PaginationInput();
		$request->paginationInput->entriesPerPage = 1;
		$request->paginationInput->pageNumber     = 1;

		// Send the request.
		$response = $this->helper->findItemsByKeywords( $request );


		if ( $response->ack !== 'Success' ) {
			if ( ATKPLog::$logenabled ) {
				ATKPLog::LogDebug( '*** link finder error ebay ***' );
				ATKPLog::LogDebug( serialize( $response ) );
				ATKPLog::LogDebug( '*** link finder error ebay ***' );
			}
			//verkaufspreis auf 0 setzen - der link ist schließlich nicht da!
			$myproduct->saleprice      = '';
			$myproduct->salepricefloat = 0;
		} else {
			foreach ( $response->searchResult->item as $item ) {
				$trackingurl = $item->viewItemURL;


				if ( strpos( $trackingurl, 'rover.ebay.com' ) !== false ) {
					$trackingurl = str_replace( '&item=0', '&item=' . $item->itemId, $trackingurl );
				} else {
					$trackingurl = 'http://rover.ebay.com/rover/1/707-53477-19255-0/1?ff3=4&pub=5575171282&toolid=10001&campid=' . $this->trackingId . '&customid=&mpre=' . urlencode( $trackingurl );
				}
				break;
			}
		}


		$myproduct->producturl = $trackingurl;
		//producturl finden


		//$trackingurl = ATKPTools::get_post_setting( $this->shopid, ATKP_SHOP_POSTTYPE.'_trackingurl');;

		// if($trackingurl != '') {
		//       $myproduct->producturl = str_replace('{productid}', $result->ItemID, $trackingurl);

		//   } else {
		//     $myproduct->producturl = 'http://rover.ebay.com/rover/1/707-53477-19255-0/1?ff3=2&toolid=10041&campid='.$this->trackingId.'&customid=&lgeo=1&vectorid=229487&item='.$result->ItemID;
		//}

		/*** get product detail from ebay webpage ***/
		$productInfos = $this->getScrapedData( $result->ViewItemURLForNaturalSearch );

		if ( isset( $productInfos['availability'] ) ) {
			$myproduct->availability = $productInfos['availability'];
		}

		if ( isset( $productInfos['shipping'] ) ) {
			$myproduct->shipping = $productInfos['shipping'];
		}

		if ( isset( $productInfos['shippingfloat'] ) ) {
			$myproduct->shippingfloat = $productInfos['shippingfloat'];
		}
		if ( isset( $productInfos['ratingvalue'] ) ) {
			$myproduct->rating = $productInfos['ratingvalue'];
		}
		if ( isset( $productInfos['reviewcount'] ) ) {
			$myproduct->reviewcount       = $productInfos['reviewcount'];
			$myproduct->customerreviewurl = $myproduct->producturl . '#rwid';
		}

		if ( $myproduct->producturl == '' ) {
			//wenn producturl leer ist -> price auf 0 setzen
			$myproduct->listprice      = '';
			$myproduct->listpricefloat = 0;


			$myproduct->saleprice      = '';
			$myproduct->salepricefloat = 0;

			$myproduct->shipping      = '';
			$myproduct->shippingfloat = 0;
		}

		/*** get product detail from ebay webpage ***/


		//reviews zum produkt laden
		//TODO: Ein/Ausschalter in shop hinterlagen
		//Info: offenbar hat anscheinend die api oder die sdk einen bug und deshalb kommt zu den request nur ein fehler
		/*
						if(false) {

								$review = $this->getReviewByProductid($result->ItemID);

								echo serialize($review);exit;

								$myproduct->rating = $review->ReviewDetails->AverageRating;
								$myproduct->reviewcount = $review->ReviewCount;

						}*/


		return $myproduct;
	}

	//To remove all the hidden text not displayed on a webpage
	function strip_html_tags( $str ) {

		$str = preg_replace( '/(<|>)\1{2}/is', '', $str );
		$str = preg_replace(
			array(// Remove invisible content
				'@<head[^>]*?>.*?</head>@siu',
				'@<style[^>]*?>.*?</style>@siu',
				'@<script[^>]*?.*?</script>@siu',
				'@<noscript[^>]*?.*?</noscript>@siu',
				'@<a[^>]*?.*?</a>@siu',
			),
			"", //replace above with nothing
			$str );
		$str = $this->replaceWhitespace( $str );
		$str = strip_tags( $str, "<p><b><br /><textarea><li><ol><ul><table>" );

		return $str;
	} //function strip_html_tags ENDS

//To replace all types of whitespace with a single space
	function replaceWhitespace( $str ) {
		$result = $str;
		foreach (
			array(
				"  ",
				" \t",
				" \r",
				" \n",
				"\t\t",
				"\t ",
				"\t\r",
				"\t\n",
				"\r\r",
				"\r ",
				"\r\t",
				"\r\n",
				"\n\n",
				"\n ",
				"\n\t",
				"\n\r",
			) as $replacement
		) {
			$result = str_replace( $replacement, $replacement[0], $result );
		}

		return $str !== $result ? $this->replaceWhitespace( $result ) : $result;
	}

	private function removeHtml( $text ) {

		$text = strip_tags( $text, "<style><p><a><b><br /><img><textarea><li><ol><ul><table><script>" );

		$substring = substr( $text, strpos( $text, "<style" ), strpos( $text, "</style>" ) + 2 );

		$text = str_replace( $substring, "", $text );

		$substring = substr( $text, strpos( $text, "<script" ), strpos( $text, "</script>" ) );

		$text = str_replace( $substring, "", $text );

		$text = str_replace( array( "\t", "\r", "\n" ), "", $text );
		$text = trim( $text );

		return $text;

	}

	private function getScrapedData( $productdetailpage ) {
		try {

			$result = array();

			if ( ! $this->load_customer_reviews || $this->disablemoreinfo ) {

				return $result;
			}

			if ( function_exists( 'curl_exec' ) ) {

				switch ( $this->globalid ) {
					case 'EBAY-DE':
					case 'EBAY-AT':
						$productdetailpage = str_replace( 'ebay.com', 'ebay.de', $productdetailpage );
						break;
				}

				if ( ! class_exists( 'simple_html_dom' ) ) {
					require_once ATKP_PLUGIN_DIR . '/lib/simple_html_dom.php';
				}

				if ( ! class_exists( 'atkp_curl_helper' ) ) {
					require_once ATKP_PLUGIN_DIR . '/includes/helper/atkp_curl_helper.php';
				}

				$curl = new atkp_curl_helper();

				// Grab cookies from main page, ebay.com
				$curl->curl_cookie_set( 'http://www.ebay.com' );

				$page = $curl->show_page( $productdetailpage );


				//$page = $this->getUrlContent($productdetailpage);

				$html = new simple_html_dom();

				$html->load( $page );

				if ( $html && method_exists( $html, 'find' ) ) {
					$rating = $html->find( 'span.vi-core-prdReviewCntr', 0 );


					if ( method_exists( $rating, 'find' ) ) {
						$ratingValue = $rating->find( 'span[itemprop=ratingValue]', 0 );
						if ( method_exists( $ratingValue, 'getAttribute' ) ) {
							$result['ratingvalue'] = trim( $ratingValue->getAttribute( 'content' ) );
						}

						$reviewCount = $rating->find( 'span[itemprop=reviewCount]', 0 );
						if ( method_exists( $reviewCount, 'getAttribute' ) ) {
							$result['reviewcount'] = trim( $reviewCount->getAttribute( 'content' ) );
						}
					}

					$ava = $html->find( 'div.sh-inline-div', 0 );

					if ( isset( $ava ) && property_exists( $ava, 'plaintext' ) ) {
						$result['availability'] = $ava->plaintext;
					} else {
						$ava = $html->find( 'span.vi-acc-del-range', 0 );

						if ( isset( $ava ) && property_exists( $ava, 'parent' ) ) {
							if ( isset( $ava->parent->plaintext ) ) {
								$result['availability'] = $ava->parent->plaintext;
							}

						} else {
							$ava = $html->find( 'div.sh-del-frst', 0 );
							if ( isset( $ava->plaintext ) ) {
								$result['availability'] = $ava->plaintext;
							}
						}
					}

					$result['availability'] = isset( $result['availability'] ) ? trim( $result['availability'] ) : '';

					if ( stripos( $result['availability'], '&nbsp;' ) !== false ) {
						$result['availability'] = substr( $result['availability'], 0, stripos( $result['availability'], '&nbsp;' ) );
					}

					$ret = $html->find( 'span.sh-cst', 0 );

					if ( method_exists( $ret, 'find' ) ) {
						$versandkosten_raw = $ret->find( 'span', 0 );

						//$versandkosten_translated = $ret->find('span[id=convetedPriceId]', 0);

						$result['shipping'] = $versandkosten_raw;

					} else {
						$ret = $html->find( 'span.sh-fr-cst', 0 );

						if ( isset( $ret ) ) {
							$result['shipping'] = $ret->plaintext;
						}
					}
					$result['shipping']      = ! isset( $result['shipping'] ) ? '' : trim( $result['shipping'] );
					$result['shippingfloat'] = $this->price_to_float( $result['shipping'] );

				}
			}

			return $result;
		} catch ( Exception $e ) {
			ATKPLog::LogError( 'Error on parsing: ' . $e->getMessage() );
		}
	}

	private function getReviewByProductid( $itemId ) {
		$this->resetlogon();
		$request = new DTS\eBaySDK\Shopping\Types\FindReviewsAndGuidesRequestType();

		$productId          = new DTS\eBaySDK\Shopping\Types\ProductIDType();
		$productId->value   = $itemId;
		$productId->type    = 'Reference';
		$request->ProductID = $productId;

		// Send the request.
		$response = $this->helper2->findReviewsAndGuides( $request );

		//echo serialize($response);exit;

		return $response;


	}

	private function getListing( $productIdNumber ) {
		$request = new \DTS\eBaySDK\Finding\Types\FindItemsByProductRequest();
		$request = $this->SetupDefaultRequest( $request );

		$request->outputSelector[] = DTS\eBaySDK\Finding\Enums\OutputSelectorType::C_GALLERY_INFO;
		$request->outputSelector[] = DTS\eBaySDK\Finding\Enums\OutputSelectorType::C_UNIT_PRICE_INFO;

		$productId          = new \DTS\eBaySDK\Finding\Types\ProductId();
		$productId->value   = $productIdNumber;
		$productId->type    = 'ReferenceID';
		$request->productId = $productId;


		$response = $this->helper->findItemsByProduct( $request );

		if ( isset( $response->errorMessage ) ) {
			$mess = '';
			foreach ( $response->errorMessage->error as $error ) {
				if ( $error->severity == \DTS\eBaySDK\Finding\Enums\ErrorSeverity::C_ERROR ) {
					$mess .= $error->message;
				}
			}

			if ( $mess != '' ) {
				throw new Exception( $mess );
			}
		} else {
			if ( $response->ack == 'Failure' ) {
				throw new Exception( 'product error: ' . $asin );
			}

			foreach ( $response->searchResult->item as $item ) {
				return $item;
			}
		}

		return null;
	}

	function cmp( $a, $b ) {

		return strcasecmp( $a['caption'], $b['caption'] );
	}

	public function retrieve_departments() {
		if ( $this->helper == null ) {
			throw new Exception( 'checklogon required' );
		}

		$departments = array();

		$request                  = new \DTS\eBaySDK\Shopping\Types\GetCategoryInfoRequestType();
		$request->CategoryID      = '-1';
		$request->IncludeSelector = 'ChildCategories';

		$response = $this->helper2->getCategoryInfo( $request );

		$cats = $response->CategoryArray->Category;


		foreach ( $cats as $result ) {
			$namex = $result->CategoryName;

			if ( $namex == 'Root' ) {
				$namex = __( 'All categories', ATKP_PLUGIN_PREFIX );
			}

			$departments[ $result->CategoryID ] = array(
				'caption'    => html_entity_decode( $namex ),
				'sortvalues' => array(
					'BestMatch'                => __( 'Best match', ATKP_PLUGIN_PREFIX ),
					'BidCountFewest'           => __( 'Least offers first', ATKP_PLUGIN_PREFIX ),
					'BidCountMost'             => __( 'Most offers first', ATKP_PLUGIN_PREFIX ),
					'CurrentPriceHighest'      => __( 'Price (descending)', ATKP_PLUGIN_PREFIX ),
					'EndTimeSoonest'           => __( 'End time (ascending)', ATKP_PLUGIN_PREFIX ),
					'StartTimeNewest'          => __( 'Starting time (latest first)', ATKP_PLUGIN_PREFIX ),
					'PricePlusShippingHighest' => __( 'Price + shipping (descending)', ATKP_PLUGIN_PREFIX ),
					'PricePlusShippingLowest'  => __( 'Price + shipping (ascending)', ATKP_PLUGIN_PREFIX ),
				)
			);
		}


		uasort( $departments, array( $this, 'cmp' ) );


		return $departments;


		//return $this->azhelper->retrieve_departments();
	}

	public function retrieve_filters() {
		$durations = array(
			''         => __( 'Not selected', ATKP_PLUGIN_PREFIX ),
			'Keywords' => __( 'Keywords', ATKP_PLUGIN_PREFIX ),

			'SortOrder'          => __( 'Sort Order', ATKP_PLUGIN_PREFIX ),
			'CategoryId'         => __( 'Department', ATKP_PLUGIN_PREFIX ),
			'AvailableTo'        => __( 'Available to', ATKP_PLUGIN_PREFIX ),
			'BestOfferOnly'      => __( 'Best offer only', ATKP_PLUGIN_PREFIX ),
			'Condition'          => __( 'Condition', ATKP_PLUGIN_PREFIX ),
			'EndTimeFrom'        => __( 'End time from', ATKP_PLUGIN_PREFIX ),
			'EndTimeTo'          => __( 'End time to', ATKP_PLUGIN_PREFIX ),
			'StartTimeFrom'      => __( 'Start time from', ATKP_PLUGIN_PREFIX ),
			'StartTimeTo'        => __( 'Start time to', ATKP_PLUGIN_PREFIX ),
			'ExcludeCategory'    => __( 'Exclude category', ATKP_PLUGIN_PREFIX ),
			'ExcludeSeller'      => __( 'Exclude seller', ATKP_PLUGIN_PREFIX ),
			'FeaturedOnly'       => __( 'Featured items only', ATKP_PLUGIN_PREFIX ),
			'FreeShippingOnly'   => __( 'Free shipping only', ATKP_PLUGIN_PREFIX ),
			'HideDuplicateItems' => __( 'Hide duplicate items', ATKP_PLUGIN_PREFIX ),
			'MaxHandlingTime'    => __( 'MaxHandlingTime', ATKP_PLUGIN_PREFIX ),
			'MaxPrice'           => __( 'Maximum handling time', ATKP_PLUGIN_PREFIX ),
			'MinPrice'           => __( 'Minimum price', ATKP_PLUGIN_PREFIX ),
			'MinQuantity'        => __( 'Minimum quantity', ATKP_PLUGIN_PREFIX ),
			'Seller'             => __( 'Seller', ATKP_PLUGIN_PREFIX ),
			'TopRatedSellerOnly' => __( 'Only top rated sellers', ATKP_PLUGIN_PREFIX ),
			'ListingType'        => __( 'Listing type', ATKP_PLUGIN_PREFIX ),
		);

		return $durations;
	}

	public function retrieve_product_raw( $asin, $id_type = 'ASIN' ) {
		//info: asin entspricht der productid
		//EAN der ean

		switch ( $id_type ) {
			Case 'ARTICLENUMBER':
			case 'ASIN':
				$request                  = new \DTS\eBaySDK\Shopping\Types\GetSingleItemRequestType();
				$request->IncludeSelector = 'ItemSpecifics,Details,Description';
				$request->ItemID          = $asin;

				$shoppingResult = $this->helper2->getSingleItem( $request );

				if ( isset( $shoppingResult->Errors ) ) {
					foreach ( $shoppingResult->Errors as $error ) {
						if ( $error->SeverityCode === \DTS\eBaySDK\Shopping\Enums\SeverityCodeType::C_ERROR ) {
							//$error->ShortMessage,
							//$error->LongMessage
							throw new Exception( $error->ShortMessage );
						}
					}
				}


				return $shoppingResult->Item;
				break;
			case 'TITLE':
			case 'EAN':
				$request           = new DTS\eBaySDK\Finding\Types\FindItemsByKeywordsRequest();
				$request           = $this->SetupDefaultRequest( $request );
				$request->keywords = $asin;

				// Ask for the first 25 items.
				$request->paginationInput                 = new DTS\eBaySDK\Finding\Types\PaginationInput();
				$request->paginationInput->entriesPerPage = 1;
				$request->paginationInput->pageNumber     = 1;

				// Ask for the results to be sorted from high to low price.
				$request->sortOrder = 'BestMatch';

				// Send the request.
				$response = $this->helper->findItemsByKeywords( $request );

				if ( $response->ack !== 'Success' ) {
					$message = '';
					foreach ( $response->errorMessage->error as $error ) {
						$message += $error->message;

					}
					throw new Exception( $message );
				} else {
					foreach ( $response->searchResult->item as $item ) {
						return $this->retrieve_product_raw( $item->itemId );
					}
				}
				break;

			default:
				throw new exception( 'unknown id_type:' . $id_type );
		}


	}

	public function retrieve_products( $asins, $id_type = 'ASIN' ) {
		$atkpresponse = new atkp_response();

		if ( count( $asins ) == 0 ) {
			return $atkpresponse;
		}

		switch ( $id_type ) {
			case 'ASIN':
			case 'ARTICLENUMBER':
				$parts = array_chunk( $asins, 20 );

				foreach ( $parts as $part ) {

				    $reruncounter =0;
					atkp_ebay_rerun:
					$reruncounter++;
					//reset der connection weil multipleitems beim mehrmaligen ausführen sonst einen curl fehler schmeißt
					$this->resetlogon();

					$request                  = new \DTS\eBaySDK\Shopping\Types\GetMultipleItemsRequestType();
					$request->IncludeSelector = 'ItemSpecifics,Details,Description';
					$request->ItemID          = $part;

					try {
						$results = $this->helper2->getMultipleItems( $request );
					} catch ( GuzzleHttp\Exception\ClientException $e ) {
						$response = $e->getResponse();
						if ( isset( $response ) ) {
							$check = $response->getBody();
						} else {
							$check = $e->getMessage();
						}
					} catch ( Exception $e ) {
						$check = $e->getMessage();
					}

					if ( ! empty( $check ) ) {
						$atkpresponse->errormessage = $check;

						return $atkpresponse;
					}

					if ( is_object( $results ) ) {
						foreach ( $results->Item as $result ) {

							$product              = new atkp_response_item();
							$product->productitem = $this->fill_product( $result );
							$product->uniquetype  = $id_type;

							$product->uniqueid = $this->findinput( $part, $product->productitem->asin );

							array_push( $atkpresponse->responseitems, $product );
						}
					}

					if ( isset( $results->Errors ) ) {
						$invalidasins = array();
						foreach ( $results->Errors as $error ) {
							$errormessage = $error->LongMessage;
							$errorids     = '';
							foreach ( $error->ErrorParameters as $params ) {
								$errorids .= $params->Value;

							}

							foreach ( $part as $asin ) {
								if ( stripos( $errorids, $asin ) !== false ) {
									$product               = new atkp_response_item();
									$product->errormessage = $errormessage;
									$product->uniqueid     = $asin;
									$product->uniquetype   = $id_type;

									array_push( $invalidasins, $asin );

									array_push( $atkpresponse->responseitems, $product );
								}
							}
						}

						//TODO: $invalidasins muss auch fehlende asins enthalten

						$part = array_diff( $part, $invalidasins );

						if ( count( $part ) > 0 && $reruncounter <= 3) {
							goto atkp_ebay_rerun;
						}
					}
				}

				break;
			case 'EAN':
			case 'TITLE':
				$itemids = array();

				foreach ( $asins as $title ) {

					$request           = new DTS\eBaySDK\Finding\Types\FindItemsByKeywordsRequest();
					$request           = $this->SetupDefaultRequest( $request );
					$request->keywords = $title;

					// Ask for the first 25 items.
					$request->paginationInput                 = new DTS\eBaySDK\Finding\Types\PaginationInput();
					$request->paginationInput->entriesPerPage = 3;
					$request->paginationInput->pageNumber     = 1;

					// Ask for the results to be sorted from high to low price.
					$request->sortOrder = 'BestMatch';

					$titlecheck = '';
					try {
						// Send the request.
						$response = $this->helper->findItemsByKeywords( $request );

					} catch ( GuzzleHttp\Exception\ClientException $e ) {
						$response = $e->getResponse();
						if ( isset( $response ) ) {
							$titlecheck = $response->getBody();
						} else {
							$titlecheck = $e->getMessage();
						}
					} catch ( Exception $e ) {
						$titlecheck = $e->getMessage();
					}

					$added = false;

					if ( ! empty( $titlecheck ) || ! isset( $response->searchResult->item ) ) {

						$responseitem               = new atkp_response_item();
						$responseitem->errormessage = empty( $titlecheck ) ? 'product not found' : $titlecheck;

						$responseitem->uniqueid   = $title;
						$responseitem->uniquetype = $id_type;

						array_push( $atkpresponse->responseitems, $responseitem );
						$added = true;

					} else {

						$result = $response->searchResult->item[0];

						$responseitem              = new atkp_response_item();
						$responseitem->productitem = $result->itemId;

						array_push( $itemids, $result->itemId );

						$responseitem->uniqueid   = $title;
						$responseitem->uniquetype = $id_type;

						array_push( $atkpresponse->responseitems, $responseitem );
						$added = true;

					}

					if ( ! $added ) {
						$product               = new atkp_response_item();
						$product->errormessage = 'product not found';
						$product->uniqueid     = $title;
						$product->uniquetype   = $id_type;

						array_push( $atkpresponse->responseitems, $product );
					}
					sleep( 1 );
				}

				$response1 = $this->retrieve_products( $itemids, 'ASIN' );

				foreach ( $response1->responseitems as $responseitem1 ) {
					foreach ( $atkpresponse->responseitems as $xx ) {

						if ( $xx->productitem == $responseitem1->uniqueid ) {
							$xx->productitem = $responseitem1->productitem;

						}
					}

				}

				break;
			default:
				throw new exception( 'unknown id_type:' . $id_type );
		}


		return $atkpresponse;
	}

	public function retrieve_list( $requestType, $nodeid, $keyword, $asin, $maxCount, $sortOrder, $filters ) {
		$mylist            = new atkp_list_resp();
		$mylist->updatedon = ATKPTools::get_currenttime();
		$mylist->asins     = array();

		foreach ( $filters as $field => $value ) {
			switch ( $field ) {
				case 'Keywords':
					$keyword = $value;
					break;
				case 'SortOrder':
					$sortOrder = $value;
					break;
				case 'CategoryId':
					$nodeid = $value;
					break;
			}
		}

		switch ( $requestType ) {
			case 'ExtendedSearch':
			case 'Search':

				break;
			default:
				throw new Exception( 'requestType not supported: ' . $requestType );
		}


		$results    = null;
		$products   = array();
		$isadvanced = false;
		if ( $requestType != 'ExtendedSearch' && ( $nodeid == '-1' || $nodeid == '' || $nodeid == 'All' ) ) {
			$request           = new DTS\eBaySDK\Finding\Types\FindItemsByKeywordsRequest();
			$request           = $this->SetupDefaultRequest( $request );
			$request->keywords = $keyword;

			$itemFilter            = new DTS\eBaySDK\Finding\Types\ItemFilter();
			$itemFilter->name      = 'HideDuplicateItems';
			$itemFilter->value[]   = 'true';
			$request->itemFilter[] = $itemFilter;

		} else {
			$isadvanced = true;
			$request    = new DTS\eBaySDK\Finding\Types\FindItemsAdvancedRequest();
			$request    = $this->SetupDefaultRequest( $request );

			$itemFilter            = new DTS\eBaySDK\Finding\Types\ItemFilter();
			$itemFilter->name      = 'HideDuplicateItems';
			$itemFilter->value[]   = 'true';
			$request->itemFilter[] = $itemFilter;

			$request->keywords = $keyword;
			if ( $nodeid != 'All' && $nodeid != '-1' && $nodeid != '' ) {
				$request->categoryId[] = $nodeid;
			}


			if ( $requestType !== 'Search' ) {
				if ( $filters != null ) {
					foreach ( $filters as $field => $value ) {

						switch ( $field ) {
							case 'ExcludeSeller':
							case 'Seller':
							case 'ExcludeCategory':
							case 'ListingType':
								$itemFilter       = new DTS\eBaySDK\Finding\Types\ItemFilter();
								$itemFilter->name = $field;

								foreach ( explode( ',', $value ) as $val ) {
									if ( $val != '' ) {
										$itemFilter->value[] = $val;
									}
								}

								$request->itemFilter[] = $itemFilter;

								break;

							default:
								$request->itemFilter[] = new DTS\eBaySDK\Finding\Types\ItemFilter( [
									'name'  => $field,
									'value' => array( $value )
								] );
								break;
						}


					}
				}
			}

		}

		if ( $sortOrder != '' ) {
			$request->sortOrder = $sortOrder;
		}

		$maxCount =intval($maxCount);
		$itemsperpage = 100;
		$itemsperpage = $itemsperpage > $maxCount ? $maxCount : $itemsperpage;

		$pages = ceil($maxCount / $itemsperpage);

		for ($x = 1; $x <= $pages; $x++) {
			// Ask for the first 25 items.
			$request->paginationInput                 = new DTS\eBaySDK\Finding\Types\PaginationInput();
			$request->paginationInput->entriesPerPage = $itemsperpage;
			$request->paginationInput->pageNumber     = $x;

			// Send the request.
			if ( ! $isadvanced ) {
				$response = $this->helper->findItemsByKeywords( $request );
			} else {
				$response = $this->helper->findItemsAdvanced( $request );
			}

			if ( $response->ack !== 'Success' ) {
				$message = '';
				foreach ( $response->errorMessage->error as $error ) {
					$message += $error->message;
				}
				//throw new Exception( $message );
                break;
			} else {
				foreach ( $response->searchResult->item as $item ) {
					array_push( $mylist->asins, $item->itemId );
				}
			}

			if(count($response->searchResult->item) == 0 || count($mylist->asins) >= $maxCount)
				break;

			if($x > 1)
			    sleep(1);
		}

		$this->disablemoreinfo = true;
		$response              = $this->retrieve_products( $mylist->asins, 'ASIN' );
		$this->disablemoreinfo = false;


		$products = array();
		foreach ( $response->responseitems as $responseitem ) {
			array_push( $products, $responseitem->productitem );

			if(count($products) >= $maxCount)
				break;
		}


		$mylist->products = $products;

		return $mylist;
	}

	private $disablemoreinfo = false;

	public function get_supportedlistsources() {
		return '20,30';
	}


}