<?php
/**
 * Created by PhpStorm.
 * User: Christof
 * Date: 08.12.2018
 * Time: 14:23
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_options {

	/* @var $loader atkp_options */
	public static $loader = null;
	private $loaded_values;


	public function __construct() {
		$this->loaded_values  = array();
		atkp_options::$loader = $this;
	}

	/**
	 * Get the value of a settings field
	 *
	 * @param string $option settings field name
	 * @param string $section the section name this field belongs to
	 * @param string $default default text if it's not found
	 *
	 * @return mixed
	 */
	private function get_option_pfx( $option, $default = false ) {

		$option_value = get_option( ATKP_PLUGIN_PREFIX . $option, $default );

		return $option_value;
	}

	private function get_cachedoption( $name, $default ) {
		if ( isset( $this->loaded_values[ $name ] ) ) {
			return $this->loaded_values[ $name ];
		} else {
			$optionvalue                  = $this->get_option_pfx( $name, $default );
			$this->loaded_values[ $name ] = $optionvalue;

			return $optionvalue;
		}
	}

	public function get_sitekey() {
		$sitekey = $this->get_cachedoption( '_sitekey', '' );
		if ( $sitekey == '' ) {
			$sitekey = md5( microtime( true ) . AUTH_SALT );
			update_option( ATKP_PLUGIN_PREFIX . '_sitekey', $sitekey );
		}

		return $sitekey;
	}


	public function get_gutenberg_module_enabled() {
		return $this->get_cachedoption( '_gutenberg_module_enabled', false );
	}

	public function get_affiliatechar() {
		return $this->get_cachedoption( '_affiliatechar', '*' );
	}

	public function get_access_mark_links() {
		return $this->get_cachedoption( '_mark_links', 1 );
	}

	//region modules
	public function get_customfields_module_enabled() {
		return $this->get_cachedoption( '_customfields_module_enabled', true );
	}

	public function get_productpages_module_enabled() {
		return $this->get_cachedoption( '_productpages_module_enabled', true );
	}

	public function get_massimport_module_enabled() {
		return $this->get_cachedoption( '_massimport_module_enabled', true );
	}

	public function get_woo_module_enabled() {
		return $this->get_cachedoption( '_woo_module_enabled', true );
	}

	public function get_debug_module_enabled() {
		return $this->get_cachedoption( '_debug_module_enabled', true );
	}

	public function get_shortcodegenerator_module_enabled() {
		return $this->get_cachedoption( '_shortcodegenerator_module_enabled', true );
	}

	public function get_productimportmask_module_enabled() {
		return $this->get_cachedoption( '_productimportmask_module_enabled', true );
	}

	public function get_asa1_module_enabled() {
		return $this->get_cachedoption( '_asa1_module_enabled', true );
	}

	public function get_asa2_module_enabled() {
		return $this->get_cachedoption( '_asa2_module_enabled', true );
	}

	public function get_livelist_module_enabled() {
		return $this->get_cachedoption( '_livelist_module_enabled', true );
	}

	public function get_searchform_module_enabled() {
		return $this->get_cachedoption( '_searchform_module_enabled', true );
	}

	public function get_widget_module_enabled() {
		return $this->get_cachedoption( '_widget_module_enabled', true );
	}


	public function get_floatingbar_module_enabled() {
		return $this->get_cachedoption( '_floatingbar_module_enabled', true );
	}


	public function get_fieldgroups_enabled() {
		return $this->get_cachedoption( '_fieldgroups_enabled', false );
	}


	public function get_pricehistory_enabled() {
		return $this->get_cachedoption( '_pricehistory_enabled', false );
	}


	public function get_productgroups_enabled() {
		return $this->get_cachedoption( '_productgroups_enabled', false );
	}

	public function get_acfenabled() {
		return class_exists( 'acf' ) && $this->get_cachedoption( '_activateacf', false );
	}

	public function get_licensekey() {
		return $this->get_cachedoption( '_license_key', false );

	}

	public function get_licensestatus() {
		return $this->get_cachedoption( '_license_status', false );

	}

	public function get_licensemessage() {
		return $this->get_cachedoption( '_license_message', false );

	}

	public function get_licenseproductid() {
		return $this->get_cachedoption( '_license_productid', false );

	}


	//endregion

	public function get_woo_enabled() {
		if ( isset( $this->loaded_values['wooenabled'] ) ) {
			return $this->loaded_values['wooenabled'];
		} else {
			$wooenabled                        = ( $this->get_option_pfx( '_woo_mode', '' ) != '' ) && class_exists( 'WooCommerce' );
			$this->loaded_values['wooenabled'] = $wooenabled;

			return $wooenabled;
		}
	}


	public function get_woo_mode() {
		return $this->get_cachedoption( '_woo_mode', '' );
	}

	public function get_woo_imagegallerymode() {
		return $this->get_cachedoption( '_woo_imagegallery', 0 );
	}

	public function get_woo_importimagemode() {
		return $this->get_cachedoption( '_woo_importimage', 1 );
	}

	public function get_woo_ean_field() {
		return $this->get_cachedoption( '_woo_ean_field', '' );
	}

	public function get_woo_keytype() {
		return $this->get_cachedoption( '_woo_keytype', 'ean' );
	}


	public function get_cache_duration() {
		return $this->get_cachedoption( '_cache_duration', 1440 );
	}

	public function get_check_enabled() {
		return $this->get_cachedoption( '_check_enabled', false );
	}

	public function get_notification_interval() {
		return $this->get_cachedoption( '_notification_interval', 4320 );
	}

	public function get_access_csv_intervall() {
		return $this->get_cachedoption( '_access_csv_intervall', 1440 );
	}

	public function get_crontype() {
		return $this->get_cachedoption( '_crontype', 'wpcron' );
	}

	public function get_cron_lastclean() {
		return $this->get_cachedoption( '_cron_lastclean', '' );
	}

	public function get_cron_offer_lastimport() {
		return $this->get_cachedoption( '_cron_offer_lastimport', '' );
	}

	public function get_cron_product_lastexport() {
		return $this->get_cachedoption( '_cron_product_lastexport', '' );
	}

	public function get_cron_product_lastimport() {
		return $this->get_cachedoption( '_cron_product_lastimport', '' );
	}

	public function get_cron_csv_lastimport() {
		return $this->get_cachedoption( '_cron_csv_lastimport', '' );
	}

	public function get_cron_csv_lastimportfinished() {
		return $this->get_cachedoption( '_cron_csv_lastimportfinished', '' );
	}

	public function get_cron_list_lastimport() {
		return $this->get_cachedoption( '_cron_list_lastimport', '' );
	}

	public function get_cron_lastlicensecheck() {
		return $this->get_cachedoption( '_cron_lastlicensecheck', '' );

	}

	public function get_cron_lastdatacheck() {
		return $this->get_cachedoption( '_cron_lastdatacheck', '' );
	}


	public function get_cron_from() {
		return $this->get_cachedoption( '_cron_from', '' );
	}

	public function get_cron_to() {
		return $this->get_cachedoption( '_cron_to', '' );
	}

	public function get_product_importimage() {
		return $this->get_cachedoption( '_product_importimage', false );
	}

	public function get_product_imagetype() {
		return $this->get_cachedoption( '_product_imagetype', 0 );
	}

	public function get_duplicatecheck() {
		return $this->get_cachedoption( '_duplicatecheck', 0 );
	}

	public function get_defaultproductstate() {
		return $this->get_cachedoption( '_defaultproductstate', 'draft' );
	}

	public function get_redirectsearchresult() {
		return $this->get_cachedoption( '_redirectsearchresult', 0 );
	}

	public function get_redirectsearchresulttarget() {
		return $this->get_cachedoption( '_redirectsearchresulttarget', '' );
	}

	public function get_additional_shortcode_button() {
		return $this->get_cachedoption( '_additional_shortcode_button', 0 );
	}

	public function get_custom_posttypes() {
		return $this->get_cachedoption( '_custom_posttypes', null );
	}

	public function get_product_enabled() {
		return $this->get_cachedoption( '_product_enabled', false );
	}

	public function get_product_commentenabled() {
		return $this->get_cachedoption( '_product_commentenabled', false );
	}

	public function get_product_slug() {
		return $this->get_cachedoption( '_product_slug', 'product' );
	}

	public function get_product_template() {
		return $this->get_cachedoption( '_product_template', '' );
	}

	public function get_product_archivetemplate() {
		return $this->get_cachedoption( '_product_archivetemplate', '' );
	}


	public function get_product_manufacturer_taxonomy() {
		return $this->get_cachedoption( '_product_manufacturer_taxonomy', strtolower( __( 'Manufacturer', ATKP_PLUGIN_PREFIX ) ) );
	}

	public function get_product_author_taxonomy() {
		return $this->get_cachedoption( '_product_author_taxonomy', strtolower( __( 'Author', ATKP_PLUGIN_PREFIX ) ) );
	}

	public function get_product_brand_taxonomy() {
		return $this->get_cachedoption( '_product_brand_taxonomy', strtolower( __( 'Brand', ATKP_PLUGIN_PREFIX ) ) );
	}

	public function get_product_category_taxonomy() {
		return $this->get_cachedoption( '_product_category_taxonomy', strtolower( __( 'productcategory', ATKP_PLUGIN_PREFIX ) ) );
	}

	public function get_product_importimagemode() {
		return $this->get_cachedoption( '_product_importimage', 0 );
	}

	public function get_show_floatingbar_productpage() {
		return $this->get_cachedoption( '_show_floatingbar_productpage', false );
	}

	public function get_show_floatingbar_mainproduct() {
		return $this->get_cachedoption( '_show_floatingbar_mainproduct', false );
	}

	public function get_show_floatingbar_woocommerce() {
		return $this->get_cachedoption( '_show_floatingbar_woocommerce', false );
	}

	public function get_floatingbar_template() {
		return $this->get_cachedoption( '_floatingbar_template', '' );
	}

	public function get_hide_floatingbar_mobile() {
		return $this->get_cachedoption( '_hide_floatingbar_mobile', false );
	}

	public function get_floatingbar_position() {
		return $this->get_cachedoption( '_floatingbar_position', 0 );
	}

	public function get_disablelightslider() {
		return $this->get_cachedoption( '_disablelightslider', false );
	}

	public function get_disablechartjs() {
		return $this->get_cachedoption( '_disablechartjs', false );

	}


	public function get_disableselect2_backend() {
		return $this->get_cachedoption( '_disableselect2', false );
	}

	public function get_disableselect2_frontend() {
		return $this->get_cachedoption( '_disablefrontendselect2', false );
	}


	//region styles
	public function get_buttonstyle() {
		return $this->get_cachedoption( '_buttonstyle', 1 );
	}

	public function get_btn_color_background_top() {
		return $this->get_cachedoption( '_btn_color_background_top', '#FFB22A' );
	}

	public function get_btn_color_background_bottom() {
		return $this->get_cachedoption( '_btn_color_background_bottom', '#ffab23' );
	}

	public function get_btn_color_foreground() {
		return $this->get_cachedoption( '_btn_color_foreground', '#333333' );
	}

	public function get_btn_color_border() {
		return $this->get_cachedoption( '_btn_color_border', '#ffaa22' );
	}

	public function get_btn_color_background_top_2() {
		return $this->get_cachedoption( '_btn_color_background_top_2', '#FFB22A' );
	}

	public function get_btn_color_background_bottom_2() {
		return $this->get_cachedoption( '_btn_color_background_bottom_2', '#ffab23' );
	}

	public function get_btn_color_foreground_2() {
		return $this->get_cachedoption( '_btn_color_foreground_2', '#333333' );
	}

	public function get_btn_color_border_2() {
		return $this->get_cachedoption( '_btn_color_border_2', '#ffaa22' );
	}

	public function get_boxstyle() {
		return $this->get_cachedoption( '_boxstyle', 1 );
	}

	public function get_predicate1_color() {
		return $this->get_cachedoption( '_predicate1_color', '' );
	}

	public function get_predicate1_highlightcolor() {
		return $this->get_cachedoption( '_predicate1_highlightcolor', '' );
	}

	public function get_predicate2_color() {
		return $this->get_cachedoption( '_predicate2_color', '' );
	}

	public function get_predicate2_highlightcolor() {
		return $this->get_cachedoption( '_predicate2_highlightcolor', '' );
	}

	public function get_predicate3_color() {
		return $this->get_cachedoption( '_predicate3_color', '' );
	}

	public function get_predicate3_highlightcolor() {
		return $this->get_cachedoption( '_predicate3_highlightcolor', '' );
	}

	public function get_predicate1_text() {
		return $this->get_cachedoption( '_predicate1_text', __( 'Winner', ATKP_PLUGIN_PREFIX ) );
	}

	public function get_predicate2_text() {
		return $this->get_cachedoption( '_predicate2_text', __( 'Price Tip', ATKP_PLUGIN_PREFIX ) );
	}

	public function get_predicate3_text() {
		return $this->get_cachedoption( '_predicate3_text', __( 'Custom', ATKP_PLUGIN_PREFIX ) );
	}

	public function get_test_score1_text() {
		return $this->get_cachedoption( '_test_score1_text', __( 'Very good', ATKP_PLUGIN_PREFIX ) );
	}

	public function get_test_score2_text() {
		return $this->get_cachedoption( '_test_score2_text', __( 'Good', ATKP_PLUGIN_PREFIX ) );
	}

	public function get_test_score3_text() {
		return $this->get_cachedoption( '_test_score3_text', __( 'Satisfying', ATKP_PLUGIN_PREFIX ) );
	}

	public function get_test_score4_text() {
		return $this->get_cachedoption( '_test_score4_text', __( 'Enough', ATKP_PLUGIN_PREFIX ) );
	}

	public function get_test_score5_text() {
		return $this->get_cachedoption( '_test_score5_text', __( 'Insufficient', ATKP_PLUGIN_PREFIX ) );
	}

	//endregion

	public function get_disable_sponsored_attribute() {
		return $this->get_cachedoption( '_disable_sponsored_attribute', false );
	}

	public function get_show_disclaimer() {
		return $this->get_cachedoption( '_show_disclaimer', true );
	}

	public function get_disclaimer_text() {
		return $this->get_cachedoption( '_disclaimer_text', stripslashes( __( 'Last updated on %refresh_date% at %refresh_time% - Image source: Amazon Affiliate Program. All statements without guarantee.', ATKP_PLUGIN_PREFIX ) ) );
	}

	public function get_add_to_cart() {
		return $this->get_cachedoption( '_add_to_cart', '' );
	}

	public function get_title_link_type() {
		return $this->get_cachedoption( '_title_link_type', '' );
	}

	public function get_mark_links() {
		return $this->get_cachedoption( '_mark_links', 1 );
	}

	public function get_open_window() {
		return $this->get_cachedoption( '_open_window', 1 );
	}

	public function get_openlinkswithjs() {
		return $this->get_cachedoption( '_jslink', 0 );
	}


	public function get_link_click_tracking() {
		return $this->get_cachedoption( '_link_click_tracking', '' );
	}

	public function get_linkimage() {
		return $this->get_cachedoption( '_linkimage', false );
	}

	public function get_showrating() {
		return $this->get_cachedoption( '_showrating', true );
	}

	public function get_linkrating() {
		return $this->get_cachedoption( '_linkrating', false );
	}


	public function get_moreoffers_title() {
		return $this->get_cachedoption( '_moreoffers_title', __( 'Additional offers »', ATKP_PLUGIN_PREFIX ) );
	}

	public function get_moreoffers_template() {
		return $this->get_cachedoption( '_moreoffers_template', '' );
	}

	public function get_version_csv() {
		return $this->get_cachedoption( '_version_csv', 0 );
	}


	public function get_show_nota_template() {
		return $this->get_cachedoption( '_show_nota_template', false );
	}


	public function get_nota_template() {
		return $this->get_cachedoption( '_nota_template', '' );
	}


	public function get_nota_disable_link() {
		return $this->get_cachedoption( '_nota_disable_link', false );
	}

	//region ASA1 fields
	public function get_asa1_enabled() {
		return $this->get_cachedoption( '_asa_activate', false );
	}

	public function get_asa1_shopid() {
		return $this->get_cachedoption( '_asa_shopid', '' );
	}

	public function get_asa1_poststatus() {
		return $this->get_cachedoption( '_asa_poststatus', 'publish' );
	}

	public function get_asa1_templateid( $i ) {
		return $this->get_cachedoption( '_asa_templateid' . $i, '' );
	}

	public function get_asa1_templatename( $i ) {
		return $this->get_cachedoption( '_asa_templatename' . $i, '' );
	}

	public function get_asa1_importresult() {
		return $this->get_cachedoption( '_asa_importresult', '' );
	}

	public function get_asa1_allcollections() {
		return $this->get_cachedoption( '_asa_allcollections', 0 );
	}
	//endregion

	//region ASA2 fields
	public function get_asa2_enabled() {
		return $this->get_cachedoption( '_asa2_activate', false );
	}

	public function get_asa2_shopid() {
		return $this->get_cachedoption( '_asa2_shopid', '' );
	}

	public function get_asa2_poststatus() {
		return $this->get_cachedoption( '_asa2_poststatus', 'publish' );
	}

	public function get_asa2_templateid( $i ) {
		return $this->get_cachedoption( '_asa2_templateid' . $i, '' );
	}

	public function get_asa2_templatename( $i ) {
		return $this->get_cachedoption( '_asa2_templatename' . $i, '' );
	}

	public function get_asa2_importresult() {
		return $this->get_cachedoption( '_asa2_importresult', '' );
	}

	public function get_asa2_allcollections() {
		return $this->get_cachedoption( '_asa2_allcollections', 0 );
	}

	public function get_asa2_descriptionfield() {
		return $this->get_cachedoption( '_asa2_descriptionfield', ATKP_PRODUCT_POSTTYPE . '_description' );
	}

	//endregion

	public function get_productgroupascategory() {
		return $this->get_cachedoption( '_productgroupascategory', false );
	}

	public function get_productgroupdeleteoldentries() {
		return $this->get_cachedoption( '_productgroupdeleteoldentries', false );
	}

	public function get_productgroupsplitchar() {
		return $this->get_cachedoption( '_productgroupsplitchar', '' );
	}

	public function get_ignoreoffernotfound() {
		return $this->get_cachedoption( '_ignoreoffernotfound', false );
	}


	public function get_showprice() {
		return $this->get_cachedoption( '_showprice', true );
	}

	public function get_linkprime() {
		return $this->get_cachedoption( '_linkprime', false );
	}

	public function get_showpricediscount() {
		return $this->get_cachedoption( '_showpricediscount', true );
	}

	public function get_showstarrating() {
		return $this->get_cachedoption( '_showstarrating', true );
	}

	public function get_hideemptystars() {
		return $this->get_cachedoption( '_hideemptystars', false );
	}

	public function get_hideemptyrating() {
		return $this->get_cachedoption( '_hideemptyrating', false );
	}

}