<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_settings_license {
	private $base = null;

	/**
	 * Construct the plugin object
	 */
	public function __construct( $pluginbase ) {
		$base = $pluginbase;

	}


	public function license_configuration_page() {
		$mytab = ATKPTools::get_get_parameter( 'tab', 'int' );

		if ( $mytab != 0 ) {
			$tab = $mytab;
		} else {
			$tab = 1;
		}

		ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_licensepage', true );

		//atkp_check_license();

		$products = atkp_get_license_products();

		$license = atkp_options::$loader->get_licensekey();
		$status  = atkp_options::$loader->get_licensestatus();
		$message = atkp_options::$loader->get_licensemessage();
		$item_id = atkp_options::$loader->get_licenseproductid();

		if ( ATKPTools::exists_post_parameter( 'saveglobal' ) && check_admin_referer( 'save', 'save' ) ) {
			//speichern der einstellungen

			if ( ! current_user_can( 'manage_options' ) ) {
				wp_die( __( 'You do not have sufficient permissions to access this page', ATKP_PLUGIN_PREFIX ) );
			}

			$license = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_license_key', 'string' );
			$item_id = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_license_productid', 'int' );

			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_license_key', $license );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_license_productid', $item_id );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_license_message', '' );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_customer_name', '' );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_customer_email', '' );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_licensepage', false );

		}

		if ( isset( $_POST[ ATKP_PLUGIN_PREFIX . '_license_deactivate' ] ) ) {
			if ( ! current_user_can( 'manage_options' ) ) {
				wp_die( __( 'You do not have sufficient permissions to access this page', ATKP_PLUGIN_PREFIX ) );
			}

			// run a quick security check
			if ( ! check_admin_referer( 'save', 'save' ) ) {
				return;
			}

			$license = trim( atkp_options::$loader->get_licensekey() );
			$item_id = atkp_options::$loader->get_licenseproductid();

			$api_params = array(
				'edd_action' => 'deactivate_license',
				'license'    => $license,
				'url'        => home_url(),
				'item_id'    => $item_id
			);
			// Call the custom API.
			$response = wp_remote_post( ATKP_STORE_URL, array(
				'timeout'   => 15,
				'sslverify' => true,
				'body'      => $api_params
			) );
			// make sure the response came back okay
			if ( is_wp_error( $response ) || 200 !== wp_remote_retrieve_response_code( $response ) ) {
				$message = ( is_wp_error( $response ) && ! empty( $response->get_error_message() ) ) ? $response->get_error_message() : __( 'An error occurred, please try again.' );
			} else {

				$license_data = json_decode( wp_remote_retrieve_body( $response ) );

				//if ( true === $license_data->success ) {
				$status = $license_data->license;
				ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_license_status', '' );
				ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_license_message', '' );
				ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_customer_name', '' );
				ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_customer_email', '' );
				ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_licensepage', false );


			}
		}
		// listen for our activate button to be clicked
		if ( isset( $_POST[ ATKP_PLUGIN_PREFIX . '_license_activate' ] ) ) {

			if ( ! current_user_can( 'manage_options' ) ) {
				wp_die( __( 'You do not have sufficient permissions to access this page', ATKP_PLUGIN_PREFIX ) );
			}

			// run a quick security check
			if ( ! check_admin_referer( 'save', 'save' ) ) {
				return;
			} // get out if we didn't click the Activate button
			// retrieve the license from the database

			$license = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_license_key', 'string' );
			$item_id = ATKPTools::get_post_parameter( ATKP_PLUGIN_PREFIX . '_license_productid', 'int' );

			if ( $license != '' && $item_id != '' ) {
				ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_license_key', $license );
				ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_license_productid', $item_id );
			} else {
				$license = trim( atkp_options::$loader->get_licensekey() );
				$item_id = atkp_options::$loader->get_licenseproductid();
			}
			// data to send in our API request
			$api_params = array(
				'edd_action' => 'activate_license',
				'license'    => $license,
				'url'        => home_url(),
				'item_id'    => $item_id
			);
			// Call the custom API.
			$response = wp_remote_post( ATKP_STORE_URL, array(
				'timeout'   => 15,
				'sslverify' => true,
				'body'      => $api_params
			) );
			// make sure the response came back okay
			if ( is_wp_error( $response ) || 200 !== wp_remote_retrieve_response_code( $response ) ) {
				$message = ( is_wp_error( $response ) && ! empty( $response->get_error_message() ) ) ? $response->get_error_message() : __( 'An error occurred, please try again.' );
			} else {

				$license_data = json_decode( wp_remote_retrieve_body( $response ) );

				$message = atkp_check_license_message( $license_data, $products[ $item_id ] );
			}

			// $license_data->license will be either "valid" or "invalid"
			$status = $license_data->license;
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_license_status', $license_data->license );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_customer_name', $license_data->customer_name );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_customer_email', $license_data->customer_email );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_license_message', $message );
			ATKPTools::set_setting( ATKP_PLUGIN_PREFIX . '_licensepage', false );

		}


		?>
        <div class="atkp-content wrap">
            <div class="inner">


                <form method="POST"
                      action="?page=<?php echo ATKP_PLUGIN_PREFIX . '_affiliate_toolkit-plugin&tab=' . $tab ?>">
					<?php wp_nonce_field( "save", "save" ); ?>
                    <table class="form-table" style="width:100%">


                        <tr valign="top">
                            <th scope="row" style="background-color:gainsboro; padding:7px" colspan="2">
								<?php _e( 'License', ATKP_PLUGIN_PREFIX ) ?>
                            </th>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'Package', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <select <?php echo( $status !== false && $status == 'valid' ? 'disabled' : '' ) ?>
                                        id="<?php echo ATKP_PLUGIN_PREFIX . '_license_productid' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_license_productid' ?>"
                                        style="width:300px">
									<?php
									foreach ( $products as $product => $caption ) {
										echo '<option value="' . $product . '" ' . ( $item_id == $product ? 'selected' : '' ) . ' >' . $caption . '</option>';
									}


									?>
                                </select>
                            </td>
                        </tr>

                        <tr valign="top">
                            <th scope="row">
                                <label for="">
									<?php _e( 'License Key', ATKP_PLUGIN_PREFIX ) ?>:
                                </label>
                            </th>
                            <td>
                                <input <?php echo( $status !== false && $status == 'valid' ? 'disabled' : '' ) ?>
                                        required="required" id="<?php echo ATKP_PLUGIN_PREFIX . '_license_key' ?>"
                                        name="<?php echo ATKP_PLUGIN_PREFIX . '_license_key' ?>" type="text"
                                        class="regular-text" value="<?php esc_attr_e( $license ); ?>"/>
                                <label class="description"
                                       for="<?php echo ATKP_PLUGIN_PREFIX . '_license_key' ?>"><?php _e( 'Enter your license key', ATKP_PLUGIN_PREFIX ); ?></label>
                            </td>
                        </tr>

						<?php if ( false !== $license ) { ?>
                            <tr valign="top">
                                <th scope="row" valign="top">
									<?php _e( 'Activate License' ); ?>
                                </th>
                                <td>
									<?php if ( $status !== false && $status == 'valid' ) { ?>

                                        <span style="color:green;"><?php _e( 'active' ); ?></span>
                                        <input type="submit" class="button-secondary"
                                               name="<?php echo ATKP_PLUGIN_PREFIX . '_license_deactivate' ?>"
                                               value="<?php _e( 'Deactivate License' ); ?>"/>
									<?php } else if ( $license != '' ) { ?>

                                        <span style="color:red;">
                                            <p><?php echo $message; ?></p>
                                    </span>
                                        <input type="submit" class="button-secondary"
                                               name="<?php echo ATKP_PLUGIN_PREFIX . '_license_activate' ?>"
                                               value="<?php _e( 'Activate License' ); ?>"/>
									<?php } ?>
                                </td>
                            </tr>
						<?php } ?>


                        <tr valign="top">
                            <th scope="row">
                            </th>
                            <td>
								<?php if ( ! ( $status !== false && $status == 'valid' ) ) {
									submit_button( '', 'primary', 'saveglobal', false );
								} ?>
                            </td>
                        </tr>

                    </table>
                </form>

            </div>
        </div>


		<?php
	}
}

?>