<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_settings {
	public static $settings;

	/**
	 * Construct the plugin object
	 */
	public function __construct( $pluginbase ) {
		add_action( 'admin_menu', array( &$this, 'admin_menu' ) );
	}

	function admin_menu() {

		add_menu_page(
			__( 'Affiliate Toolkit', ATKP_PLUGIN_PREFIX ),
			__( 'Affiliate Toolkit', ATKP_PLUGIN_PREFIX ),
			'edit_pages',
			ATKP_PLUGIN_PREFIX . '_affiliate_toolkit-plugin',
			array( &$this, 'toolkit_settings' ),
			plugin_dir_url( __FILE__ ) . '/images/affiliate_toolkit_menu.png',
			100
		);

		add_submenu_page(
			ATKP_PLUGIN_PREFIX . '_affiliate_toolkit-plugin',
			__( 'Settings', ATKP_PLUGIN_PREFIX ),
			__( 'Settings', ATKP_PLUGIN_PREFIX ),
			'manage_options',
			ATKP_PLUGIN_PREFIX . '_affiliate_toolkit-plugin',
			array( &$this, 'toolkit_settings' )
		);

	}


	public function toolkit_settings() {
		if ( ! is_user_logged_in() ) {
			wp_die( __( 'You do not have sufficient permissions to access this page', ATKP_PLUGIN_PREFIX ) );
		}

		?>

        <h2 class="nav-tab-wrapper atkp-nav-tab">
			<?php
			$mytab = ATKPTools::get_get_parameter( 'tab', 'int' );

			if ( $mytab != 0 ) {
				$tab = $mytab;
			} else {
				$tab = 1;
			}

			$current = 1;
			foreach ( atkp_settings::$settings as $key => $value ) {
				$class = ( $tab == $current ) ? ' nav-tab-active' : '';
				//echo '<a class="nav-tab'.$class.'" href="'.admin_url().'/index.php??page='.ATKP_PLUGIN_PREFIX.'_affiliate_toolkit-plugin&tab='.$count.">'.$key.'xx</a>";


				?> <a class="nav-tab<?php echo $class ?>"
                      href="<?php echo admin_url() ?>admin.php?page=<?php echo ATKP_PLUGIN_PREFIX . '_affiliate_toolkit-plugin' ?>&tab=<?php echo $current ?>"><?php echo $key ?></a><?php
				$current = $current + 1;
			}
			?>

        </h2>


		<?php

		$current = 1;
		foreach ( atkp_settings::$settings as $key => $value ) {
			if ( $tab == $current ) {
				call_user_func( $value );
				break;
			}
			$current = $current + 1;
		}

		?>


        <div class="atkp-credits">
            <h3 class="hndle"><?php echo __( 'Affiliate Toolkit', ATKP_PLUGIN_PREFIX ) . ' ' . ATKPSettings::plugin_get_version() ?></h3>
            <div class="inside">
                <a href="http://www.affiliate-toolkit.com" target="_blank"
                   title="affiliate-toolkit.com - Affiliate Marketing Plugin"><img
                            style="margin-left:40px; margin-right:40px"
                            src="<?php echo plugins_url( 'images/logo-admin.png', __FILE__ ); ?>"
                            title="affiliate-toolkit.com - Affiliate Marketing Plugin"
                            alt="affiliate-toolkit.com - Affiliate Marketing Plugin"></a>

                <h4 class="inner"><?php _e( 'Do you need any help?', ATKP_PLUGIN_PREFIX ) ?></h4>
                <p class="inner"><?php echo ATKPHomeLinks::ReplaceLinkType( __( 'If you have any problems with our plugin, first take a look at our <a href="%link_help%" target="_blank">Help Center</a>. If you need further assistance, please <a href="%link_support%" target="_blank">contact us</a>.', ATKP_PLUGIN_PREFIX ) ) ?></p>
                <hr>
                <h4 class="inner"><?php _e( 'Do you like the plugin?', ATKP_PLUGIN_PREFIX ) ?></h4>

                <p class="inner">
					<?php echo ATKPHomeLinks::ReplaceLinkType( __( 'Add your review and keep recommending us. As an affiliate you can even make money when ordering! More information is available <a href="%link_affiliate%" target="_blank">here</a>!', ATKP_PLUGIN_PREFIX ) ) ?>
                </p>
                <p class="inner">
					<?php echo ATKPHomeLinks::ReplaceLinkType( __( 'We appreciate any form of feedback to improve the plugin. Send us your praise or your criticism. Simply use the <a href="%link_contact%" target="_blank">contact form</a>.', ATKP_PLUGIN_PREFIX ) ) ?>
                </p>
                <hr>
                <p class="atkp-link inner">Created by <a href="http://www.servit.biz" target="_blank"
                                                         title="servit.biz - Quality plugins for WordPress"><img
                                src="<?php echo plugins_url( 'images/logo_servit-biz.png', __FILE__ ); ?>"
                                title="servit.biz - Quality plugins for WordPress"
                                alt="servit.biz - Quality plugins for WordPress"></a></p>
            </div>
        </div>

		<?php

	}
}


?>