<?php
/**
 * Plugin Name: Affiliate Toolkit
 * Plugin URI: https://www.affiliate-toolkit.com
 * Description: A plugin for smart affiliates. This plugin provides you an interface to the best affiliate platforms.
 * Version: 2.6.2
 * Author: Christof Servit
 * Author URI: https://www.servit.biz
 * Text Domain: ATKP
 * Domain Path: /lang
 * License: GPL2
 */

define( 'ATKP_UPDATE_VERSION', '2.6.2' );

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

define( 'ATKP_PLUGIN_PREFIX', 'ATKP' );
define( 'ATKP_PLUGIN_DIR', dirname( __FILE__ ) );
define( 'ATKP_PLUGIN_FILE', __FILE__ );

define( 'ATKP_PLUGIN_VERSION', 30 );


add_action( 'plugins_loaded', 'my_affiliate_toolkit_lang' );
function my_affiliate_toolkit_lang() {
	//load_plugin_textdomain(ATKP_PLUGIN_PREFIX , false, dirname(plugin_basename(__FILE__)) .'/lang' );

	/** Set our unique textdomain string */
	$textdomain = ATKP_PLUGIN_PREFIX;
	/** The 'plugin_locale' filter is also used by default in load_plugin_textdomain() */
	$locale = apply_filters( 'plugin_locale', get_locale(), $textdomain );
	/** Set filter for WordPress languages directory */
	$wp_lang_dir = WP_LANG_DIR . '/' . basename( dirname( __FILE__ ) ) . '/' . $textdomain . '-' . $locale . '.mo';
	/** Translations: First, look in WordPress' "languages" folder = custom & update-secure! */
	load_textdomain( $textdomain, $wp_lang_dir );


	/** Translations: Secondly, look in plugin's "lang" folder = default */
	$plugin_dir = basename( dirname( __FILE__ ) );
	$lang_dir   = dirname( plugin_basename( __FILE__ ) ) . '/lang/';
	load_plugin_textdomain( $textdomain, false, $lang_dir );


}

require_once ATKP_PLUGIN_DIR . '/includes/atkp_basics.php';

if ( atkp_options::$loader->get_widget_module_enabled() ) {
	new atkp_widget();
	new atkp_filterwidget();
}

//** Plugin initialisieren **//

add_action( 'init', 'my_affiliate_toolkit_init' );

function my_affiliate_toolkit_init() {
	if ( version_compare( get_bloginfo( 'version' ), '4.0', '<' ) ) {
		wp_die( "You must update WordPress to use affiliate-toolkit!" );
	}

	$wootools =  atkp_options::$loader->get_woo_module_enabled()  ? new atkp_tools_woo( array() ) : null;

	if ( is_admin() ) {
		$atkp_settings = new atkp_settings( array() );
		$atkp_welcome  = new atkp_welcome( array() );

		$atkp_settings::$settings = array(
			__( 'General settings', ATKP_PLUGIN_PREFIX )  => array(
				new atkp_settings_toolkit( array() ),
				'toolkit_configuration_page'
			),
			__( 'Advanced settings', ATKP_PLUGIN_PREFIX ) => array(
				new atkp_settings_advanced( array() ),
				'advanced_configuration_page'
			),
			__( 'Display settings', ATKP_PLUGIN_PREFIX )  => array(
				new atkp_settings_display( array() ),
				'display_configuration_page'
			),
			__( 'License', ATKP_PLUGIN_PREFIX )  => array(
			new atkp_settings_license( array() ),
			'license_configuration_page'
		)
		);

		if ( atkp_options::$loader->get_customfields_module_enabled() ) {
			$atkp_settings::$settings[ __( 'Custom fields', ATKP_PLUGIN_PREFIX ) ] = array(
				new atkp_settings_customfield( array() ),
				'customfield_configuration_page'
			);
		}

		if ( atkp_options::$loader->get_productpages_module_enabled() ) {
			$atkp_settings::$settings[ __( 'Product page', ATKP_PLUGIN_PREFIX ) ] = array(
				new atkp_settings_product( array() ),
				'product_configuration_page'
			);
		}

		if ( atkp_options::$loader->get_asa1_module_enabled() || atkp_options::$loader->get_asa2_module_enabled() ) {
			$atkp_compatibility = new atkp_compatibility( array() );

			$atkp_compatibility::$modes = array();

			if ( atkp_options::$loader->get_asa1_module_enabled() ) {
				$atkp_compatibility::$modes[ __( 'Amazon Simple Admin 1', ATKP_PLUGIN_PREFIX ) ] = array(
					new atkp_compatibility_asa1( array() ),
					'compatibilitymode_configuration_page'
				);
			}

			if ( atkp_options::$loader->get_asa2_module_enabled() ) {
				$atkp_compatibility::$modes[ __( 'Amazon Simple Affiliate 2', ATKP_PLUGIN_PREFIX ) ] = array(
					new atkp_compatibility_asa2( array() ),
					'compatibilitymode_configuration_page'
				);
			}
		}

		$temptools = array();

		$temptools[ __( 'Import template', ATKP_PLUGIN_PREFIX ) ] = array(
			new atkp_tools_importtemplate( array() ),
			'importtools_configuration_page'
		);

		if ( atkp_options::$loader->get_massimport_module_enabled() ) {


			$temptools[ __( 'Import lists', ATKP_PLUGIN_PREFIX ) ] = array(
				new atkp_tools_importlist( array() ),
				'importlist_configuration_page'
			);

			$temptools[ __( 'Import products', ATKP_PLUGIN_PREFIX ) ] = array(
				new atkp_tools_importproduct( array() ),
				'importproduct_configuration_page'
			);
		}

		if ( atkp_options::$loader->get_woo_module_enabled() ) {
			$temptools[ __( 'WooCommerce', ATKP_PLUGIN_PREFIX ) ] = array(
				$wootools,
				'woo_configuration_page'
			);
		}

		if ( atkp_options::$loader->get_debug_module_enabled() ) {
			$temptools[ __( 'Debug', ATKP_PLUGIN_PREFIX ) ] = array(
				new atkp_tools_debug( array() ),
				'debug_configuration_page'
			);
		}

		new atkp_tools_shortcodegenerator( array() );


		if ( count( $temptools ) > 0 ) {
			$atkp_tools         = new atkp_tools( array() );
			$atkp_tools::$tools = $temptools;
		}

		new atkp_posttypes_shop( array() );
		new atkp_posttypes_product( array() );
		new atkp_posttypes_list( array() );
		new atkp_posttypes_template( array() );

		if ( atkp_options::$loader->get_fieldgroups_enabled() ) {
			new atkp_posttypes_fieldgroup( array() );
		}
		if ( atkp_options::$loader->get_shortcodegenerator_module_enabled() || atkp_options::$loader->get_gutenberg_module_enabled() ) {
			new atkp_shortcode_generator2( array() );
		}

		add_action( 'admin_enqueue_scripts', 'my_affiliate_toolkit_admin_styles' );

		if ( atkp_options::$loader->get_productimportmask_module_enabled() ) {
			$atkp_import = new atkp_bulkimport( array() );
		}


	} else {

		new atkp_posttypes_product( array() );
		new atkp_posttypes_template( array() );

		if ( atkp_options::$loader->get_floatingbar_module_enabled() ) {
			new atkp_floatingbar( array() );
		}

		if ( atkp_options::$loader->get_fieldgroups_enabled() ) {
			new atkp_posttypes_fieldgroup( array() );
		}

		add_action( 'wp_enqueue_scripts', 'my_affiliate_toolkit_styles' );

		//enable shortcodes at widget area
		//add_filter('widget_text', 'do_shortcode');

		if ( atkp_options::$loader->get_woo_module_enabled() ) {
			new atkp_tools_woo( array() );
		}
	}


	//shortcodes für diverse backend editoren immer erzeugen..

	new atkp_shortcodes_product( array() );
	new atkp_shortcodes_list( array() );
	if ( atkp_options::$loader->get_livelist_module_enabled() ) {
		new atkp_shortcodes_livelist( array() );
	}
	if ( atkp_options::$loader->get_searchform_module_enabled() ) {
		new atkp_shortcodes_searchform( array() );
	}
	if ( atkp_options::$loader->get_asa1_module_enabled() ) {
		new atkp_shortcodes_asa1( array() );
	}
	if ( atkp_options::$loader->get_asa2_module_enabled() ) {
		new atkp_shortcodes_asa2( array() );
	}
	new atkp_external_featuredimage();
	new atkp_wp_cronjob( array() );
}

if ( atkp_options::$loader->get_gutenberg_module_enabled() ) {
	new atkp_gutenberg_editor( array() );
}

new atkp_endpoints( array() );

function my_affiliate_toolkit_admin_styles( $hook ) {
	$fontawesome = false;
	$codemirror  = false;

	if ( 'toplevel_page_ATKP_affiliate_toolkit-plugin' == $hook || 'affiliate-toolkit_page_ATKP_affiliate_toolkit-compatibility' == $hook || 'affiliate-toolkit_page_ATKP_affiliate_toolkit-tools' == $hook || 'affiliate-toolkit_page_ATKP_affiliate_toolkit-welcome' == $hook || 'atkp_product_page_atkp_bulkimport' == $hook || 'affiliate-toolkit_page_ATKP_affiliate_toolkit-shortcodegenerator' == $hook ) {
		wp_register_style( 'atkp-styles', plugins_url( '/css/admin-style.css', __FILE__ ) );
		wp_enqueue_style( 'atkp-styles' );

		if ( $hook == 'toplevel_page_ATKP_affiliate_toolkit-plugin' || 'affiliate-toolkit_page_ATKP_affiliate_toolkit-shortcodegenerator' == $hook ) {
			$fontawesome = true;
		}

		$codemirror = true;
		$colorpicker = true;
	} else if ( 'post.php' == $hook || 'post-new.php' == $hook ) {
		wp_register_style( 'atkp-styles', plugins_url( '/css/style.css', __FILE__ ) );
		wp_enqueue_style( 'atkp-styles' );

		$fontawesome = true;

		$codemirror = true;
	}

	if ( $fontawesome ) {
		wp_register_style( 'atkp-fontawesome', plugins_url( '/lib/font-awesome/css/font-awesome.min.css', __FILE__ ) );
		wp_enqueue_style( 'atkp-fontawesome' );
	}

	if ( $codemirror ) {
		wp_register_style( 'atkp-codemirror', plugins_url( '/lib/codemirror/codemirror.css', __FILE__ ) );
		wp_enqueue_style( 'atkp-codemirror' );


		wp_register_script( 'atkp-codemirror-script', plugins_url( '/lib/codemirror/codemirror.js', __FILE__ ) );
		wp_register_script( 'atkp-codemirror-xml', plugins_url( '/lib/codemirror/mode/xml/xml.js', __FILE__ ) );
		wp_register_script( 'atkp-codemirror-html', plugins_url( '/lib/codemirror/mode/htmlmixed/htmlmixed.js', __FILE__ ) );
		wp_register_script( 'atkp-codemirror-css', plugins_url( '/lib/codemirror/mode/css/css.js', __FILE__ ) );

		wp_enqueue_script( 'atkp-codemirror-script' );
		wp_enqueue_script( 'atkp-codemirror-xml' );
		wp_enqueue_script( 'atkp-codemirror-html' );
		wp_enqueue_script( 'atkp-codemirror-css' );
	}

	//if($colorpicker) {
		//http://dev.servit.biz/wp-admin/js/color-picker.js
		//http://dev.servit.biz/wp-admin/css/color-picker.css
/*
		wp_register_style( 'wp-color-picker', plugins_url( '/../../../wp-admin/css/color-picker.css', __FILE__ ) );
		wp_register_script( 'wp-color-picker', plugins_url( '/../../../wp-admin/js/color-picker.js', __FILE__ ) );

		wp_enqueue_style( 'wp-color-picker');
		wp_enqueue_script( 'wp-color-picker');
*/

	//}

	$disable_select2 = ATKPTools::get_setting( ATKP_PLUGIN_PREFIX . '_disableselect2', false );

	if ( ! $disable_select2 ) {
		wp_register_style( 'atkp-select2-styles', plugins_url( '/lib/select2/css/select2.min.css', __FILE__ ) );
		wp_enqueue_style( 'atkp-select2-styles' );

		wp_register_script( 'atkp-select2-scripts', plugins_url( '/lib/select2/js/select2.min.js', __FILE__ ) );
		wp_enqueue_script( 'atkp-select2-scripts' );
	}
}

function my_affiliate_toolkit_styles() {

	if ( ! ATKPSettings::$disablestyles ) {
		wp_register_style( 'atkp-styles', plugins_url( '/css/style.css', __FILE__ ) );

		$custom_styleurl = ATKPTools::get_global_style_url();

		if ( $custom_styleurl == null ) {
			ATKPTools::add_global_styles( 'atkp-styles' );
		}

		wp_enqueue_style( 'atkp-styles' );

		if ( $custom_styleurl != null ) {
			wp_register_style( 'atkp-styles-custom', $custom_styleurl );
			wp_enqueue_style( 'atkp-styles-custom' );

		}
	}


	$disablelightslider = ATKPTools::get_setting( ATKP_PLUGIN_PREFIX . '_disablelightslider', false );

	if ( ! $disablelightslider ) {

		wp_register_style( 'atkp-lightslider-styles', plugins_url( '/lib/lightslider/css/lightslider.min.css', __FILE__ ) );
		wp_enqueue_style( 'atkp-lightslider-styles' );

		wp_register_script( 'atkp-lightslider-scripts', plugins_url( '/lib/lightslider/js/lightslider.min.js', __FILE__ ) );
		wp_enqueue_script( 'atkp-lightslider-scripts' );
	}


	$disable_frontend_select2 = ATKPTools::get_setting( ATKP_PLUGIN_PREFIX . '_disablefrontendselect2', false );

	if ( ! $disable_frontend_select2 ) {
		wp_register_style( 'atkp-select2-styles', plugins_url( '/lib/select2/css/select2.min.css', __FILE__ ) );
		wp_enqueue_style( 'atkp-select2-styles' );

		wp_register_script( 'atkp-select2-scripts', plugins_url( '/lib/select2/js/select2.min.js', __FILE__ ) );
		wp_enqueue_script( 'atkp-select2-scripts' );
	}

	wp_register_script( 'atkp-scripts', plugins_url( '/js/library.js', __FILE__ ) );

	if ( ! atkp_options::$loader->get_disablechartjs() ) {

		wp_register_style( 'atkp-chartjs-styles', plugins_url( '/lib/chartjs/Chart.css', __FILE__ ) );
		wp_enqueue_style( 'atkp-chartjs-styles' );


		wp_register_script( 'atkp-chartjs-utils-scripts', plugins_url( '/lib/chartjs/utils.js', __FILE__ ) );
		wp_enqueue_script( 'atkp-chartjs-utils-scripts' );

		wp_register_script( 'atkp-chartjs-scripts', plugins_url( '/lib/chartjs/Chart.js', __FILE__ ) );
		wp_enqueue_script( 'atkp-chartjs-scripts' );
	}


	$custom_scripturl = ATKPTools::get_global_script_url();

	if ( $custom_scripturl == null ) {
		ATKPTools::add_global_scripts( 'atkp-scripts' );
	}

	wp_enqueue_script( 'atkp-scripts' );


	if ( $custom_scripturl != null ) {

		wp_register_script( 'atkp-scripts-custom', $custom_scripturl, array('atkp-lightslider-scripts') );
		wp_enqueue_script( 'atkp-scripts-custom' );

	}
}


// retrieve our license key from the DB
$license = trim( atkp_options::$loader->get_licensekey() );
$item_id = atkp_options::$loader->get_licenseproductid();

// setup the updater
$edd_updater = new ATKP_SL_Plugin_Updater( ATKP_STORE_URL, ATKP_PLUGIN_FILE, array(
	'version' 	=> ATKP_UPDATE_VERSION,		// current version number
	'license' 	=> $license,	// license key (used get_option above to retrieve from DB)
	'item_id'       => $item_id,	// id of this plugin
	'author' 	=> 'Christof Servit',	// author of this plugin
	'url'           => home_url(),
	'beta'          => false // set to true if you wish customers to receive update notifications of beta releases
) );

define( 'ATKP_INIT', '1' );


?>