<!-- Ad Template with Carousel Layout-->

<div class="atkp-product-carousel-unit" id="atkp-product-carousel">
    <h2 class="atkp-pc-ad-header">Produkte von {{ ($shop== null ? '' : $shop->get_title())}}</h2>
    <!-- Title of the ad localized according to the marketplace picked from the AalbHeader tag-->
    <div class="atkp-pc-wrapper">
        <div class="atkp-pc-product-container">
            <ul class="atkp-pc-product-list">
                @foreach ($products as $product)
                    <li class="atkp-pc-product">
                        <div class="atkp-pc-product-image">
                            <div class="atkp-pc-product-image-wrapper">
                                <a href="{{$product->producturl}}" title="{{$product->title}}" target="_blank"
                                   rel="nofollow"> <!--Individual attributes are provided as variable tags as {{[[attribute]]}}. Check documentation for list of supported variable tags.-->
                                    <img src="{{$formatter->get_smallimageurl($product)}}"
                                         srcset="{{$formatter->get_mediumnimageurl($product)}}"
                                         alt="{{$formatter->get_title($product)}}"/>
                                @if($product->percentagesaved != '') <!-- The section tag ensures that percentage savings is displayed only if it is available -->
                                    <span class="atkp-pc-percent-off">
                          -{{$product->percentagesaved}}%
                        </span>
                                    @endif
                                </a>
                            </div>
                        </div>
                        <div class="atkp-pc-product-details">
                            <div class="atkp-pc-product-title">
                                <a href="{{$product->producturl}}" title="{{$product->title}}" target="_blank"
                                   rel="nofollow">
                                    {{$product->title}}
                                </a>
                            </div>
                            <div class="atkp-pc-product-offer-price">
                                <!-- The section tag for different marketplaces ensures localization of static text.  -->
                                {{$translator->get_pricedouble()}} <span
                                        class="atkp-pc-product-offer-price-value">{{$formatter->get_pricetext($product,$translator->get_val())}}</span>
                            </div>
                            @if($formatter->get_listpricetext($product, $translator->get_val()) != '')
                                <div class="atkp-pc-product-list-price">
                                    <!-- The section tag for different marketplaces ensures localization of static text.  -->
                                    {{$translator->get_insteadof()}} <span
                                            class="atkp-pc-product-list-price-value">{{$formatter->get_listpricetext($product,$translator->get_val())}}</span>
                                </div>
                            @endif


                            @if($product->isprime) <!-- The section tag ensures that prime icon is displayed only if it is available -->
                            <div class="atkp-pc-product-prime-icon">
                                {!! $formatter->get_primelogo($product) !!}
                            </div>
                            @endif
                        </div>
                    </li>

                @endforeach
            </ul>
        </div>
    </div>
    <a href="javascript:void(0);" class="atkp-pc-btn-prev">‹</a>
    <a href="javascript:void(0);" class="atkp-pc-btn-next">›</a>
</div>
@if(count($products) > 0 && atkp_options::$loader->get_show_disclaimer() && !$parameters->hidedisclaimer)
    <span class="atkp-disclaimer atkp-carousel-disclaimer">{!! $formatter->get_disclaimer($products[0]) !!}</span>
@endif


