<?php
/**
 * Created by PhpStorm.
 * User: Christof
 * Date: 01.12.2018
 * Time: 11:08
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_autoloader {
	private $classes;

	/* @var $loader atkp_autoloader */
	public static $loader = null;

	public function __construct() {
		spl_autoload_register( array( $this, 'load_class' ) );

		$this->classes = array();

		atkp_autoloader::$loader = $this;
	}

	public function register_classes() {
		$this->add_class( 'atkp_basics', '/includes/atkp_basics.php' );
		$this->add_class( 'atkp_widget', '/includes/widgets/atkp_widget.php' );
		$this->add_class( 'atkp_filterwidget', '/includes/widgets/atkp_filterwidget.php' );
		$this->add_class( 'atkp_settings', '/affiliate-toolkit-settings.php' );

		$this->add_class( 'ATKPSettings', '/includes/basics/ATKPSettings.php' );
		$this->add_class( 'ATKPLog', '/includes/basics/ATKPLog.php' );
		$this->add_class( 'ATKPHomeLinks', '/includes/basics/ATKPHomeLinks.php' );
		$this->add_class( 'ATKPTools', '/includes/basics/ATKPTools.php' );
		$this->add_class( 'atkp_options', '/includes/basics/atkp_options.php' );

		$this->add_class( 'atkp_settings', '/affiliate-toolkit-settings.php' );
		$this->add_class( 'atkp_welcome', '/affiliate-toolkit-welcome.php' );

		$this->add_class( 'atkp_settings_toolkit', '/includes/atkp_settings_toolkit.php' );
		$this->add_class( 'atkp_settings_advanced', '/includes/atkp_settings_advanced.php' );
		$this->add_class( 'atkp_settings_display', '/includes/atkp_settings_display.php' );
		$this->add_class( 'atkp_settings_customfield', '/includes/atkp_settings_customfield.php' );
		$this->add_class( 'atkp_settings_product', '/includes/atkp_settings_product.php' );
		$this->add_class( 'atkp_settings_license', '/includes/atkp_settings_license.php' );

		$this->add_class( 'ATKP_SL_Plugin_Updater', '/lib/ATKP_SL_Plugin_Updater.php' );

		$this->add_class( 'atkp_compatibility_asa1', '/includes/atkp_compatibility_asa1.php' );
		$this->add_class( 'atkp_compatibility_asa2', '/includes/atkp_compatibility_asa2.php' );
		$this->add_class( 'atkp_tools_importtemplate', '/includes/atkp_tools_importtemplate.php' );
		$this->add_class( 'atkp_tools_importlist', '/includes/atkp_tools_importlist.php' );
		$this->add_class( 'atkp_tools_importproduct', '/includes/atkp_tools_importproduct.php' );
		$this->add_class( 'atkp_tools_woo', '/includes/atkp_tools_woo.php' );
		$this->add_class( 'atkp_tools_debug', '/includes/atkp_tools_debug.php' );
		$this->add_class( 'atkp_tools_shortcodegenerator', '/includes/atkp_tools_shortcodegenerator.php' );

		$this->add_class( 'atkp_compatibility', '/affiliate-toolkit-compatibility.php' );
		$this->add_class( 'atkp_tools', '/affiliate-toolkit-tools.php' );

		$this->add_class( 'atkp_posttypes_shop', '/includes/atkp_posttypes_shop.php' );
		$this->add_class( 'atkp_posttypes_product', '/includes/atkp_posttypes_product.php' );
		$this->add_class( 'atkp_posttypes_list', '/includes/atkp_posttypes_list.php' );
		$this->add_class( 'atkp_posttypes_template', '/includes/atkp_posttypes_template.php' );
		$this->add_class( 'atkp_posttypes_fieldgroup', '/includes/atkp_posttypes_fieldgroup.php' );
		$this->add_class( 'atkp_shortcode_generator2', '/includes/atkp_shortcode_generator2.php' );
		$this->add_class( 'atkp_bulkimport', '/affiliate-toolkit-bulkimport.php' );
		$this->add_class( 'atkp_floatingbar', '/includes/atkp_floatingbar.php' );
		$this->add_class( 'atkp_posttypes_fieldgroup', '/includes/atkp_posttypes_fieldgroup.php' );
		$this->add_class( 'atkp_tools_woo', '/includes/atkp_tools_woo.php' );
		$this->add_class( 'atkp_shortcodes_product', '/includes/atkp_shortcodes_product.php' );
		$this->add_class( 'atkp_shortcodes_list', '/includes/atkp_shortcodes_list.php' );
		$this->add_class( 'atkp_shortcodes_livelist', '/includes/atkp_shortcodes_livelist.php' );
		$this->add_class( 'atkp_shortcodes_searchform', '/includes/atkp_shortcodes_searchform.php' );
		$this->add_class( 'atkp_shortcodes_asa1', '/includes/atkp_shortcodes_asa1.php' );
		$this->add_class( 'atkp_shortcodes_asa2', '/includes/atkp_shortcodes_asa2.php' );
		$this->add_class( 'atkp_external_featuredimage', '/includes/atkp_external_featuredimage.php' );
		$this->add_class( 'atkp_wp_cronjob', '/includes/atkp_wp_cronjob.php' );
		$this->add_class( 'atkp_endpoints', '/includes/atkp_endpoints.php' );

		$this->add_class( 'atkp_shop_provider_base', '/includes/shopproviders/atkp_shop_provider_base.php' );


		$this->add_class( 'atkp_shop', '/includes/atkp_shop.php' );
		$this->add_class( 'atkp_udfield', '/includes/atkp_udfield.php' );
		$this->add_class( 'atkp_control_helper', '/includes/helper/atkp_control_helper.php' );
		$this->add_class( 'atkp_udtaxonomy', '/includes/atkp_udtaxonomy.php' );
		$this->add_class( 'atkp_cronjob_new', '/includes/atkp_cronjob_new.php' );
		$this->add_class( 'atkp_asa1_helper', '/includes/helper/atkp_asa1_helper.php' );
		$this->add_class( 'atkp_asa2_helper', '/includes/helper/atkp_asa2_helper.php' );
		$this->add_class( 'atkp_template_helper', '/includes/helper/atkp_template_helper.php' );
		$this->add_class( 'atkp_product', '/includes/atkp_product.php' );
		$this->add_class( 'atkp_list', '/includes/atkp_list.php' );
		$this->add_class( 'atkp_shop_provider_csv', '/includes/shopproviders/atkp_shop_provider_csv.php' );
		$this->add_class( 'atkp_external_featuredimage', '/includes/atkp_external_featuredimage.php' );
		$this->add_class( 'atkp_export_base', '/includes/exportproviders/atkp_export_base.php' );
		$this->add_class( 'atkp_list_resp', '/includes/atkp_list_resp.php' );
		$this->add_class( 'atkp_search_resp', '/includes/atkp_search_resp.php' );
		$this->add_class( 'atkp_offertable_helper', '/includes/helper/atkp_offertable_helper.php' );
		$this->add_class( 'atkp_pricehistorytable_helper', '/includes/helper/atkp_pricehistorytable_helper.php' );
		$this->add_class( 'atkp_global_tools', '/includes/helper/atkp_global_tools.php' );
		$this->add_class( 'atkp_response', '/includes/atkp_response_item.php' );
		$this->add_class( 'atkp_response_item', '/includes/atkp_response_item.php' );
		$this->add_class( 'atkp_listservice', '/includes/dataservices/atkp_listservice.php' );
		$this->add_class( 'atkp_productservice', '/includes/dataservices/atkp_productservice.php' );
		$this->add_class( 'atkp_product_offer', '/includes/atkp_product_offer.php' );
		$this->add_class( 'atkp_offerservice', '/includes/dataservices/atkp_offerservice.php' );
		$this->add_class( 'atkp_template', '/includes/atkp_template.php' );
		$this->add_class( 'atkp_filter_helper', '/includes/helper/atkp_filter_helper.php' );
		$this->add_class( 'atkp_output', '/includes/atkp_output.php' );
		$this->add_class( 'atkp_product_image', '/includes/atkp_product_image.php' );
		$this->add_class( 'atkp_product_offer', '/includes/atkp_product_offer.php' );
		$this->add_class( 'atkp_product_pricehistory', '/includes/atkp_product_pricehistory.php' );
		$this->add_class( 'atkp_searchform_helper', '/includes/helper/atkp_searchform_helper.php' );
		$this->add_class( 'atkp_url_scraper', '/includes/helper/atkp_url_scraper.php' );
		$this->add_class( 'atkp_template_comparevalue', '/includes/atkp_template_comparevalue.php' );
		$this->add_class( 'atkp_shortcode_generator2', '/includes/atkp_shortcode_generator2.php' );
		$this->add_class( 'atkp_shortener', '/tools/atkp_shortener.php' );
		$this->add_class( 'atkp_default_template_base', '/includes/atkp_default_template_base.php' );
		$this->add_class( 'atkp_template_comparegroup', '/includes/atkp_template_comparegroup.php' );

		$this->add_class( 'atkp_export_provider_base', '/includes/exportproviders/atkp_export_base.php' );
		$this->add_class( 'atkp_export_provider_woo', '/includes/exportproviders/atkp_export_woo.php' );


		$this->add_class( 'atkp_formatter', '/includes/helper/atkp_formatter.php' );

		$this->add_class( 'atkp_translator', '/includes/helper/atkp_translator.php' );

		$this->add_class( 'atkp_template_parameters', '/includes/helper/atkp_template_parameters.php' );
		$this->add_class( 'atkp_gutenberg_editor', '/includes/atkp_gutenberg_editor.php' );


	}


	public function add_class( $class_name, $file ) {
		$this->classes[ $class_name ] = $file;
	}

	public function load_class( $class_name ) {
		if ( $class_name == '' || ! in_array( substr( $class_name, 0, 4 ), array( 'atkp', 'ATKP' ) ) ) {
			return;
		}

		if ( ! isset( $this->classes[ $class_name ] ) ) {
			throw new Exception( "class not found: " . $class_name );
		}

		$file = ATKP_PLUGIN_DIR . $this->classes[ $class_name ];

		if ( file_exists( $file ) ) {
			require_once( $file );
		}
		/*
			  if(class_exists ($class_name))
				  return new $class_name();

			  return null; */
	}
}