<?php
/**
 * Created by PhpStorm.
 * User: Christof
 * Date: 18.12.2018
 * Time: 22:05
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class atkp_formatter {

	/** @var atkp_template_helper $templatehelper */
	private $templatehelper;
	/** @var atkp_template_parameters $parameters */
	private $parameters;

	public function __construct( $templatehelper, $parameters ) {
		$this->templatehelper = $templatehelper;
		$this->parameters     = $parameters;

		//produkt alle properties laden
		//alle benutzerdefinierten felder laden
		//cache berücksichtigen?
		//shop objekt
		//angebote array einfügen
		//bildergalerie array einfügen
		//acf felder einfügen

		//formatter hält die funktionen wie shorttitel etc
	}

	public function get_mark() {
		if ( atkp_options::$loader->get_mark_links() == 1 ) {
			return atkp_options::$loader->get_affiliatechar();
		} else {
			return '';
		}
	}

	public function get_listtitle( atkp_product $myproduct ) {
		if ( $myproduct->listid == '' ) {
			return '';
		}

		$list = get_post( $myproduct->listid );
		if ( isset( $list ) ) {
			return $list->post_title;
		} else {
			return '';
		}
	}

	public function get_postlist( atkp_product $myproduct ) {

		if ( $myproduct->postids == '' ) {
			return '';
		}

		$post_list = '<ul class="atkp_postlist">';
		if ( is_array( $myproduct->postids ) ) {
			foreach ( $myproduct->postids as $p ) {
				$title = get_the_title( $p );
				if ( ! isset( $title ) || $title == '' ) {
					$title = __( 'Post', ATKP_PLUGIN_PREFIX );
				}

				$post_list .= sprintf( __( '<li><a href="%s">%s</a></li>', ATKP_PLUGIN_PREFIX ), get_permalink( $p ), $title );
			}
		} else {
			$title = get_the_title( $myproduct->postids );
			if ( ! isset( $title ) || $title == '' ) {
				$title = __( 'Post', ATKP_PLUGIN_PREFIX );
			}

			$post_list .= sprintf( __( '<li><a href="%s">%s</a></li>', ATKP_PLUGIN_PREFIX ), get_permalink( $myproduct->postids ), $title );
		}
		$post_list .= '</ul>';

		return $post_list;
	}

	public function get_predicate_id( atkp_product $myproduct ) {
		if ( $myproduct->predicate != '' && $myproduct->predicate != 0 ) {
			return $myproduct->predicate;
		}

		return '';
	}

	public function get_predicate_text( atkp_product $myproduct ) {
		if ( $myproduct->predicate != '' && $myproduct->predicate != 0 ) {
			return get_option( ATKP_PLUGIN_PREFIX . '_predicate' . $myproduct->predicate . '_text' );
		}

		return '';
	}

	public function get_predicate_color( atkp_product $myproduct ) {
		if ( $myproduct->predicate != '' && $myproduct->predicate != 0 ) {
			return get_option( ATKP_PLUGIN_PREFIX . '_predicate' . $myproduct->predicate . '_color' );
		}

		return '';
	}

	public function get_predicate_borderstyle( atkp_product $myproduct ) {
		if ( $myproduct->predicate != '' && $myproduct->predicate != 0 ) {
			return 'border-color:' . $this->get_predicate_color( $myproduct );
		}

		return '';
	}

	public function get_proslist( atkp_product $myproduct ) {
		if ( $myproduct->pro == '' ) {
			return '';
		}

		$str = '<ul class="atkp-pro">';
		foreach ( explode( "\n", $myproduct->pro ) as $mypro ) {
			$str = $str . '<li>' . $mypro . '</li>';
		}
		$str = $str . '</ul>';

		return $str;
	}

	public function get_contralist( atkp_product $myproduct ) {
		if ( $myproduct->contra == '' ) {
			return '';
		}

		$str = '<ul class="atkp-contra">';
		foreach ( explode( "\n", $myproduct->contra ) as $mycontra ) {
			$str = $str . '<li>' . $mycontra . '</li>';
		}
		$str = $str . '</ul>';

		return $str;
	}

	public function get_testresult( atkp_product $myproduct ) {
		if ( $myproduct->testresult == '' || $myproduct->testresult == 0 ) {
			return;
		}

		$testresult = esc_attr( get_option( ATKP_PLUGIN_PREFIX . '_test_score' . $myproduct->testresult . '_text' ) );
		$testrating = $myproduct->testrating;
		$testdate   = $myproduct->testdate;

		return $this->get_testresult_raw($testresult, $testrating, $testdate);
	}

	public function get_testresult_raw($testresult, $testrating, $testdate) {
		$testcolor   = get_option( ATKP_PLUGIN_PREFIX . '_review_color', '#9f9f9f' );
		$testcaption = esc_attr( get_option( ATKP_PLUGIN_PREFIX . '_review_text', __( 'Review', ATKP_PLUGIN_PREFIX ) ) );

		return '<div class="atkp-testbadge" style="border-color:' . $testcolor . '"><span class="atkp-testtitle" style="background-color:' . $testcolor . '">' . $testcaption . '</span><span class="atkp-testnote" style="color:' . $testcolor . '">' . $testrating . '</span><span class="atkp-testtext">' . $testresult . '</span><span class="atkp-testdate">' . $testdate . '</span></div>';

	}


	public function get_featuretext( atkp_product $myproduct ) {
		return wpautop( $myproduct->features );
	}

	public function get_descriptiontext( atkp_product $myproduct ) {
		return wpautop( $myproduct->description );
	}

	public function get_featuretext_short( atkp_product $myproduct ) {
		if ( $myproduct->outputashtml ) {
			return wpautop( $myproduct->features );
		} else {
			$featurecount = ATKPSettings::$feature_count == '0' || ATKPSettings::$feature_count == '' ? 10 : ATKPSettings::$feature_count;

			if ( $myproduct->features == '' ) {
				$featureRows = array();
			} else {
				$featureRows = explode( '<li>', $myproduct->features );
				$featureRows = array_map( 'strip_tags', $featureRows );
			}


			$featureclean = '';
			$cnt          = 0;
			foreach ( $featureRows as $featureRow ) {
				if ( trim( $featureRow ) == '' ) {
					continue;
				}

				$featureclean .= '<li>' . $featureRow . '</li>';
				$cnt ++;

				if ( $cnt >= $featurecount ) {
					break;
				}
			}

			if ( count( $featureRows ) <= 1 ) {
				$featureclean = strip_tags( $myproduct->features );
			}

			if ( $featureclean != '' ) {
				$featureclean = '<ul>' . $featureclean . '</ul>';
			}

			return wpautop( $featureclean );
		}
	}

	public function get_descriptiontext_short( atkp_product $myproduct ) {
		if ( $myproduct->outputashtml ) {
			return wpautop( $myproduct->description );
		} else {
			$desclength = ATKPSettings::$description_length == '0' || ATKPSettings::$description_length == '' ? 400 : ATKPSettings::$description_length;

			$descclean = strip_tags( $myproduct->description );
			$descclean = ( strlen( $descclean ) > $desclength ) ? substr( $descclean, 0, $desclength ) . '...' : $descclean;

			return wpautop( $descclean );
		}
	}

	public function get_infotext( atkp_product $myproduct ) {
		$info_text = '';

		switch ( ATKPSettings::$boxcontent ) {
			default:
			case '1':

				if ( $myproduct->features == '' ) {
					$info_text = $this->get_descriptiontext_short( $myproduct );
				} else {
					$info_text = $this->get_featuretext_short( $myproduct );
				}

				break;
			case '2':
				$info_text = $this->get_featuretext_short( $myproduct );
				break;
			case '3':
				$info_text = $this->get_descriptiontext_short( $myproduct );
				break;

		}

		return $info_text;
	}

	public function get_listurl() {
		if ( $this->parameters->listid == '' ) {
			return '';
		}

		$listurl = ATKPTools::get_post_setting( $this->parameters->listid, ATKP_LIST_POSTTYPE . '_listurl' );

		return $listurl;
	}

	private static function get_link_rel() {
		$disablesponsored = atkp_options::$loader->get_disable_sponsored_attribute();

		if($disablesponsored)
			return 'nofollow noopener';
		else
			return 'sponsored nofollow noopener';
	}

	public function get_listlink() {
		if ( ATKPSettings::$open_window ) {
			$target = 'target="_blank"';
		} else {
			$target = '';
		}

		return 'href="' . $this->get_listurl() . '" rel="'.self::get_link_rel().'" ' . $target . ' title="' . __( 'Show me more products', ATKP_PLUGIN_PREFIX ) . '"';
	}

	public function get_link_mark() {
		$linkmark = '';
		if ( atkp_options::$loader->get_mark_links() == 1 ) {
			$linkmark = atkp_options::$loader->get_affiliatechar();
		}

		return $linkmark;
	}

	public function get_button_mark( atkp_product $myproduct ) {
		$buttontype = $this->get_button_type( $myproduct );

		$linkmark = $this->get_link_mark();

		switch ( $buttontype ) {
			case 'product':
			case 'woocommerce':
				$linkmark = '';
				break;
		}

		return $linkmark;
	}

	public function get_button_type( atkp_product $myproduct ) {
		$buttontype = get_option( ATKP_PLUGIN_PREFIX . '_add_to_cart', 'link' );

		if ( $this->parameters->addtocart != '' ) {
			$buttontype = $this->parameters->addtocart;
		}

		//fallback falls cartlink leer ist
		if ( $buttontype == 'addtocart' && $this->get_addtocarturl( $myproduct ) == '' ) {
			$buttontype = 'link';
		}

		//falls die produktseiten nicht aktiv sind, fallback auf produktlink
		if ( $buttontype == 'product' && $this->get_detailurl( $myproduct ) == '' ) {
			$buttontype = 'link';
		}

		if ( $buttontype == 'woocommerce' && $this->get_woocommerceurl( $myproduct ) == '' ) {
			$buttontype = 'link';
		}

		return $buttontype;
	}

	public function get_button_text( atkp_product $myproduct ) {
		$buttontype = $this->get_button_type( $myproduct );
		$linktext   = '';

		switch ( $buttontype ) {
			case '1':
			case 'addtocart':

				if ( $myproduct->shop == null ) {
					$linktext = __( 'Add to cart', ATKP_PLUGIN_PREFIX );
				} else {

					$linktext = $myproduct->shop->get_addtocart() != '' ? $myproduct->shop->get_addtocart() : __( 'Add to Amazon Cart', ATKP_PLUGIN_PREFIX );
				}

				break;
			default:
			case 'link':
				if ( $myproduct->shop == null ) {
					$linktext = __( 'Buy now', ATKP_PLUGIN_PREFIX );
				} else {

					$linktext = $myproduct->shop->get_buyat() != '' ? $myproduct->shop->get_buyat() : __( 'Buy now at Amazon', ATKP_PLUGIN_PREFIX );
				}

				break;
			case 'product':
				$linktext = $this->get_detailtext();
				break;
			case 'woocommerce':
				$linktext = $this->get_woocommercetitle( $myproduct );
				break;

		}

		return $linktext;
	}

	public function get_button_link( atkp_product $myproduct ) {
		$buttontype = $this->get_button_type( $myproduct );
		$link       = '';

		switch ( $buttontype ) {
			case '1':
			case 'addtocart':
				$link = $this->get_cartlink( $myproduct );
				break;
			default:
			case 'link':
				$link = $this->get_productlink( $myproduct );
				break;
			case 'product':
				$link = $this->get_detaillink( $myproduct );
				break;
			case 'woocommerce':
				$link = $this->get_woocommercelink( $myproduct );
				break;
		}

		return $link;
	}


	public function get_title_type( atkp_product $myproduct ) {
		$titletype = get_option( ATKP_PLUGIN_PREFIX . '_title_link_type', 'link' );

		if ( $titletype == 'product' && $this->get_detailurl( $myproduct ) == '' ) {
			$titletype = 'link';
		}

		if ( $titletype == 'woocommerce' && $this->get_woocommerceurl( $myproduct ) == '' ) {
			$titletype = 'link';
		}

		return $titletype;
	}

	public function get_title_mark( atkp_product $myproduct ) {
		$titletype = $this->get_title_type( $myproduct );

		$linkmark = $this->get_link_mark();

		switch ( $titletype ) {
			case 'product':
			case 'woocommerce':
				$linkmark = '';
				break;
		}

		return $linkmark;
	}

	public function get_title_link( atkp_product $myproduct ) {
		$titlelink = $this->get_title_type( $myproduct );
		$link      = '';

		switch ( $titlelink ) {
			default:
			case 'link':
				$link = $this->get_productlink( $myproduct );
				break;
			case 'product':
				$link = $this->get_detaillink( $myproduct );
				break;
			case 'woocommerce':
				$link = $this->get_woocommercelink( $myproduct );
				break;
		}

		return $link;
	}

	public function get_title( atkp_product $myproduct ) {
		$titletype = $this->get_title_type( $myproduct );
		$linktext  = '';

		switch ( $titletype ) {
			default:
				$linktext = $myproduct->title;
				break;
			case 'woocommerce':
				$linktext = $this->get_woocommercetitle( $myproduct );
				break;

		}

		return $linktext;
	}

	public function get_primelogo( atkp_product $myproduct ) {

		if ( ! $myproduct->isprime ) {
			return '';
		}

		$primelogo = '<img src="' . plugins_url( 'images/prime_amazon.png', ATKP_PLUGIN_FILE ) . '" alt="' . __( 'Prime', ATKP_PLUGIN_PREFIX ) . '"/>';

		if ( ATKPSettings::$linkprime ) {
			$redirtype = ATKPTools::get_post_setting( $myproduct->shopid, ATKP_SHOP_POSTTYPE . '_redirectiontype' );
			$apikey    = ATKPTools::get_post_setting( $myproduct->shopid, ATKP_SHOP_POSTTYPE . '_apikey' );

			$amzCountry = ATKPTools::get_post_setting( $myproduct->shop->settingid, ATKP_SHOP_POSTTYPE . '_access_website' );
			$amzTag     = ATKPTools::get_post_setting( $myproduct->shop->settingid, ATKP_SHOP_POSTTYPE . '_access_tracking_id' );

			$primelink = self::replace_external_url( $myproduct->shopid, 'https://www.amazon.' . $amzCountry . '/gp/prime/?primeCampaignId=prime_assoc_ft&tag=' . $amzTag . '&camp=4510&creative=670002&linkCode=ur1&adid=07VBBZ76N7ZKENHMQCDR' );

			/*
			switch ( $redirtype ) {
					default:
							//disabled
							break;
					case 3:
					case 4:
					case 5:
					case 6:
							$shortener = new atkp_shortener();
							$primelink = $shortener->shorten_url( $apikey, '', $redirtype, $primelink );
							break;
			}
			*/

			$primelogo = '<a href="' . $primelink . '" rel="'.self::get_link_rel().'" target="_blank" title="' . __( 'More about prime', ATKP_PLUGIN_PREFIX ) . '">' . $primelogo . '</a>';
		}

		return $primelogo;
	}

	public function get_producturl( atkp_product $myproduct ) {
		return self::replace_external_url( $myproduct->shopid, self::replace_tracking_code( $myproduct->shopid, $myproduct->producturl, $this->parameters->trackingid ) );
	}

	public function get_addtocarturl( atkp_product $myproduct ) {
		return self::replace_external_url( $myproduct->shopid, self::replace_tracking_code( $myproduct->shopid, $myproduct->addtocarturl, $this->parameters->trackingid ) );
	}

	public function get_customerreviewsurl( atkp_product $myproduct ) {
		return self::replace_external_url( $myproduct->shopid, self::replace_tracking_code( $myproduct->shopid, $myproduct->customerreviewurl, $this->parameters->trackingid ) );
	}

	public function get_productlink( atkp_product $myproduct ) {

		$linkttitle = $myproduct->title;

		if ( $myproduct->shop != null ) {
			$linkttitle = $myproduct->shop->get_tooltip();
		}

		return $this->create_external_link( $myproduct->producturl, $linkttitle, $myproduct->title, $this->parameters->listid, $this->parameters->templateid, $myproduct->shopid, atkp_LinkType::Link, $this->parameters->trackingid );
	}

	public function get_cartlink( atkp_product $myproduct ) {

		if ( $myproduct->addtocarturl == '' ) {
			return $this->get_productlink( $myproduct );
		}

		$linkttitle = $myproduct->title;

		if ( $myproduct->shop != null ) {
			$linkttitle = $myproduct->shop->get_tooltip();
		}

		return $this->create_external_link( $myproduct->addtocarturl, $linkttitle, $myproduct->title, $this->parameters->listid, $this->parameters->templateid, $myproduct->shopid, atkp_LinkType::Cart, $this->parameters->trackingid );
	}

	public function get_percentagesaved( atkp_product $myproduct, $format = '-%s%%' ) {

		if ( $myproduct->percentagesaved == '' || $myproduct->percentagesaved == 0 ) {
			return '';
		} else {
			return sprintf( $format, $myproduct->percentagesaved );
		}
	}

	public function get_savetext( atkp_product $myproduct, $format = '%s' ) {
		if ( $myproduct->amountsaved == '' ) {
			return '';
		} else {
			return sprintf( $format, $this->formatFloat( $myproduct->amountsavedfloat, $myproduct->amountsaved, $myproduct->shopid ) );
		}
	}

	public function get_total( atkp_product $myproduct, $format = '%s', $emptytext = '' ) {

		if ( $myproduct == null || $myproduct->salepricefloat == 0 ) {
			return $emptytext;
		} else {
			$shipping = $myproduct->shippingfloat;
			$price    = $myproduct->salepricefloat;

			if ( $shipping < 0 || $shipping > 100 ) {
				$shipping = 0;
			}
			if ( $price < 0 || $price > 100000 ) {
				$price = 0;
			}

			return sprintf( $format, $this->formatFloat( $shipping + $price, $myproduct->saleprice, $myproduct->shopid ) );
		}
	}

	public function get_shipping( atkp_product $myproduct, $format = '%s', $emptytext = '' ) {

		if ( $myproduct->shipping == '' || $myproduct->shippingfloat == 0 ) {
			return $emptytext;
		} else {
			return sprintf( $format, $this->formatFloat( $myproduct->shippingfloat, $myproduct->shipping, $myproduct->shopid ) );
		}
	}


	public function get_pricetext( atkp_product $myproduct, $format = '%s', $emptytext = '' ) {

		if ( $myproduct->saleprice == '' || $myproduct->salepricefloat == 0 ) {
			return $emptytext;
		} else {
			return sprintf( $format, $this->formatFloat( $myproduct->salepricefloat, $myproduct->saleprice, $myproduct->shopid ) );
		}
	}

	public function get_listpricetext( atkp_product $myproduct, $format = '%s', $emptytext = '' ) {

		if ( $myproduct->listprice == '' || $myproduct->listpricefloat == 0 || $myproduct->listpricefloat <= $myproduct->salepricefloat ) {
			return $emptytext;
		} else {
			return sprintf( $format, $this->formatFloat( $myproduct->listpricefloat, $myproduct->listprice, $myproduct->shopid ) );
		}
	}

	public function get_priceinfotext() {
		return __( 'Price incl. VAT., Excl. Shipping', ATKP_PLUGIN_PREFIX );
	}

	public function get_wp_review_rating( atkp_product $myproduct ) {
		if ( function_exists( 'wp_review_show_total' ) ) {
			return wp_review_show_total( false, 'atkp-totalrating', $myproduct->productid );
		}

		return '';
	}

	public function get_displayfield( atkp_product $myproduct, $fieldname ) {
		if ( ! isset( $myproduct->displayfields[ $fieldname ] ) ) {
			return '';
		}

		$fieldmeta  = $myproduct->displayfields[ $fieldname ];
		$fieldvalue = '';

		if ( is_a( $fieldmeta, 'atkp_udtaxonomy' ) ) {
			$taxonomy = $fieldmeta;

			$product_terms = wp_get_object_terms( $myproduct->productid, $taxonomy->name );
			if ( isset( $product_terms ) && ! is_wp_error( $product_terms ) ) {
				foreach ( $product_terms as $term ) {
					if ( get_option( ATKP_PLUGIN_PREFIX . '_product_enabled', false ) == true ) {
						$fieldvalue .= ( $fieldvalue == '' ? '' : ', ' ) . '<a href="' . get_term_link( $term->slug, $taxonomy->name ) . '">' . esc_html( $term->name ) . '</a>';
					} else {
						$fieldvalue .= ( $fieldvalue == '' ? '' : ', ' ) . esc_html( $term->name );
					}
				}

			}

		} else if ( is_a( $fieldmeta, 'atkp_udfield' ) ) {
			$field = $fieldmeta;

			$fieldvalue = $this->generate_customplaceholder( $myproduct, $field, $field->isnewfield );

		} else {
			$fieldvalue = $fieldmeta;
		}//throw new \Exception('unknown fieldmeta: '.$fieldmeta);

		return $fieldvalue;
	}

	private function generate_customplaceholder( $myproduct, $newfield, $isnewfield ) {

		$text_no  = get_option( ATKP_PLUGIN_PREFIX . '_text_no', '' );
		$text_yes = get_option( ATKP_PLUGIN_PREFIX . '_text_yes', '' );

		$result = '';

		if ( $isnewfield ) {
			$result = $myproduct->get_metavalue( ATKP_PRODUCT_POSTTYPE . '_cf_' . $newfield->name );
		} else {
			$result = $myproduct->get_metavalue( ATKP_PRODUCT_POSTTYPE . '_customfield_' . $newfield->name );
		}

		switch ( $newfield->type ) {
			case 4:

				//yesno
				if ( $newfield->format == 'text' ) {
					if ( $result == '1' ) {
						$result = __( 'Yes', ATKP_PLUGIN_PREFIX );
					} else if ( $result == '0' ) {
						$result = __( 'No', ATKP_PLUGIN_PREFIX );
					} else {
						$result = '';
					}
				} else {
					if ( $result == '1' ) {
						if ( $text_yes != '' ) {
							$result = $text_yes;
						} else {
							$result = '<img src="' . plugins_url( 'images/yes.png', ATKP_PLUGIN_FILE ) . '" style="width: 16px;" alt="' . __( 'Yes', ATKP_PLUGIN_PREFIX ) . '"/>';
						}
					} else if ( $result == '0' ) {
						if ( $text_no != '' ) {
							$result = $text_no;
						} else {
							$result = '<img src="' . plugins_url( 'images/no.png', ATKP_PLUGIN_FILE ) . '" style="width: 16px;" alt="' . __( 'No', ATKP_PLUGIN_PREFIX ) . '"/>';
						}
					} else {
						$result = '';
					}
				}
				break;

			case 1:
				//textfield
				if ( $newfield->format == 'stars' ) {
					$val = $result == '' || $result == 0 ? floatval( $newfield->values ) : floatval( $result );

					$class = 'atkp-star-' . number_format( $this->roundRate( $val ), 1, ' atkp-star-0', '' );
					$title = sprintf( __( '%s of 5 stars', ATKP_PLUGIN_PREFIX ), $val );

					$tempstr = '<span class="atkp-star-compare atkp-star ' . $class . '" title="' . $title . '"></span>';

					$tempstr = apply_filters( 'atkp_stars_formatvalue', $tempstr, $val, $class, $title );

					return $tempstr;
				}

				break;
			case 5:
				//htmlfield
				//$result = str_replace("\r", '<br />', $result);
				$result = wpautop( $result );
				break;

		}

		if ( $result != '' ) {
			if ( $newfield->prefix != '' ) {
				$result = $newfield->prefix . ' ' . $result;
			}
			if ( $newfield->suffix != '' ) {
				$result = $result . ' ' . $newfield->suffix;
			}
		}

		return $result;
	}

	public function get_refreshdate( atkp_product $myproduct ) {
		return ATKPTools::get_formatted_date( $myproduct->updatedon );
	}

	public function get_refreshtime( atkp_product $myproduct ) {
		return ATKPTools::get_formatted_time( $myproduct->updatedon );
	}

	public function get_disclaimer( atkp_product $myproduct ) {
		return str_replace( '%refresh_time%', $this->get_refreshtime( $myproduct ), str_replace( '%refresh_date%', $this->get_refreshdate( $myproduct ), ATKPSettings::$access_disclaimer_text ) );
	}

	public function get_shop_logourl( atkp_shop $myshop = null ) {
		if ( $myshop == null ) {
			return '';
		}

		if ( $myshop->get_logourl() == '' ) {
			return $myshop->get_title();
		} else {
			return $myshop->get_logourl();
		}
	}

	public function get_shop_smalllogourl( atkp_shop $myshop = null ) {
		if ( $myshop == null ) {
			return '';
		}

		if ( $myshop->get_smalllogourl() == '' ) {
			return $myshop->get_title();
		} else {
			return $myshop->get_smalllogourl();
		}
	}

	public function get_shop_logo( atkp_shop $myshop = null ) {
		if ( $myshop == null ) {
			return '';
		}

		if ( $myshop->get_logourl() == '' ) {
			return $myshop->get_title();
		} else {
			return '<img src="' . $myshop->get_logourl() . '" alt="' . $myshop->get_title() . '" />';
		}
	}

	public function get_shop_smalllogo( atkp_shop $myshop = null ) {
		if ( $myshop == null ) {
			return '';
		}

		if ( $myshop->get_smalllogourl() == '' ) {
			return $myshop->get_title();
		} else {
			return '<img src="' . $myshop->get_smalllogourl() . '" alt="' . $myshop->get_title() . '" />';
		}
	}

	public function get_shop_title( atkp_shop $myshop = null ) {
		if ( $myshop == null ) {
			return '';
		}

		return $myshop->get_title();
	}

	public function get_list_title( atkp_list $mylist = null ) {
		if ( $mylist == null ) {
			return '';
		}

		return $mylist->title;
	}

	public function get_list_displayfields( atkp_list $mylist = null ) {
		if ( $mylist == null ) {
			return '';
		}

		$array = array();

		if ( atkp_options::$loader->get_acfenabled() ) {
			$acffields = get_fields( $mylist->listid );

			if ( $acffields ) {
				foreach ( $acffields as $name => $value ) {
					$array[ 'acf_list_' . $name ] = (string) $value;
				}
			}
		}

		return $array;
	}

	public function get_shop_displayfields( atkp_shop $myshop = null ) {
		if ( $myshop == null ) {
			return '';
		}

		$array = array();

		$array['shopcustomfield1'] = $myshop->customfield1;
		$array['shopcustomfield2'] = $myshop->customfield2;
		$array['shopcustomfield3'] = $myshop->customfield3;

		if ( atkp_options::$loader->get_acfenabled() ) {
			$acffields = get_fields( $myshop->id );

			if ( $acffields ) {
				foreach ( $acffields as $name => $value ) {
					$array[ 'acf_shop_' . $name ] = (string) $value;
				}
			}
		}

		return $array;
	}

	public function get_offer_linktext() {
		return __( 'Buy now', ATKP_PLUGIN_PREFIX );
	}

	public function get_offerproducturl( atkp_product_offer $myoffer ) {
		return self::replace_external_url( $myoffer->shopid, $myoffer->link );
	}

	public function get_offer_productlink( atkp_product_offer $myoffer ) {

		$shop       = $myoffer->shopid == '' ? null : atkp_shop::load( $myoffer->shopid, true );
		$linkttitle = $myoffer->title;

		if ( $shop != null ) {
			$linkttitle = $shop->get_tooltip();
		}

		return $this->create_external_link( $myoffer->link, $linkttitle, $myoffer->title, $this->parameters->listid, $this->parameters->templateid, $myoffer->shopid, atkp_LinkType::Offer );
	}

	public function get_offer_price( atkp_product_offer $myoffer, $format = '%s', $emptytext = '' ) {

		if ( $myoffer == null || $myoffer->price == '' ) {
			return $emptytext;
		} else {
			return sprintf( $format, $this->formatFloat( $myoffer->pricefloat, $myoffer->price, $myoffer->shopid ) );
		}
	}

	public function get_offer_total( atkp_product_offer $myoffer, $format = '%s', $emptytext = '' ) {

		if ( $myoffer == null || $myoffer->pricefloat == 0 ) {
			return $emptytext;
		} else {
			$shipping = $myoffer->shippingfloat;
			$price    = $myoffer->pricefloat;

			if ( $shipping < 0 || $shipping > 100 ) {
				$shipping = 0;
			}
			if ( $price < 0 || $price > 100000 ) {
				$price = 0;
			}

			return sprintf( $format, $this->formatFloat( $shipping + $price, $myoffer->price, $myoffer->shopid ) );
		}
	}

	public function get_offer_shipping( atkp_product_offer $myoffer, $format = '%s', $emptytext = '' ) {

		if ( $myoffer == null || $myoffer->shippingfloat == 0 ) {
			return $emptytext;
		} else {
			return sprintf( $format, $this->formatFloat( $myoffer->shippingfloat, $myoffer->shipping, $myoffer->shopid ) );
		}
	}

	public function get_offer_availability( atkp_product_offer $myoffer, $format = 'Availability: %s' ) {
		if($format == 'Availability: %s')
			$formattxt = __( 'Availability: %s', ATKP_PLUGIN_PREFIX );
		else
			$formattxt = $format;

		if ( $myoffer->availability == '' ) {
			return sprintf( $formattxt, 'N/A' );
		} else {
			return sprintf( $formattxt, $myoffer->availability );
		}
	}

	public function get_offer_bestprice( atkp_product_offer $myoffer, atkp_product $myproduct ) {
		$minoffer = $this->get_minoffer( $myproduct, true );

		if ( $minoffer != null && $minoffer->id == $myoffer->id ) {
			return __( 'Best price', ATKP_PLUGIN_PREFIX );
		} else {
			return '';
		}
	}

	public function get_offer_url( atkp_product_offer $myoffer ) {
		return $myoffer == null ? '' : self::replace_external_url( $myoffer->shopid, $myoffer->link );
	}


	public function get_image_smallimageurl( atkp_product $myproduct, atkp_product_image $myimage ) {

		if ( $myimage->smallimageurl == '' ) {
			return plugins_url( __( '../../images/image-not-found.jpg', ATKP_PLUGIN_PREFIX ), __FILE__ );
		}

		return self::replace_image_url( $myproduct->shopid, $myimage->smallimageurl );
	}

	public function get_image_mediumimageurl( atkp_product $myproduct, atkp_product_image $myimage ) {

		if ( $myimage->mediumimageurl == '' ) {
			return plugins_url( __( '../../images/image-not-found.jpg', ATKP_PLUGIN_PREFIX ), __FILE__ );
		}

		return self::replace_image_url( $myproduct->shopid, $myimage->mediumimageurl );
	}

	public function get_image_largeimageurl( atkp_product $myproduct, atkp_product_image $myimage ) {

		if ( $myimage->largeimageurl == '' ) {
			return plugins_url( __( '../../images/image-not-found.jpg', ATKP_PLUGIN_PREFIX ), __FILE__ );
		}

		return self::replace_image_url( $myproduct->shopid, $myimage->largeimageurl );
	}

	public function get_image_smallimage( atkp_product $myproduct, atkp_product_image $myimage ) {
		return '<img src="' . $this->get_image_smallimageurl( $myproduct, $myimage ) . '" alt="' . esc_attr( $myproduct->title ) . '" />';
	}

	public function get_image_mediumimage( atkp_product $myproduct, atkp_product_image $myimage ) {
		return '<img src="' . $this->get_image_mediumimageurl( $myproduct, $myimage ) . '" alt="' . esc_attr( $myproduct->title ) . '" />';
	}

	public function get_image_largeimage( atkp_product $myproduct, atkp_product_image $myimage ) {
		return '<img src="' . $this->get_image_largeimageurl( $myproduct, $myimage ) . '" alt="' . esc_attr( $myproduct->title ) . '" />';
	}


	public function get_smallimageurl( atkp_product $myproduct ) {

		$smallimageurl = atkp_product::get_mainimage( $myproduct, 'smalltolarge' );

		if ( $smallimageurl == '' ) {
			return plugins_url( __( '../../images/image-not-found.jpg', ATKP_PLUGIN_PREFIX ), __FILE__ );
		}

		return self::replace_image_url( $myproduct->shopid, $smallimageurl, $myproduct->productid, 'small' );
	}

	public function get_mediumnimageurl( atkp_product $myproduct ) {

		$smallimageurl = atkp_product::get_mainimage( $myproduct, 'mediumtolarge' );

		if ( $smallimageurl == '' ) {
			return plugins_url( __( '../../images/image-not-found.jpg', ATKP_PLUGIN_PREFIX ), __FILE__ );
		}

		return self::replace_image_url( $myproduct->shopid, $smallimageurl, $myproduct->productid, 'medium' );
	}

	public function get_largeimageurl( atkp_product $myproduct ) {

		$smallimageurl = atkp_product::get_mainimage( $myproduct, 'largetosmall' );

		if ( $smallimageurl == '' ) {
			return plugins_url( __( '../../images/image-not-found.jpg', ATKP_PLUGIN_PREFIX ), __FILE__ );
		}

		return self::replace_image_url( $myproduct->shopid, $smallimageurl, $myproduct->productid, 'large' );
	}

	public function get_smallimage( atkp_product $myproduct ) {
		return '<img src="' . $this->get_smallimageurl( $myproduct ) . '" alt="' . esc_attr( $myproduct->title ) . '" />';
	}

	public function get_mediumnimage( atkp_product $myproduct ) {
		return '<img src="' . $this->get_mediumnimageurl( $myproduct ) . '" alt="' . esc_attr( $myproduct->title ) . '" />';
	}

	public function get_largeimage( atkp_product $myproduct ) {
		return '<img src="' . $this->get_largeimageurl( $myproduct ) . '" alt="' . esc_attr( $myproduct->title ) . '" />';
	}


	public function get_shorttitle( atkp_product $myproduct ) {
		$title = $this->get_title( $myproduct );

		if ( ATKPSettings::$short_title_length > 0 ) {
			return ( strlen( $title ) > ATKPSettings::$short_title_length ) ? substr( $title, 0, ATKPSettings::$short_title_length ) : $title;
		} else {
			return $title;
		}
	}

	public function get_bestseller_text( $itemIdx, $ignoreSettings = false ) {
		if ( ! $ignoreSettings && ( ( $itemIdx > 3 && ATKPSettings::$bestsellerribbon == 1 ) || $itemIdx <= 0 ) ) {
			return '';
		} else {
			return sprintf( __( '#%s Best Seller', ATKP_PLUGIN_PREFIX ), $itemIdx );
		}
	}

	public function get_bestseller_number( $itemIdx, $ignoreSettings = false ) {
		if ( ! $ignoreSettings && ( ( $itemIdx > 3 && ATKPSettings::$bestsellerribbon == 1 ) || $itemIdx <= 0 ) ) {
			return '';
		} else {
			return sprintf( __( '#%s', ATKP_PLUGIN_PREFIX ), $itemIdx );
		}
	}

	public function get_rating_text( atkp_product $myproduct ) {
		return sprintf( __( '%s of 5 stars', ATKP_PLUGIN_PREFIX ), $myproduct->rating );
	}

	public function get_star_rating( atkp_product $myproduct ) {
		$class = 'atkp-star-' . number_format( $this->roundRate( $myproduct->rating ), 1, ' atkp-star-0', '' );

		return '<span class="atkp-star ' . $class . '" title="' . $this->get_rating_text( $myproduct ) . '"></span>';
	}

	public function get_reviewstext( atkp_product $myproduct ) {
		if ( $myproduct->isownreview ) {

			if ( $myproduct->reviewsurl == '' ) {
				return '';
			} else {
				return __( 'Show review', ATKP_PLUGIN_PREFIX );
			}

		} else {
			$reviewstextNull = __( 'Show customer reviews', ATKP_PLUGIN_PREFIX );
			$reviewstext     = __( '%s customer reviews', ATKP_PLUGIN_PREFIX );
			$reviewstext2    = __( '1 customer review', ATKP_PLUGIN_PREFIX );

			if ( $myproduct->reviewcount == '' || $myproduct->reviewcount == 0 ) {

				if ( get_option( ATKP_PLUGIN_PREFIX . '_hideemptyrating', 0 ) ) {
					return '';
				} else {
					return $reviewstextNull;
				}

			} else {
				return sprintf( _n( $reviewstext2, $reviewstext, $myproduct->reviewcount, ATKP_PLUGIN_PREFIX ), $myproduct->reviewcount );

			}

		}
	}

	public function get_reviewslink( atkp_product $myproduct ) {
		if ( $myproduct->isownreview ) {

			if ( $myproduct->reviewsurl == '' ) {
				return '';
			}

			return 'href="' . $myproduct->reviewsurl . '" rel="noopener" title="' . __( 'Show review', ATKP_PLUGIN_PREFIX ) . '"';

		} else {
			return $this->create_external_link( $myproduct->customerreviewurl, $this->get_reviewstext( $myproduct ), $myproduct->title, $this->parameters->listid, $this->parameters->templateid, $myproduct->shopid, atkp_LinkType::Customerreview, $this->parameters->trackingid );
		}
	}

	public function get_reviewsmark( atkp_product $myproduct ) {
		if ( $myproduct->isownreview ) {
			return '';
		} else {
			return $this->get_mark();
		}
	}

	public function get_detailtext() {
		return get_option( ATKP_PLUGIN_PREFIX . '_productpage_title', __( 'View Product', ATKP_PLUGIN_PREFIX ) );
	}

	public function get_detailurl( atkp_product $myproduct ) {
		$detailurl = '';


		if ( $myproduct->productid != '' ) {
			if ( get_option( ATKP_PLUGIN_PREFIX . '_product_enabled', false ) == true ) {
				$detailurl = get_permalink( $myproduct->productid );
			} else {
				$postid = $myproduct->postids;


				if ( $postid != null ) {
					if ( is_array( $postid ) ) {
						foreach ( $postid as $p ) {
							$detailurl = get_permalink( $p );
							break;
						}

					} else {
						$detailurl = get_permalink( $postid );
					}
				}
			}
		}

		return $detailurl;
	}

	public function get_detaillink( atkp_product $myproduct ) {
		$detailurl = $this->get_detailurl( $myproduct );

		if ( $detailurl != '' ) {
			$detailurl = ' href="' . $detailurl . '" title="' . $myproduct->title . '"';
		}

		return $detailurl;
	}

	public function get_woocommerceurl( atkp_product $myproduct, $woo_product = null ) {

		if ( ! atkp_options::$loader->get_woo_module_enabled() || $myproduct->productid == '' ) {
			return '';
		}

		if ( $woo_product == null ) {
			$woo_product = atkp_product::get_woo_product( $myproduct->productid );
		}

		if ( $woo_product ) {
			return get_permalink( $woo_product->ID );
		} else {
			return '';
		}
	}

	public function get_woocommercetitle( atkp_product $myproduct, $woo_product = null ) {

		if ( ! atkp_options::$loader->get_woo_module_enabled() || $myproduct->productid == '' ) {
			return '';
		}

		if ( $woo_product == null ) {
			$woo_product = atkp_product::get_woo_product( $myproduct->productid );
		}

		if ( $woo_product ) {
			return $woo_product->post_title;
		} else {
			return '';
		}
	}

	public function get_woocommercelink( atkp_product $myproduct, $woo_product = null ) {
		$wooUrl = $this->get_woocommerceurl( $myproduct, $woo_product );
		if ( $wooUrl != '' ) {
			$wooTitle = $this->get_woocommercetitle( $myproduct, $woo_product );

			$wooUrl = ' href="' . $wooUrl . '" title="' . $wooTitle . '"';
		}

		return $wooUrl;
	}

	public function get_images( atkp_product $myproduct, $includemainimage = true, $maximages = 0 ) {
		$images = array();

		//include main image

		if ( $includemainimage ) {
			if ( $myproduct->smallimageurl != '' || $myproduct->mediumimageurl != '' || $myproduct->largeimageurl != '' ) {
				$mainimage                 = new atkp_product_image();
				$mainimage->smallimageurl  = $myproduct->smallimageurl;
				$mainimage->mediumimageurl = $myproduct->mediumimageurl;
				$mainimage->largeimageurl  = $myproduct->largeimageurl;

				array_push( $images, $mainimage );
			}
		}


		if ( is_array( $myproduct->images ) ) {
			foreach ( $myproduct->images as $image ) {
				if ( $image->smallimageurl == '' ) {
					$image->smallimageurl = $mainimage->mediumimageurl;
				}
				if ( $image->smallimageurl == '' ) {
					$image->smallimageurl = $mainimage->largeimageurl;
				}

				if ( $image->mediumimageurl == '' ) {
					$image->mediumimageurl = $mainimage->smallimageurl;
				}

				if ( $image->largeimageurl == '' ) {
					$image->largeimageurl = $mainimage->smallimageurl;
				}


				array_push( $images, $image );

				if ( $maximages > 0 && count( $images ) > $maximages ) {
					break;
				}
			}
		}

		return $images;
	}

	public function get_offercount( array $offers ) {
		return count( $offers ) == 1 ? sprintf( __( '%s offer', ATKP_PLUGIN_PREFIX ), count( $offers ) ) : sprintf( __( '%s offers', ATKP_PLUGIN_PREFIX ), count( $offers ) );

	}

	public function get_minoffer( atkp_product $myproduct, $includemainoffer = true, $alloffers = null ) {
		if ( $alloffers == null ) {
			$alloffers = $this->get_offers( $myproduct, $includemainoffer );
		}

		$minoffer = null;
		foreach ( $alloffers as $offer ) {
			if ( $minoffer == null || $minoffer->pricefloat >= $offer->pricefloat ) {
				$minoffer = $offer;
			}
		}

		return $minoffer;
	}

	public function get_maxoffer( atkp_product $myproduct, $includemainoffer = true, $alloffers = null ) {
		if ( $alloffers == null ) {
			$alloffers = $this->get_offers( $myproduct, $includemainoffer );
		}

		$maxoffer = null;
		foreach ( $alloffers as $offer ) {
			if ( $maxoffer == null || $maxoffer->pricefloat <= $offer->pricefloat ) {
				$maxoffer = $offer;
			}
		}

		return $maxoffer;
	}

	public function get_offers( atkp_product $myproduct, $includemainoffer = true, $maxoffers = 0 ) {
		if ( ! is_array( $myproduct->offers ) ) {
			$offers = array();
		} else {
			$offers = $myproduct->offers;
		}

		if ( $includemainoffer && $myproduct->salepricefloat > 0 ) {
			$offer              = new atkp_product_offer();
			$offer->ismainoffer = true;
			$offer->id          = $myproduct->productid;
			$offer->type        = 2;
			$offer->shopid      = $myproduct->shopid;
			$offer->number      = $myproduct->asin;

			$offer->shipping     = $myproduct->shipping;
			$offer->availability = $myproduct->availability;

			$offer->price         = $myproduct->saleprice;
			$offer->pricefloat    = $myproduct->salepricefloat;
			$offer->shippingfloat = $myproduct->shippingfloat;


			$offer->link  = $myproduct->producturl;
			$offer->title = $myproduct->title;

			array_push( $offers, $offer );
		}

		foreach ( $offers as $offer ) {
			if ( $offer->shopid == '' || ! atkp_shop::exists( $offer->shopid ) ) {
				continue;
			}
			try {
				$shopOffer = atkp_shop::load( $offer->shopid );
			} catch ( Exception $e ) {
				$shopOffer = null;
			}

			if ( $shopOffer != null && $shopOffer->holdontop ) {
				$offer->holdontop = true;
				break;
			}
		}

		usort( $offers, array( $this, "sortPrice" ) );


		//nur der erste shop wird angezeigt... so werden duplikate aufgrund zweier eans verhindert
		$shopsadded = array();

		usort( $offers, array( $this, "sortPriceWithOnTop" ) );

		$pricecomparisongroupshops = get_option( ATKP_PLUGIN_PREFIX . '_pricecomparisongroupshops', 1 );

		$newoffers = array();

		foreach ( $offers as $offer ) {
			if ( $offer->pricefloat == (float) 0 || $offer->hideoffer ) {
				continue;
			}

			if ( $pricecomparisongroupshops == 1 ) {
				if ( in_array( $offer->shopid, $shopsadded ) ) {
					continue;
				}
			}

			if ( ! atkp_shop::exists( $offer->shopid ) ) {
				continue;
			}

			$offer->shop = atkp_shop::load( $offer->shopid );

			array_push( $newoffers, $offer );
			array_push( $shopsadded, $offer->shopid );

			if ( $maxoffers > 0 && count( $newoffers ) > $maxoffers ) {
				break;
			}
		}


		return $newoffers;
	}


	public function get_bytext( atkp_product $myproduct ) {
		if ( $myproduct->manufacturer != '' ) {
			return sprintf( __( 'by %s', ATKP_PLUGIN_PREFIX ), $myproduct->manufacturer );
		} else if ( $myproduct->author != '' ) {
			return sprintf( __( 'by %s', ATKP_PLUGIN_PREFIX ), $myproduct->author );
		} else {
			return '';
		}
	}

	public function get_currency( $shopid ) {
		$currencysign = 1;

		if ( $shopid != '' ) {
			$shopids      = explode( '_', $shopid );
			$currencysign = ATKPTools::get_post_setting( $shopids[0], ATKP_SHOP_POSTTYPE . '_currencysign' );
		}

		$currencysymbol  = 'EUR ';
		$currencysymbol2 = '';

		switch ( $currencysign ) {
			default:
			case 1:
				$currencysymbol = '&euro; ';
				break;
			case 2:
				$currencysymbol = 'EUR ';
				break;
			case 3:
				$currencysymbol = '&#36 ';
				break;
			case 4:
				$currencysymbol = 'USD ';
				break;
			case 5:
				return null;
				break;
			case 6:
				$currencysymbol  = ATKPTools::get_post_setting( $shopids[0], ATKP_SHOP_POSTTYPE . '_currencysign_customprefix' );
				$currencysymbol2 = ATKPTools::get_post_setting( $shopids[0], ATKP_SHOP_POSTTYPE . '_currencysign_customsuffix' );
				break;
		}

		return array( 'prefix' => $currencysymbol, 'suffix' => $currencysymbol2 );

	}

	public function formatFloat( $number, $fallback, $shopid ) {
		$currency = $this->get_currency( $shopid );

		if ( $currency == null ) {
			return $fallback;
		}

		if ( $number == (float) 0 && $fallback != '' ) {
			$number = $this->price_to_float( $fallback );
		}

		return $currency['prefix'] . '' . number_format_i18n( $number, 2 ) . '' . $currency['suffix'];
	}

	private function startsWith( $haystack, $needle ) {
		// search backwards starting from haystack length characters from the end
		return $needle === "" || strrpos( $haystack, $needle, - strlen( $haystack ) ) !== false;
	}


	private function sortPriceWithOnTop( $a, $b ) {
		switch ( ATKPSettings::$pricecomparisonsort ) {
			case 1:
			default:
				$totalpriceA = $a->shippingfloat + $a->pricefloat;
				$totalpriceB = $b->shippingfloat + $b->pricefloat;
				break;
			case 2:
				$totalpriceA = $a->pricefloat;
				$totalpriceB = $b->pricefloat;
				break;
		}

		if ( $a->holdontop || $b->holdontop ) {
			return $a->holdontop ? - 1 : 1;
		}

		if ( $totalpriceA == $totalpriceB ) {
			return 0;
		}

		return ( $totalpriceA < $totalpriceB ) ? - 1 : 1;
	}

	private function sortPrice( $a, $b ) {
		switch ( ATKPSettings::$pricecomparisonsort ) {
			case 1:
			default:
				$totalpriceA = $a->shippingfloat + $a->pricefloat;
				$totalpriceB = $b->shippingfloat + $b->pricefloat;
				break;
			case 2:
				$totalpriceA = $a->pricefloat;
				$totalpriceB = $b->pricefloat;
				break;
		}

		if ( $totalpriceA == $totalpriceB ) {
			return 0;
		}

		return ( $totalpriceA < $totalpriceB ) ? - 1 : 1;
	}

	protected static function price_to_float( $s ) {
		$s = str_replace( ',', '.', $s );

		// remove everything except numbers and dot "."
		$s = preg_replace( "/[^0-9\.]/", "", $s );

		// remove all seperators from first part and keep the end
		$s = str_replace( '.', '', substr( $s, 0, - 3 ) ) . substr( $s, - 3 );

		// return float
		return round( (float) $s, 2 );
	}

	private static function replace_tracking_code( $shopid, $url, $tracking_id ) {

		if ( $tracking_id != '' ) {

			if ( $shopid == '' ) {
				throw new exception( 'shop is empty (tracking-replace): ' . $url );
			}


			$shop = atkp_shop::load( $shopid );

			$url = $shop->provider->replace_trackingid( $shop->settingid, $url, $tracking_id );
		}

		return $url;
	}

	private static function replace_image_url( $shopid, $url, $productid = null, $imagesize = null ) {

		$redirtype = ATKPTools::get_setting( ATKP_PLUGIN_PREFIX . '_product_imagetype', 0 );

		switch ( $redirtype ) {
			default:
				//disabled
				break;
			case 2:
				//no mainimage + internal redirect
				$sitekey = atkp_options::$loader->get_sitekey();

				$outfile = plugins_url( '/tools/atkp_imagereceiver.php', ATKP_PLUGIN_FILE );

				$site_key = ! isset( $_ENV['USER'] ) ? 'lökhdsöls' : $_ENV['USER'];

				$url = $outfile . '?image=' . rawurlencode( base64_encode( $url ) ) . '&hash=' . ( ( md5( $url . $site_key ) ) );

				break;
			case 3:
				//mainimage + internal redirect

				if ( $productid != null ) {

					//hauptbild laden
					switch ( $imagesize ) {
						case 'small':
							$url = get_the_post_thumbnail_url( $productid, 'thumbnail' );
							break;
						default:
						case 'medium':
							$url = get_the_post_thumbnail_url( $productid, 'medium' );
							break;
						case 'large':
							$url = get_the_post_thumbnail_url( $productid, 'full' );
							break;
					}
				}
				break;
		}

		return $url;
	}

	private static function replace_external_url( $shopid, $url ) {

		if ( $url == '' ) {
			return $url;
		}

		$redirtype = ATKPTools::get_post_setting( $shopid, ATKP_SHOP_POSTTYPE . '_redirectiontype' );

		switch ( $redirtype ) {
			default:
				//disabled
				break;
			case 2:
				//internal redirect

				$outfile = plugins_url( '/tools/atkp_out.php', ATKP_PLUGIN_FILE );

				$url = $outfile . '?out=' . rawurlencode( base64_encode( $url ) );

				break;
			case 3:
			case 4:
			case 5:
			case 6:
				//generated in background
				break;
		}

		return $url;
	}

	private static function create_external_link( $url, $title, $productid, $listid, $templateid, $shopid, $linktype, $tracking_id = '' ) {
		if ( ATKPSettings::$open_window ) {
			$target = 'target="_blank"';
		} else {
			$target = '';
		}

		if ( $tracking_id != '' ) {
			//TODO: shop laden und replace mit trackingid aufrufen
			//TODO: Shop direkt von der übergeordneten methode übernehmen wenn vorhanden

			$url = self::replace_tracking_code( $shopid, $url, $tracking_id );
		}

		$shoptext = '';

		if ( is_numeric( $shopid ) ) {
			$shoptext .= get_the_title( $shopid );

			$url = self::replace_external_url( $shopid, $url );
		} else {
			$shoptext = $shopid;
		}


		$tracking       = '';
		$trackingparams = '\'\',\'\'';

		switch ( ATKPSettings::$linktracking ) {
			case 0:
				break;
			case 1:
			case 2:
			case 3:
				//universal tracking

				$linktypetext = '';

				switch ( (int) $linktype ) {
					default:
					case 1:
						$linktypetext = __( 'Link', ATKP_PLUGIN_PREFIX );
						break;
					case 2:
						$linktypetext = __( 'Offer', ATKP_PLUGIN_PREFIX );
						break;
					case 3:
						$linktypetext = __( 'Cart', ATKP_PLUGIN_PREFIX );
						break;
					case 4:
						$linktypetext = __( 'Customer review', ATKP_PLUGIN_PREFIX );
						break;
					case 5:
						$linktypetext = __( 'Image', ATKP_PLUGIN_PREFIX );
						break;
				}


				if ( is_numeric( $templateid ) && ATKP_PLUGIN_VERSION >= 30 ) {
					$linktypetext .= ' (' . get_the_title( $templateid ) . ', ' . $shoptext . ')';
				} else if ( $templateid != '' ) {
					$templatetext = $templateid;

					switch ( $templateid ) {
						case 'bestseller':
							$templatetext = __( 'bestseller', ATKP_PLUGIN_PREFIX );
							break;
						case 'wide':
							$templatetext = __( 'wide', ATKP_PLUGIN_PREFIX );
							break;
						case 'secondwide':
							$templatetext = __( 'secondwide', ATKP_PLUGIN_PREFIX );
							break;
						case 'box':
							$templatetext = __( 'box', ATKP_PLUGIN_PREFIX );
							break;
						case 'detailoffers':
							$templatetext = __( 'all offers', ATKP_PLUGIN_PREFIX );
							break;
					}

					$linktypetext .= ' (' . $templateid . ', ' . $shoptext . ')';
				} else {
					$linktypetext = __( 'Textlink', ATKP_PLUGIN_PREFIX ) . ' (' . $shoptext . ')';
				}

				$listcaption = '';

				if ( is_numeric( $listid ) ) {
					$listcaption = get_the_title( $listid );
				}

				if ( $listid != '' && $listcaption == '' ) {
					$listcaption = $listid;
				}

				$productcaption = '';

				if ( is_numeric( $productid ) ) {
					$productcaption = ATKPTools::get_post_setting( $productid, ATKP_PRODUCT_POSTTYPE . '_title' );
				} else if ( $productid != '' ) {
					$productcaption = $productid;
				} else {
					$productcaption = '-';
				}

				$finalcaption = $productcaption;

				if ( $listcaption != '' ) {
					$finalcaption .= ' (' . $listcaption . ')';
				}

				$finalcaption = str_replace( '"', '_', $finalcaption );
				$finalcaption = str_replace( '\'', '_', $finalcaption );

				$trackingparams = '\'' . $linktypetext . '\', \'' . $finalcaption . '\'';

				switch ( ATKPSettings::$linktracking ) {
					case 1:
						$tracking = 'onclick="ga(\'send\', \'event\', \'' . $linktypetext . '\', \'click\', \'' . $finalcaption . '\');"';
						break;
					case 2:
						$tracking = 'onclick="_gaq.push([\'_trackEvent\', \'' . $linktypetext . '\', \'click\', \'' . $finalcaption . '\']);"';
						break;
					case 3:
						$tracking = 'onclick="gtag(\'event\', \'' . $linktypetext . '\', {  \'event_category\' : \'click\',\'event_label\' : \'' . $finalcaption . '\'});"';
						break;
				}


				//https://developers.google.com/analytics/devguides/collection/gtagjs/events

				break;
		}

		//atkp_open_link

		if ( ATKPSettings::$jslink ) {
			$link = ' style="cursor: pointer;" onclick="atkp_open_link(\'' . self::urlencode( $url ) . '\', \'_blank\', ' . ATKPSettings::$linktracking . ', ' . $trackingparams . ');" title="' . $title . '"';
		} else {
			$link = 'href="' . self::urlencode( $url ) . '" rel="'.self::get_link_rel().'" ' . $target . ' ' . $tracking . ' title="' . $title . '"';
		}

		return $link;
	}

	public function get_variationname( $product, $glue = ', ' ) {
		if ( $product->variationname != '' && ! is_array( $product->variationname ) ) {
			$product->variationname = unserialize( $product->variationname );
		}

		$displaylist = array();
		foreach ( $product->variationname as $key => $value ) {
			array_push( $displaylist, htmlentities( $value ) );
		}

		return implode( $glue, $displaylist );
	}

	public function minifyvariations( $variations, $ignoreVariation = '' ) {
		if ( $ignoreVariation == '' || $variations == null || count( $variations ) == 0 ) {
			return $variations;
		}

		$filtered = array();
		$arr      = array();

		foreach ( $variations as $variation ) {
			$vararray = $variation->variationname;
			if ( $vararray != '' && ! is_array( $vararray ) ) {
				$vararray = unserialize( $vararray );
			}

			if ( isset( $vararray[ $ignoreVariation ] ) && count( $vararray ) > 1 ) {
				unset( $vararray[ $ignoreVariation ] );
			}

			$variation->variationname = $vararray;

			$newname = $this->get_variationname( $variation );

			if ( isset( $arr[ $newname ] ) ) {
				continue;
			}

			$arr[ $newname ] = $variation;

			array_push( $filtered, $variation );
		}

		return $filtered;
	}

	private static function urlencode( $u ) {
		//$u = str_replace('%', '%25', $u);

		return $u;
	}


	public function get_randomarray( $array, $count ) {
		if ( $array == null || count( $array ) <= $count ) {
			return $array;
		}

		$keys = array_rand( $array, $count );

		$newarray = array();

		foreach ( $keys as $key ) {
			array_push( $newarray, $array[ $key ] );
		}

		return $newarray;
	}

	private function roundRate( $rate ) {
		$rate = round( ( $rate * 2 ), 0 ) / 2;

		return $rate;
	}

	public function get_minpricedays( $product ) {
		$history = atkp_product_pricehistory::get_lastxdays_history( $product->productid, false, 30 );
		$history = array_reverse( $history );

		$foundhistory = null;
		$prevhistory  = null;
		$lasthistory  = count( $history ) == 0 ? null : $history[0];
		$i            = 0;
		foreach ( $history as $historyentry ) {
			if ( $historyentry->shopid == $product->shopid ) {
				if ( $product->salepricefloat == $historyentry->pricefloat ) {
					$foundhistory = $historyentry;
					$prevhistory  = $history[ $i + 1 ];
				}
			}
			$i ++;
		}
		if ( $foundhistory != null && $prevhistory == null ) {
			$prevhistory = $foundhistory;
		}
		if ( $foundhistory == null || $prevhistory == null ) {
			return '';
		}

		if ( $foundhistory->pricefloat > $prevhistory->pricefloat ) {
			return 'Preis ist von ' . $prevhistory->pricefloat . ' auf ' . $lasthistory->pricefloat . ' gestiegen.';
		} else if ( $foundhistory->pricefloat < $prevhistory->pricefloat ) {
			return 'Preis ist von ' . $prevhistory->pricefloat . ' auf ' . $lasthistory->pricefloat . ' gesunken.';
		} else {
			$date1 = new DateTime( $lasthistory->createdon );
			$date2 = new DateTime( "2010-07-09" );

			$difference = $date1->diff( $date2 );

			return 'Preis ist seit ' . $difference->d . ' Tagen konstant.';
		}

	}

	public function get_lastxdays_pricehistory( $product, $minifier_shops = false, $days = 30 ) {
		$history = atkp_product_pricehistory::get_lastxdays_history( $product->productid, $minifier_shops, $days );

		$shopids = array();
		$months  = array();


		for ( $i = 0; $i < $days; $i ++ ) {
			$timestamp = time();
			$tm        = 86400 * $i; // 60 * 60 * 24 = 86400 = 1 day in seconds
			$tm        = $timestamp - $tm;

			$months[] = date( "d.m.", $tm );
		}
		$months = array_reverse( $months );


		foreach ( $history as $historyentry ) {

			if ( ! in_array( $historyentry->shopid, $shopids ) ) {
				array_push( $shopids, $historyentry->shopid );
			}
		}

		foreach ( $history as $historyentry ) {
			$groupname    = $historyentry->groupname;
			$parts        = explode( '-', $groupname );
			$month_number = intval( $parts[1] );
			$day_number   = intval( $parts[2] );

			$groupname = $day_number . "." . ( count( $month_number ) == 1 ? '0' . $month_number : $month_number ) . ".";

			if ( ! in_array( $groupname, $months ) ) {
				//array_push( $months, $groupname );
			}
			$historyentry->groupname = $groupname;
		}


		$labels = '';
		$data   = '';

		foreach ( $months as $month ) {
			if ( $labels != '' ) {
				$labels .= ',';
			}

			$labels .= '\'' . $month . '\'';
		}

		foreach ( $shopids as $shopid ) {
			$shop = atkp_shop::load( $shopid, true );

			if ( $data != '' ) {
				$data .= ',';
			}

			$color    = '#' . $this->get_random_color();
			$shopname = $shop->get_title();

			if ( $minifier_shops ) {
				$shopname = __( 'All Shops', ATKP_PLUGIN_PREFIX );
			}

			$data .= '{
			                label: \'' . esc_html( $shopname ) . '\',
			                borderColor: \'' . $color . '\',
			                backgroundColor: \'' . $color . '\',
			                fill: false,
			                data: [';

			$priceval = 0;
			$tempdata = '';
			foreach ( $months as $month ) {

				foreach ( $history as $historyentry ) {
					if ( $historyentry->groupname == $month && $historyentry->shopid == $shopid ) {

						$priceval = $historyentry->pricefloat;
					}
				}

				$tempdata .= $priceval . ',';
			}

			if ( $priceval == 0 ) {
				$tempdata = '';

				foreach ( $history as $historyentry ) {
					if ( $historyentry->pricefloat > 0 ) {

						$priceval = $historyentry->pricefloat;
					}
				}
				foreach ( $months as $month ) {
					$tempdata .= $priceval . ',';
				}

			}

			$data .= $tempdata;

			$data .= '],
			                yAxisID: \'y-axis-1\',
			            }';
		}

		$full = 'labels: [' . $labels . '],
            datasets: [' . $data . ']';

		return $full;
	}

	public function get_monthly_pricehistory( $product, $minifier_shops = false ) {

		$history = atkp_product_pricehistory::get_monthly_history( $product->productid, $minifier_shops );

		$shopids = array();
		$months  = array();


		for ( $i = 0; $i < 6; $i ++ ) {

			$monthtemp = date( "Y-m", strtotime( date( 'Y-m-01' ) . " -$i months" ) );

			$parts        = explode( '-', $monthtemp );
			$month_number = intval( $parts[1] );

			global $wp_locale;
			$var = $wp_locale->get_month( $month_number );

			$groupname = $var . " " . $parts[0];

			$months[] = $groupname;
		}
		$months = array_reverse( $months );

		foreach ( $history as $historyentry ) {

			if ( ! in_array( $historyentry->shopid, $shopids ) ) {
				array_push( $shopids, $historyentry->shopid );
			}
		}

		foreach ( $history as $historyentry ) {
			$groupname    = $historyentry->groupname;
			$parts        = explode( '-', $groupname );
			$month_number = intval( $parts[1] );

			global $wp_locale;
			$var = $wp_locale->get_month( $month_number );

			$groupname = $var . " " . $parts[0];

			if ( ! in_array( $groupname, $months ) ) {
				array_push( $months, $groupname );
			}
			$historyentry->groupname = $groupname;
		}


		$labels = '';
		$data   = '';

		foreach ( $months as $month ) {
			if ( $labels != '' ) {
				$labels .= ',';
			}

			$labels .= '\'' . $month . '\'';
		}

		foreach ( $shopids as $shopid ) {
			$shop = atkp_shop::load( $shopid, true );

			if ( $data != '' ) {
				$data .= ',';
			}

			$color    = '#' . $this->get_random_color();
			$shopname = $shop->get_title();

			if ( $minifier_shops ) {
				$shopname = __( 'All Shops', ATKP_PLUGIN_PREFIX );
			}

			$data .= '{
			                label: \'' . esc_html( $shopname ) . '\',
			                borderColor: \'' . $color . '\',
			                backgroundColor: \'' . $color . '\',
			                fill: false,
			                data: [';

			$priceval = 0;
			foreach ( $months as $month ) {

				foreach ( $history as $historyentry ) {
					if ( $historyentry->groupname == $month && $historyentry->shopid == $shopid ) {

						$priceval = $historyentry->pricefloat;
					}
				}

				$data .= $priceval . ',';
			}

			$data .= '],
			                yAxisID: \'y-axis-1\',
			            }';
		}

		$full = 'labels: [' . $labels . '],
            datasets: [' . $data . ']';

		return $full;

	}

	private function random_color_part() {
		return str_pad( dechex( mt_rand( 0, 255 ) ), 2, '0', STR_PAD_LEFT );
	}

	public function get_random_color() {
		return $this->random_color_part() . $this->random_color_part() . $this->random_color_part();
	}
}


abstract class atkp_LinkType {
	const Link = 1;
	const Offer = 2;
	const Cart = 3;
	const Customerreview = 4;
	const Image = 5;
}